/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def btsTask = props['btsTask']? props['btsTask'] : 'btsTask.exe'
def applicationName = props['applicationName'].trim();
def assemblyName = props['assemblyName'];
def destination = props['destination'].trim();
def database = props['database'].trim();
def server = props['server'].trim();
def groupLevel = props['groupLevel'];
def globalParties = props['globalParties'];
try {
    def commandHelper = new CommandHelper(new File('.'));
    def args = [];
    args = [btsTask, 'ExportBindings', '/Destination:' + destination];
    //optional parameters
    if (server) {
        args << '/Server:' + server
    }
    if (database) {
        args << '/Database' +  database
    }
   if (groupLevel) {
        args << '/GroupLevel'
    }
    if (applicationName) {
        args << '/ApplicationName:' + applicationName
    }
    if (assemblyName) {
        args << '/AssemblyName:' + assemblyName
    }
    if (globalParties) {
        args << '/GlobalParties:' + globalParties
    }
    exitcode = commandHelper.runCommand("Exporting BizTalk application bindings for ${applicationName}", args);
    System.exit(exitcode);
    }
catch (e) {
    println (e);
    System.exit(1);
}

