/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def btsTask = props['btsTask']? props['btsTask'] : 'btsTask.exe'
def type = props['type'];
def application = props['application'].trim();
def overwrite = props['overwrite'];
def source = props['source'].trim();
def destination = props['destination'].trim();
def options = props['options'].trim();
def database = props['database'].trim();
def server = props['server'].trim();
def targetEnv = props['targetEnv'].trim();
def thumb = props['thumb'].trim();
def argList = props['argList'];
def policy = props['policy'];
def version = props['version'];
try {
    def commandHelper = new CommandHelper(new File('.'));
    def args = [];

    switch (type) {
        case 'BizTalk Assembly':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:BizTalkAssembly', '/Source:' + source];
            break;
        case 'BizTalk Binding':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:BizTalkBinding', '/Property:TargetEnvironment=' + targetEnv, '/Source:' + source];
            break;
        case '.NET Assembly':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:Assembly', '/Source:' + source];
            break;
        case 'BAM Artifact':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:Bam', '/Source:' + source];
            break;
        case 'Certificate':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:Certificate', '/Thumbprint:' + thumb];
            break;
        case 'COM Component':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:Com', '/Source:' + source];
            break;
        case 'File':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:File', '/Source:' + source];
            break;
        case 'PreProcessing Script':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:PreProcessingScript', '/Source:' + source];
            break;
        case 'PostProcessing Script':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:PostProcessingScript', '/Source:' + source];
            break;
        case 'Policy':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:Rules', '/Name:' + policy, '/Version:' + version];
            break;
        case 'Virtual Directory':
            args = [btsTask, 'AddResource', '/Type:System.BizTalk:WebDirectory', '/Source:' + source];
            break;
    }

    //optional parameters
    if (application) {
        args << '/ApplicationName:' + application
    }
    if (overwrite) {
        args << '/Overwrite'
    }
    if (server) {
        args << '/Server:' + server
    }
    if (database) {
        args << '/Database:' + database
    }
    if ((type == 'PreProcessing Script' || type == 'PostProcessing Script') && argList) {
        args << '/Property:Args=' + argList
    }
    if ((type == 'BizTalk Assembly' || type == '.NET Assembly' || type == 'COM Component') && options) {
        args << '/Options:' + options
    }
    if ((type != 'BizTalk Binding' && type != 'Certificate' && type != 'Policy') && destination) {
        args << '/Destination:' + destination
    }

    commandHelper.runCommand("Adding ${type} resource", args);
}
catch (e) {
    println(e);
    System.exit(1);
}

