/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.CommandHelper
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def btsTask = props['btsTask']? props['btsTask'] : 'btsTask.exe'
def application = props['application'].trim();
def source = props['source'].trim();
def groupLevel = props['groupLevel'];
def database = props['database'].trim();
def server = props['server'].trim();
try {
    def commandHelper = new CommandHelper(new File('.'));
    def args = [];
    args = [btsTask,'ImportBindings', '/Source:'+ source];
    //optional parameters
    if (server) {
        args << '/Server:' + server
    }
    if (database) {
        args << '/Database:' + database
    }
    if (application) {
        args << '/ApplicationName:' + application
    }
    else if (groupLevel) {
        args << '/GroupLevel'
    }
    commandHelper.runCommand("Adding Import Bindings, ${source}", args);
}
catch (e) {
    println(e);
    System.exit(1);
}

