function app-stop {
	#Stops orchestrations
	foreach ($orchName in $orchestrations)
	{
		$orch = Get-WmiObject MSBTS_Orchestration -n root\MicrosoftBizTalkServer -filter "Name='$orchName'"
		if ($orch.OrchestrationStatus -ne "2") {
			if ($orch.OrchestrationStatus -eq "3" -or $orch.OrchestrationStatus -eq "4") {
				if ($orch.OrchestrationStatus -eq "4"){
				$orch.Stop()
				}

			$orch.Unenlist()
			}
		}
		else {
		Write-Host "Orchestration already stopped and unenlisted"
		}
	}
	#Stops Send Ports
	foreach ($portName in $sendports) {
		$sp = Get-WmiObject MSBTS_SendPort -n root\MicrosoftBizTalkServer -filter "Name='$portName'"
		if ($sp.Status -ne "1") {
			if ($sp.Status -eq "3" -or $sp.Status -eq "2") {
				if ($sp.Status -eq "2") {
				$sp.Stop()
				}

			$sp.Unenlist()
			}
		}
		else {
		Write-Host "Send ports are already disabled and stopped"
		}

	}

	#Disables receive Ports
	foreach ($locationName in $receiveLocations){
		$rec = get-wmiobject MSBTS_ReceiveLocation -n root\MicrosoftBizTalkServer -filter "Name='$locationName'"
            try {
                $rec.Disable()
            }
            catch {
                Write-Host "Receive ports are already disabled"
            }
	}
}
function app-import{
	#Imports msi
	Write-Host "Starting App import"
	$msiImport = $btsTask + " ImportApp /Package:'$file' /Overwrite /A:'$appName' /D:'$btDatabase' /S:'$btDbServer'"
	Write-Host $msiImport
        Invoke-Expression $msiImport
        if ($LastExitCode -ne 0) {
            Write-Host "Failed to import Application"
            exit 1
        }
	Write-Host "App import complete"
}
function app-start{
        Write-Host "Starting App..."
	#Starts Send Ports
	foreach ($portName in $sendports){
		$sp = Get-WmiObject MSBTS_SendPort -n root\MicrosoftBizTalkServer -filter "Name='$portName'"
		if ($sp.Status -ne "3")	{
			if ($sp.Status -eq "1" -or $sp.Status -eq "2") {
				if ($sp.Status -eq "1") {
				    $sp.Enlist
				}
			    $sp.Start()
			}
		    else {
		        write-host "Send ports already enlisted and started"
		    }
		}
	}
        Write-Host " Enabling receive locations..."
	#Enables Receive locations
	foreach ($locationName in $receiveLocations) {
		$rec = get-wmiobject MSBTS_ReceiveLocation -n root\MicrosoftBizTalkServer -filter "ReceivePortName='$locationName'"
            try {
                $rec.Enable()
            }
            catch {
                Write-Host "Could not start app"
                exit 1
            }
	}

        Write-Host " Starting orchestrations..."
	#Starts orchestrations
	foreach ($orchName in $orchestrations){
		$orch = Get-WmiObject MSBTS_Orchestration -n root\MicrosoftBizTalkServer -filter "Name='$orchName'"
		if ($orch.OrchestrationStatus -ne "4"){
			if ($orch.OrchestrationStatus -eq "2" -or $orch.OrchestrationStatus -eq "3") {
				if ($orch.OrchestrationStatus -eq "2") {
				$orch.Enlist()
				}
			$orch.Start()
			}
		}
		Else
		{
		Write-Host "Orchestration is already enlisted and started"
		}
	}
        Write-Host "App Started"
}
function host-restart {
	#restarts host instance
	$instancehost = Get-WmiObject MSBTS_HostInstance -n 'root\MicrosoftBizTalkServer' -filter HostType=1
	$instancehost.Stop()
	$instancehost.Start()
}
function local-install {
	#installs local msi
	Write-Host "starting local install"
	$msiinstall = "msiexec /q /i '$file'"
        Write-Host $msiInstall
        Invoke-Expression $msiinstall
        if ($LastExitCode -ne 0) {
            Write-Host "Failed to install msi"
            exit 1
        }
	Write-Host "local install complete"
}
function app-binding {
	$bindingimport = $btsTask + " ImportBindings /So:'$file' /A:'$appName' "
	    if ($btDatabase -ne ".") {
            $bindingimport+=" /Database:'$btDatabase' "
        }
        if ($btDbServer -ne ".") {
            $bindingimport+=" /Server:'$btDbServer' "
        }
        Invoke-Expression $bindingimport
        
        if ($LastExitCode -ne 0) {
            Write-Host "Failed to import bindings"
            exit 1
        }

}
function get-values {
	Write-Host "Querying BizTalk Application"
	#clear array variables
	$orchestrations.Clear()
	$sendports.Clear()
	$receiveLocations.Clear()

        $btsCatExp = New-Object Microsoft.BizTalk.ExplorerOM.BtsCatalogExplorer
        $connectionString = "Integrated Security=SSPI;database="+ $btDatabase +";server="+ $btDbServer
        $btsCatExp.ConnectionString = $connectionString

	$SendPortList = $btsCatExp.Applications[$appName].SendPorts
	$OrchestrationsList = $btsCatExp.Applications[$appName].Orchestrations
	$ReceivePortList = $btsCatExp.Applications[$appName].ReceivePorts

        if ($SendPortList.Count -eq 0) {
            Write-Host "Warning: Application contains no send ports"
        }
        if ($OrchestrationsList.Count -eq 0) {
            Write-Host "Warning: Application contains no orchestrations"
        }
        if ($ReceivePortList.Count -eq 0) {
            Write-Host "Warning: Application contains no receive ports"
        }

	foreach ($i in $SendPortList) {
		$sendports.Add($i.Name)
	}
	foreach ($i in $OrchestrationsList) {
		$orchestrations.Add($i.FullName)
	}
	foreach ($i in $ReceivePortList){
		$receiveLocations.Add($i.Name)
	}
}

$appName = $args[0]
$file= $args[1]
$btsTask = $args[2]
$btDbServer = $args[3]
$btDatabase = $args[4]

$orchestrations = New-Object System.Collections.ArrayList
$sendports = New-Object System.Collections.ArrayList
$receiveLocations = New-Object System.Collections.ArrayList
[Reflection.Assembly]::LoadWithPartialName("Microsoft.BizTalk.ExplorerOM")

$btsCatExp = New-Object Microsoft.BizTalk.ExplorerOM.BtsCatalogExplorer
$connectionString = "Integrated Security=SSPI;database="+ $btDatabase +";server="+ $btDbServer
$btsCatExp.ConnectionString = $connectionString

if ($btsCatExp.Applications[$appName] -ne $null -and $file -match ".msi"){
	$action = "patch"
}
elseif ($btsCatExp.Applications[$appName] -eq $null -and $file -match ".msi"){
	$action = "import"
}
elseif ($btsCatExp.Applications[$appName] -ne $null -and $file -match ".xml"){
	$action = "binding"
}

Switch($action)
{
	"import" {
	    app-import
            exit 0
	}

	"patch" {
	    get-values
	    app-stop
	    app-import
	    #local-install
	    #host-restart
	    #get-values
            exit 0
	}

	"binding" {
	    app-binding
            exit 0
	}

	"start" {
	    get-values
	    app-start
            exit 0
	}

	"stop" {
	    get-values
	    app-stop
            exit 0
	}

	default {
	    Write-Host "Invalid file or application name"
            exit 1
	}
}
