/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.runtime.CMConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigurationConnectionManager {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ConfigurationConnectionManager configurationConnectionManager;
    private CMConnection connection;
    private List<Map<String, String>> connectionObjects;
    CMConnection.Listener connectionObjectListener = new CMConnection.Listener(){

        @Override
        public void connectionObjectsChanged(List<Map<String, String>> connectionObjects) {
            ConfigurationConnectionManager.this.setConnectionObjects(connectionObjects);
        }
    };
    private Map<String, ConfigurationConnection> connectionNamesMap = new HashMap<String, ConfigurationConnection>();
    private Map<String, ConfigurationConnection> connectionApplidMap = new HashMap<String, ConfigurationConnection>();

    public static ConfigurationConnectionManager getCurrent() {
        if (configurationConnectionManager == null) {
            configurationConnectionManager = new ConfigurationConnectionManager();
        }
        return configurationConnectionManager;
    }

    public void setConnection(CMConnection cmConnection) {
        if (this.connection != null) {
            this.connection.removeConnectionObjectListener(this.connectionObjectListener);
        }
        this.connection = cmConnection;
        if (this.connection != null) {
            this.connection.addConnectionObjectListener(this.connectionObjectListener);
            this.setConnectionObjects(this.connection.getConnectionObjects());
        }
    }

    protected void setConnectionObjects(List<Map<String, String>> connectionObjects) {
        this.connectionNamesMap.clear();
        for (Map<String, String> map : connectionObjects) {
            ConfigurationConnection configurationConnection = new ConfigurationConnection(map);
            String name = configurationConnection.getName();
            this.connectionNamesMap.put(name, configurationConnection);
            String applid = configurationConnection.getApplid();
            this.connectionApplidMap.put(applid, configurationConnection);
        }
    }

    public ConfigurationConnection getConfigurationConnection(String mROLink) {
        return this.connectionNamesMap.get(mROLink);
    }

    public ConfigurationConnection getConfigurationConnectionForApplid(String applid) {
        return this.connectionApplidMap.get(applid);
    }
}

