/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ICMListFactory;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FilteredCollection<E>
implements IFilteredCollection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static List<ICMObject> EMPTY_LIST = new ArrayList<ICMObject>();
    private List<E> results;
    protected ICMListFactory listFactory;
    protected RestrictionCriteria restrictionCriteria;

    public FilteredCollection(ICMListFactory aListFactory) {
        this.listFactory = aListFactory;
    }

    @Override
    public void setObjectName(String objectName) {
        if (this.results != null) {
            throw new RuntimeException("Object Name cannot be set once results have been retrieved");
        }
        this.listFactory.setObjectName(objectName);
    }

    @Override
    public void addUniqueRestrictionField(String fieldName, FilterExpression.Operator operator, String value) {
        if (this.results != null) {
            throw new RuntimeException("Restriction fields cannot be added once results have been retrieved");
        }
        this.listFactory.addUniqueRestrictionField(fieldName, operator, value);
    }

    @Override
    public void addRestrictionField(String fieldName, FilterExpression.Operator operator, String value) {
        if (this.results != null) {
            throw new RuntimeException("Restriction fields cannot be added once results have been retrieved");
        }
        this.listFactory.addRestrictionField(fieldName, operator, value);
    }

    @Override
    public void setObjectType(String objectType) {
        if (this.results != null) {
            throw new RuntimeException("Object Type cannot be set once results have been retrieved");
        }
        this.listFactory.setObjectType(objectType);
    }

    @Override
    public List<E> getResults() {
        if (this.results == null) {
            this.results = this.retrieveResults();
        }
        if (this.results == null) {
            return EMPTY_LIST;
        }
        return this.results;
    }

    @Override
    public Iterator<E> iterator() {
        return this.getResults().iterator();
    }

    private List<E> retrieveResults() {
        try {
            return this.listFactory.getResults();
        }
        catch (CMServerListException cMServerListException) {
            return null;
        }
    }

    @Override
    public int size() {
        return this.getResults().size();
    }

    @Override
    public E get(int index) {
        return this.getResults().get(index);
    }

    @Override
    public E[] toArray() {
        Object[] resultsAsObjectArray = this.getResults().toArray();
        ICMObject[] resultsAsCMObjectArray = new ICMObject[resultsAsObjectArray.length];
        System.arraycopy(resultsAsObjectArray, 0, resultsAsCMObjectArray, 0, resultsAsObjectArray.length);
        return resultsAsCMObjectArray;
    }

    @Override
    public void setRestrictionCriteriaList(RestrictionCriteriaList restrictionCriteriaList) {
        if (this.results != null) {
            throw new RuntimeException("Restriction fields cannot be added once results have been retrieved");
        }
        this.listFactory.setRestrictionCriteriaList(restrictionCriteriaList);
    }

    @Override
    public void addRestrictionCriteria(IRestrictionCriteria iRestrictionCriteria) {
        if (this.results != null) {
            throw new RuntimeException("Restriction criteria cannot be added once results have been retrieved");
        }
        this.listFactory.addRestrictionCriteria(iRestrictionCriteria);
    }

    @Override
    public void setJournalObjectGroup(String objectGroup) {
        if (this.results != null) {
            throw new RuntimeException("Resource group cannot be set once results have been retrieved");
        }
        this.listFactory.setJournalObjectGroup(objectGroup);
    }

    @Override
    public void setJournalObjectName(String objectName) {
        if (this.results != null) {
            throw new RuntimeException("Resource name cannot be set once results have been retrieved");
        }
        this.listFactory.setJournalObjectName(objectName);
    }

    @Override
    public void setJournalObjectType(String objectType) {
        if (this.results != null) {
            throw new RuntimeException("Resource type cannot be set once results have been retrieved");
        }
        this.listFactory.setJournalObjectType(objectType);
    }

    @Override
    public void setObjectGroup(String resourceGroupName) {
        if (this.results != null) {
            throw new RuntimeException("Resource group cannot be set once results have been retrieved");
        }
        this.listFactory.setObjectGroup(resourceGroupName);
    }
}

