/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.Messages;
import com.ibm.cics.cm.model.PackageScheme;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.RestrictionElementList;
import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class PackageSchemeEvent
implements IHistoryProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String WILD = "*";
    private static String[] eventAttribs = new String[]{"CH_APICMD", "CH_DATIME", "CH_USERID", "CH_EVID", "CH_RC", "CH_RSN"};
    private Map<String, String> attributes = null;
    private PackageScheme parent = null;
    private Map<String, String> eventEndAttributes = null;
    protected static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");

    public PackageSchemeEvent(PackageScheme parent, Map<String, String> map) {
        this.attributes = map;
        this.parent = parent;
        if (this.attributes.get("CH_APICMD").equals("BACKOUT")) {
            this.getBackoutEventEnd();
        }
    }

    private void getBackoutEventEnd() {
        Job job = new Job(Messages.getString("PackageSchemeEvent.job.backoutEventEnd")){

            protected IStatus run(IProgressMonitor monitor) {
                LocationCriteria locationCriteria = LocationCriteria.newJournalLocationCriteria();
                JournalCriteria journalCriteria = JournalCriteria.newJournalEventEndCriteriaForPackageEvent();
                Map<String, String> pschemeAttribs = PackageSchemeEvent.this.parent.getAttributes();
                String origEventTime = (String)PackageSchemeEvent.this.attributes.get("CH_DATIME");
                Date origDate = CMUtilities.asDatayyyyMMddHHmmssSS(origEventTime);
                if (origDate == null) {
                    return Status.OK_STATUS;
                }
                String fromEarlier = CMUtilities.toStringyyyyMMddHHmmssDate(origDate);
                Calendar calendarFormat = Calendar.getInstance();
                calendarFormat.setTime(origDate);
                calendarFormat.add(13, 2);
                String toLater = CMUtilities.toStringyyyyMMddHHmmssDate(calendarFormat.getTime());
                RestrictionElementList restrictionElementList = new RestrictionElementList();
                restrictionElementList.add(new RestrictionCriteria("JNLAPI_COMMAND", FilterExpression.Operator.EQ, PackageSchemeEvent.this.getAttribute(EventAttribute.CH_APICMD)));
                restrictionElementList.add(new RestrictionCriteria("JNLCPID", FilterExpression.Operator.EQ, pschemeAttribs.get("CPID")));
                restrictionElementList.add(new RestrictionCriteria("JNLSCHEME", FilterExpression.Operator.EQ, pschemeAttribs.get("SCHEME")));
                restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.GE, fromEarlier));
                restrictionElementList.add(new RestrictionCriteria("JNLCREATETIME", FilterExpression.Operator.LE, toLater));
                RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
                restrictionCriteriaList.add(restrictionElementList);
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(locationCriteria, journalCriteria, restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getHistory", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    new ArrayList();
                    while (iterator.hasNext()) {
                        PackageSchemeEvent.this.eventEndAttributes = iterator.next();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public PackageScheme getParentScheme() {
        return this.parent;
    }

    public String getAttribute(EventAttribute key) {
        return this.getAttribute(key.toString());
    }

    public String getAttribute(String key) {
        if (!key.matches("CPID")) {
            return this.attributes.get(key);
        }
        return this.parent.getAttributes().get("SCHEME");
    }

    @Override
    public IFilteredCollection<History> getHistory(boolean includeRuntimeEvents, List<IRestrictionCriteria> filters) {
        return this.getHistory(filters);
    }

    @Override
    public IFilteredCollection<History> getHistory(List<IRestrictionCriteria> filters) {
        if (filters == null) {
            filters = Collections.EMPTY_LIST;
        }
        String eventID = this.getAttribute(EventAttribute.CH_EVID);
        if (this.getAttribute(EventAttribute.CH_APICMD).equals("BACKOUT")) {
            String backoutEventID = null;
            if (this.eventEndAttributes != null) {
                backoutEventID = this.eventEndAttributes.get("EVENTID");
            }
            eventID = backoutEventID != null ? backoutEventID : "";
        }
        JournalCriteria journalCriteria = JournalCriteria.newJournalCriteriaForPackageEvent();
        LocationCriteria locationCriteria = LocationCriteria.newJournalLocationCriteria();
        FilteredCollection history = new FilteredCollection(new CMListFactory(locationCriteria, journalCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.journalCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"getHistory", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        String create = attributes.get("CREATETIME");
                        attributes.put("A_CHANGETIME", create);
                        History object = new History(PackageSchemeEvent.this.getIHistoryProvider(), attributes);
                        if (object == null) continue;
                        objects.add(object);
                    }
                    return objects;
                }
                return null;
            }
        });
        RestrictionElementList restrictionElementList = new RestrictionElementList();
        restrictionElementList.add(new RestrictionCriteria("JNLOBJTYPE", FilterExpression.Operator.NE, "KEYASSOC"));
        restrictionElementList.add(new RestrictionCriteria("JNLEVENTID", FilterExpression.Operator.EQ, eventID));
        restrictionElementList.add(new RestrictionCriteria("JNLCCONFIG", FilterExpression.Operator.EQ, WILD));
        restrictionElementList.add(new RestrictionCriteria("JNLRET_CODE", FilterExpression.Operator.EQ, WILD));
        restrictionElementList.add(new RestrictionCriteria("JNLRES_CODE", FilterExpression.Operator.EQ, WILD));
        for (IRestrictionCriteria filter : filters) {
            restrictionElementList.add((RestrictionCriteria)filter);
        }
        RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
        restrictionCriteriaList.add(restrictionElementList);
        history.setRestrictionCriteriaList(restrictionCriteriaList);
        return history;
    }

    public static List<PackageSchemeEvent> getEvents(PackageScheme parent, Map<String, String> packageSchemeAttribs) {
        ArrayList<PackageSchemeEvent> events = new ArrayList<PackageSchemeEvent>();
        ArrayList eventMaps = new ArrayList();
        Set<String> keySet = packageSchemeAttribs.keySet();
        int count = 0;
        while (keySet.contains("CH_EVID" + count)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = eventAttribs;
            int n = eventAttribs.length;
            int n2 = 0;
            while (n2 < n) {
                String attrib = stringArray[n2];
                hashMap.put(attrib, packageSchemeAttribs.get(String.valueOf(attrib) + count));
                ++n2;
            }
            eventMaps.add(hashMap);
            ++count;
        }
        for (Map map : eventMaps) {
            events.add(new PackageSchemeEvent(parent, map));
        }
        return events;
    }

    public static List<PackageSchemeEvent> filterEventsByCommand(List<PackageSchemeEvent> events, Set<String> allowedCommands) {
        ArrayList<PackageSchemeEvent> output = new ArrayList<PackageSchemeEvent>();
        for (PackageSchemeEvent next : events) {
            if (!allowedCommands.contains(next.getAttribute(EventAttribute.CH_APICMD))) continue;
            output.add(next);
        }
        return output;
    }

    public String toString() {
        return String.valueOf(CMUtilities.getUnqualifiedClassName(this.getClass())) + "(" + this.attributes.get(eventAttribs[1]) + ") - " + this.attributes.toString();
    }

    @Override
    public String getName() {
        if (this.eventEndAttributes != null) {
            return this.eventEndAttributes.get("EVENTID");
        }
        return this.getAttribute(EventAttribute.CH_EVID);
    }

    @Override
    public Date getChangeTime() {
        return CMUtilities.asDatayyyyMMddHHmmssSS(this.getAttribute(EventAttribute.CH_DATIME));
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        return this;
    }

    @Override
    public Date getHistoryFromDate() {
        return this.getChangeTime();
    }

    @Override
    public Date getHistoryToDate() {
        return this.getChangeTime();
    }

    @Override
    public void setToDate(Date toDate) {
    }

    @Override
    public void setFromDate(Date fromDate) {
    }

    @Override
    public String getHistoryFromDateAsDisplay() {
        return CMUtilities.toStringyyyyMMddDate(this.getChangeTime());
    }

    @Override
    public String getHistoryToDateAsDisplay() {
        return CMUtilities.toStringyyyyMMddDate(this.getChangeTime());
    }

    public static enum EventAttribute {
        CH_APICMD,
        CH_DATIME,
        CH_USERID,
        CH_EVID,
        CH_RC,
        CH_RSN;

    }
}

