/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.builder;

import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ExportConfiguration;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.builder.ObjectBuilder;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.List;
import java.util.Map;

public class ConfigurationBuilder
extends ObjectBuilder {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ConfigurationManager.CMObjectFactory configurationObjectFactory;

    public ConfigurationBuilder() {
        this.setConfigurationAttributes("", "", "", "", "OLD");
    }

    public ConfigurationBuilder(String name, String cpsmContext) {
        this.setConfigurationAttributes(name, cpsmContext, "", "DYNAMIC", "OLD");
        this.setAttribute("FILETYPE", "CPSM");
    }

    public ConfigurationBuilder(String name, String csdName, String csdRLS) {
        this.setConfigurationAttributes(name, "", csdName, csdRLS, "OLD");
        this.setAttribute("FILETYPE", "CSD");
    }

    public void setConfigurationAttributes(String name, String cpsmContext, String csdName, String csdRLS, String expDisp) {
        this.setName(name);
        this.setCPSMContext(cpsmContext);
        this.setCSDName(csdName);
        this.setCSDRLS(csdRLS);
        this.setAttribute("EXPDISP", expDisp);
    }

    public static ConfigurationManager.CMObjectFactory getObjectFactory() {
        if (configurationObjectFactory == null) {
            configurationObjectFactory = new ConfigurationManager.CMObjectFactory(){

                @Override
                public ICMObject createObject(Map<String, String> attributes) {
                    String fileType = attributes.get("FILETYPE");
                    if ("CPSM".equals(fileType)) {
                        return new CPSMConfiguration(attributes);
                    }
                    if ("CSD".equals(fileType)) {
                        return new CSDConfiguration(attributes);
                    }
                    if ("EXPORT".equals(fileType)) {
                        return new ExportConfiguration(attributes);
                    }
                    return new Configuration(attributes);
                }
            };
        }
        return configurationObjectFactory;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setAttribute("NAME", name);
    }

    @Override
    public void setDescription(String desc) {
        this.setAttribute("DESCRIPTION", desc);
    }

    public void setFileType(String fileType) {
        this.setAttribute("FILETYPE", fileType);
    }

    public void setCPSMContext(String cpsmContext) {
        this.setAttribute("CONTEXT", cpsmContext);
    }

    public void setCSDName(String csdFile) {
        this.setAttribute("CSDNAME", csdFile);
    }

    public void setCSDRLS(String csdRLS) {
        this.setAttribute("CSDRLS", csdRLS);
    }

    public void setTransformationVariables(Map<String, String> vars) {
        this.setAttribute("LTVCOUNT", String.format("%08d", vars.size()));
        int count = 0;
        for (String key : vars.keySet()) {
            this.setAttribute("XNAME" + count, key);
            this.setAttribute("XVALUE" + count, vars.get(key));
            ++count;
        }
    }

    public void setMROLinks(List<String> conns) {
        this.setAttribute("MROCOUNT", String.format("%08d", conns.size()));
        int count = 0;
        for (String conn : conns) {
            this.setAttribute("MROLINK" + count, conn);
            ++count;
        }
    }

    @Override
    public String getType() {
        return "CCONFIG";
    }

    @Override
    public Configuration create(ConfigurationManager aConfigurationManager) {
        MessageResponse messageResponse;
        try {
            messageResponse = aConfigurationManager.create(this.getLocationCriteria(), this.getObjectCriteria(), this.getObjectData());
        }
        catch (CMServerException e) {
            messageResponse = e.getMessageResponse();
        }
        if (messageResponse != null && messageResponse.returnCode <= 4 && messageResponse instanceof InquireMessageResponse) {
            return (Configuration)ConfigurationBuilder.getObjectFactory().createObject(((InquireMessageResponse)messageResponse).getObject());
        }
        return null;
    }
}

