/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.builder;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.builder.IBuilder;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class ObjectBuilder
implements IBuilder,
Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String name;
    protected Map<String, String> attributes = new HashMap<String, String>();
    private ConfigurationManager configurationManager;
    protected LocationCriteria locationCriteria;
    protected ObjectCriteria objectCriteria;
    protected ObjectData objectData;

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public void setDescription(String aDescription) {
        this.setAttribute("DESCRIPTION", aDescription);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<Map.Entry<String, String>> getAttributes() {
        return this.attributes.entrySet();
    }

    public LocationCriteria getLocationCriteria() {
        if (this.locationCriteria == null) {
            this.locationCriteria = LocationCriteria.newRepositoryLocationCriteria();
        }
        return this.locationCriteria;
    }

    public ObjectCriteria getObjectCriteria() {
        if (this.objectCriteria == null) {
            this.objectCriteria = ObjectCriteria.newObjectCriteria(this.getType(), this.getName());
        }
        return this.objectCriteria;
    }

    public ObjectData getObjectData() {
        if (this.objectData == null) {
            this.objectData = new ObjectData();
        }
        this.objectData.setAttributes(this.attributes);
        return this.objectData;
    }
}

