/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.definitions;

import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class CPSMNoGroupDefinition
extends ResourceDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HistoryProviderDelegate historyProviderDelegate;

    protected CPSMNoGroupDefinition(Configuration configuration, Map<String, String> attributes, boolean skinny) {
        super(configuration, attributes, skinny);
    }

    @Override
    public IFilteredCollection<History> getHistory(boolean includeRuntimeEvents, List<IRestrictionCriteria> filters) {
        return this.getIHistoryProvider().getHistory(true, filters);
    }

    @Override
    public IFilteredCollection<History> getHistory(List<IRestrictionCriteria> filters) {
        return this.getIHistoryProvider().getHistory(filters);
    }

    @Override
    public boolean equals(Object anObject) {
        if (anObject instanceof CPSMNoGroupDefinition) {
            CPSMNoGroupDefinition anotherDefinition = (CPSMNoGroupDefinition)anObject;
            return this.getConfiguration().equals(anotherDefinition.getConfiguration()) && this.getType().equals(anotherDefinition.getType()) && this.getName().equals(anotherDefinition.getName());
        }
        return false;
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        if (this.historyProviderDelegate == null) {
            this.historyProviderDelegate = new HistoryProviderDelegate(this){

                @Override
                protected List<RestrictionCriteria> getAdditionalCriteria() {
                    ArrayList<RestrictionCriteria> arrayList = new ArrayList<RestrictionCriteria>();
                    arrayList.add(new RestrictionCriteria("JNLOBJNAME", FilterExpression.Operator.EQ, this.getName()));
                    arrayList.add(new RestrictionCriteria("B_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    arrayList.add(new RestrictionCriteria("A_CHANGETIME", FilterExpression.Operator.EQ, "*"));
                    return arrayList;
                }

                @Override
                protected JournalCriteria getJournalCriteria() {
                    return JournalCriteria.newJournalCriteriaForDefinition(this.getConfiguration().getName(), "", CPSMNoGroupDefinition.this.type, this.getName());
                }

                @Override
                protected JournalCriteria getJournalEventCriteria() {
                    return JournalCriteria.newJournalEventCriteriaForDefinition(this.getConfiguration().getName(), "", CPSMNoGroupDefinition.this.type, this.getName());
                }

                @Override
                protected ICMObject getObject(Map<String, String> attributes) {
                    return new History(this, attributes);
                }
            };
        }
        return this.historyProviderDelegate;
    }

    public static boolean isCPSMNoGroupDefinitionType(String resourceType) {
        return resourceType.equals("APPLDEF") || resourceType.equals("PLATDEF") || resourceType.equals("CSYSDEF") || resourceType.equals("CSYSGRP") || resourceType.equals("CSGLCGCS") || resourceType.equals("CSGLCGCG") || resourceType.equals("WLMSPEC") || resourceType.equals("WLMGROUP") || resourceType.equals("WLMDEF") || resourceType.equals("TRANGRP") || resourceType.equals("LNKSWSCS") || resourceType.equals("LNKSWSCG") || resourceType.equals("WLMINSPC") || resourceType.equals("WLMINGRP") || resourceType.equals("DTRINGRP");
    }
}

