/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.runtime.Node;

public class LocationCriteria
extends Node
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static LocationCriteria newRepositoryLocationCriteria() {
        return new LocationCriteria("REPOSITORY");
    }

    public static LocationCriteria newJournalLocationCriteria() {
        return new LocationCriteria("JOURNAL");
    }

    public static LocationCriteria newConfigurationLocationCriteria(String configurationName) {
        LocationCriteria locationCriteria = new LocationCriteria("CCONFIG");
        locationCriteria.setLocationName(configurationName);
        return locationCriteria;
    }

    protected LocationCriteria(String aLocationType) {
        this.attributes.put("LOCATIONTYPE", aLocationType);
    }

    @Override
    public String getName() {
        return "LOCATIONCRITERIA";
    }

    public String toString() {
        return "LocationCriteria" + this.attributes.toString();
    }

    public void setLocationName(String aLocationName) {
        this.attributes.put("LOCATIONNAME", aLocationName);
    }

    public String getLocationName() {
        return (String)this.attributes.get("LOCATIONNAME");
    }
}

