/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ConnectionConfiguration {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String configID;
    private String name;
    private String host;
    private int port;
    private String credentialsID;
    private Map<String, String> extendedAttributes = Collections.emptyMap();
    private static final Debug DEBUG = new Debug(ConnectionConfiguration.class);
    private String userID;
    private String password;
    private boolean ssl;
    private boolean sslConfirmation = false;

    @Deprecated
    public ConnectionConfiguration(String name, String host, int port, String userID, String password) {
        this(name, host, port, userID, password, false);
    }

    public ConnectionConfiguration(String name, String host, int port, String userID, String password, boolean secureHint) {
        this.configID = name;
        this.name = name;
        this.host = host;
        this.port = port;
        this.userID = userID != null ? userID : "";
        this.password = password != null ? password : "";
        this.credentialsID = "";
        this.ssl = secureHint;
    }

    @Deprecated
    public ConnectionConfiguration(String name, String host, int port, String credentialsID) {
        this(name, name, host, port, credentialsID, false);
    }

    public ConnectionConfiguration(String id, String name, String host, int port, String credentialsID) {
        this(id, name, host, port, credentialsID, false);
    }

    public ConnectionConfiguration(String id, String name, String host, int port, String credentialsID, boolean secureHint) {
        this.configID = id;
        this.name = name;
        this.host = host;
        this.port = port;
        this.userID = "";
        this.password = "";
        this.credentialsID = credentialsID;
        this.ssl = secureHint;
    }

    public ConnectionConfiguration(String newID, ConnectionConfiguration other) {
        this.configID = newID;
        this.name = other.name;
        this.host = other.host;
        this.port = other.port;
        this.userID = other.userID;
        this.password = other.password;
        this.credentialsID = other.credentialsID;
        this.ssl = other.ssl;
        this.sslConfirmation = other.sslConfirmation;
        for (String key : other.extendedAttributes.keySet()) {
            this.extendedAttributesNeedToBeMutable();
            this.extendedAttributes.put(key, other.extendedAttributes.get(key));
        }
    }

    public ConnectionConfiguration(ConnectionConfiguration other) {
        this(other.configID, other);
    }

    public ConnectionConfiguration(String id, String name, String host, int port, String credentialsID, boolean secureHint, boolean confirmedSecurity) {
        this.configID = id;
        this.name = name;
        this.host = host;
        this.port = port;
        this.userID = "";
        this.password = "";
        this.credentialsID = credentialsID;
        this.ssl = secureHint;
        this.sslConfirmation = confirmedSecurity;
    }

    private void extendedAttributesNeedToBeMutable() {
        if (this.extendedAttributes == Collections.EMPTY_MAP) {
            this.extendedAttributes = new HashMap<String, String>();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getCredentialsID() {
        return this.credentialsID;
    }

    public void setCredentialsID(String credentialsID) {
        this.credentialsID = credentialsID;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (Map.Entry<String, String> entry : this.extendedAttributes.entrySet()) {
            buffer.append(entry.getKey());
            buffer.append("=");
            buffer.append(entry.getValue());
            buffer.append(",");
        }
        buffer.append("}");
        return "ConnectionConfiguration[" + this.getID() + ", " + this.getName() + ", Creds=" + this.getCredentialsID() + "@" + this.getHost() + ":" + this.getPort() + ", " + this.ssl + (this.isSSLConfirmed() ? ", confirmed," : ",") + " " + buffer.toString() + "]";
    }

    public Set<String> getExtendedKeys() {
        return this.extendedAttributes.keySet();
    }

    public boolean equals(Object obj) {
        DEBUG.enter("equals", obj);
        if (obj instanceof ConnectionConfiguration) {
            boolean equal = this.equals((ConnectionConfiguration)obj);
            DEBUG.exit("equals", (Object)("ObjA: " + equal));
            return equal;
        }
        boolean equal = super.equals(obj);
        DEBUG.exit("equals", (Object)("ObjB: " + equal));
        return equal;
    }

    private boolean equals(ConnectionConfiguration other) {
        DEBUG.enter("equals", (Object)other);
        boolean equal = this.staticallyEquals(other) && this.ssl == other.ssl && StringUtil.safeEquals((Object)this.userID, (Object)other.userID) && StringUtil.safeEquals((Object)this.password, (Object)other.password);
        DEBUG.exit("equals", (Object)("CC: " + equal));
        return equal;
    }

    @Deprecated
    public boolean staticallyEquals(ConnectionConfiguration other) {
        DEBUG.enter("staticallyEquals");
        if (other == null) {
            DEBUG.exit("staticallyEquals", (Object)"null");
            return false;
        }
        boolean result = StringUtil.safeEquals((Object)this.configID, (Object)other.configID) && StringUtil.safeEquals((Object)this.name, (Object)other.name) && StringUtil.safeEquals((Object)this.credentialsID, (Object)other.credentialsID) && StringUtil.safeEquals((Object)this.host, (Object)other.host) && StringUtil.safeEquals(this.extendedAttributes, other.extendedAttributes) && this.port == other.port;
        DEBUG.exit("staticallyEquals", (Object)result);
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean getSecureHint() {
        return this.ssl;
    }

    public void setSecureHint(boolean hint) {
        this.ssl = hint;
    }

    public String getExtendedAttribute(String key) {
        return this.extendedAttributes.get(key);
    }

    public void setExtendedAttribute(String key, String value) {
        DEBUG.enter("setExtendedAttribute", (Object)key, (Object)value);
        this.extendedAttributesNeedToBeMutable();
        this.extendedAttributes.put(key, value);
        DEBUG.exit("setExtendedAttribute");
    }

    public String getID() {
        return this.configID;
    }

    public boolean isSSLConfirmed() {
        return this.sslConfirmation;
    }

    public void setSslConfirmation(boolean sslConfirmation) {
        this.sslConfirmation = sslConfirmation;
    }
}

