/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.common.util.Debug;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;

public abstract class CMDefinition
extends CMObject
implements ICMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String NAME = "NAME";
    private static final String VERSION = "DEFVER";
    private static final String CHANGE_TIME = "CHANGETIME";
    private static final String CREATE_TIME = "CREATETIME";
    private static final String DESCRIPTION = "DESCRIPTION";
    protected String name;
    private String version;
    private String createTime;
    private Date changeTime;
    protected String description;
    private static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");

    public CMDefinition(Map<String, String> attributes) {
        super(attributes);
        this.name = attributes.get(NAME);
        this.version = attributes.get(VERSION);
        try {
            this.changeTime = CMUtilities.getyyyyMMddDateFormat().parse(attributes.get(CHANGE_TIME));
        }
        catch (ParseException e) {
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"CMDefinition", (Object[])new Object[]{attributes, e});
        }
        catch (Exception e) {
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"CMDefinition", (Object[])new Object[]{attributes, e});
        }
        this.createTime = attributes.get(CREATE_TIME);
        this.description = attributes.get(DESCRIPTION);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    @Override
    protected void fillAttributes(Map<String, String> anAttributesMap) {
        this.name = anAttributesMap.get(NAME);
        this.version = anAttributesMap.get(VERSION);
        try {
            this.changeTime = CMUtilities.getyyyyMMddDateFormat().parse(anAttributesMap.get(CHANGE_TIME));
        }
        catch (ParseException e) {
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"fillAttributes", (Object[])new Object[]{anAttributesMap, e});
        }
        catch (Exception e) {
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"fillAttributes", (Object[])new Object[]{anAttributesMap, e});
        }
        this.createTime = anAttributesMap.get(CREATE_TIME);
        this.description = anAttributesMap.get(DESCRIPTION);
        super.fillAttributes(anAttributesMap);
    }
}

