/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.comm.CMConnectionRecord;
import com.ibm.cics.cm.comm.CMConstants;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.TypeOverrides;
import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.model.ICICSType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ConfigurationOverrides
implements CMConnectionRecord.Overrides,
CMConstants,
Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String EMPTY = "EMPTY";
    private static Map<String, ConfigurationOverrides> overidesByConfiguration = new HashMap<String, ConfigurationOverrides>();
    private static int currentRelease;
    private static Map<String, Map<String, Map<Integer, String>>> attributeOverridesByConfiguration;
    private Map<String, Integer> attributeAndRelease = new HashMap<String, Integer>();
    private int release;
    private String resourceType;
    private String name;

    static {
        attributeOverridesByConfiguration = new HashMap<String, Map<String, Map<Integer, String>>>();
        ConfigurationOverrides.putConfigurationOverrides(CPSMConfiguration.class.getName());
        ConfigurationOverrides.putConfigurationOverrides(CSDConfiguration.class.getName());
        ConfigurationOverrides.putConfigurationOverrides(EMPTY);
        ConfigurationOverrides.addConfigurationOverrides(CPSMConfiguration.class.getName(), "CREATETIME", 310);
        ConfigurationOverrides.addConfigurationOverrides(CPSMConfiguration.class.getName(), "CSDGROUP", -1);
        ConfigurationOverrides.addConfigurationOverridesAttribute(CSDConfiguration.class.getName(), "CSDGROUP", "GROUP", -2);
        ConfigurationOverrides.addConfigurationOverrides(CSDConfiguration.class.getName(), "USERDATA1", -1);
        ConfigurationOverrides.addConfigurationOverrides(CSDConfiguration.class.getName(), "USERDATA2", -1);
        ConfigurationOverrides.addConfigurationOverrides(CSDConfiguration.class.getName(), "USERDATA3", -1);
        ConfigurationOverrides.addConfigurationOverrides(CSDConfiguration.class.getName(), "DEFVER", -1);
        ConfigurationOverrides.addConfigurationOverridesAttribute(CPSMConfiguration.class.getName(), "LSRPOOLID", "LSRPOOLNUM", 420);
        ConfigurationOverrides.addConfigurationOverridesAttribute(CSDConfiguration.class.getName(), "LSRPOOLID", "LSRPOOLNUM", 420);
    }

    public static ConfigurationOverrides getOverrides(Configuration configuration, String resourceType) {
        ConfigurationOverrides configurationOverrides = configuration == null ? overidesByConfiguration.get(EMPTY) : overidesByConfiguration.get(configuration.getClass().getName());
        configurationOverrides.setType(resourceType);
        return configurationOverrides;
    }

    private static void putConfigurationOverrides(String name) {
        overidesByConfiguration.put(name, new ConfigurationOverrides(name));
    }

    private static void addConfigurationOverridesAttribute(String name, String fromAttrib, String toAttrib, int fromRelease) {
        Map<String, Map<Integer, String>> attributeMap = attributeOverridesByConfiguration.get(name);
        if (attributeMap == null) {
            attributeMap = new HashMap<String, Map<Integer, String>>();
            attributeOverridesByConfiguration.put(name, attributeMap);
        }
        HashMap<Integer, String> stringByRelease = new HashMap<Integer, String>();
        stringByRelease.put(fromRelease, toAttrib);
        attributeMap.put(fromAttrib, stringByRelease);
    }

    private static void addConfigurationOverrides(String name, String attributeName, int fromRelease) {
        overidesByConfiguration.get(name).addAttributeName(attributeName, fromRelease);
    }

    public static void setConnectionReleaseNumber(int release, int cmRelease) {
        if (cmRelease < 210 && release >= 410) {
            release = 320;
        }
        currentRelease = release;
        TypeOverrides.setConnectionReleaseNumber(release, cmRelease);
        for (ConfigurationOverrides releaseOverride : overidesByConfiguration.values()) {
            releaseOverride.setReleaseThreshold(release);
        }
    }

    public static boolean isValidResourceTypeForRelease(ICICSType cicsType) {
        if (currentRelease == 0) {
            return true;
        }
        Integer fromRelease = TypeOverrides.get(cicsType.getResourceTableName());
        return fromRelease == null || fromRelease <= currentRelease && fromRelease >= 0;
    }

    public ConfigurationOverrides(String name) {
        this.name = name;
    }

    public void addAttributeName(String attributeName, int fromRelease) {
        this.attributeAndRelease.put(attributeName, fromRelease);
    }

    private void setType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getOverride(String attributeName) {
        Integer fromRelease = this.attributeAndRelease.get(attributeName);
        if (fromRelease != null) {
            if (fromRelease > this.release || fromRelease < 0) {
                if ("DEFVER".equals(attributeName)) {
                    return "0";
                }
                if (AbstractCICSDefinitionType.CSDGROUP.getCicsName().equals(attributeName)) {
                    return "";
                }
                return "FORCE_ATTRIBUTE_UNSUPPORTED";
            }
            return null;
        }
        return TypeOverrides.getOverrides(this.resourceType).getOverride(attributeName);
    }

    private void setReleaseThreshold(int release) {
        this.release = release;
    }

    public String getCMAttribute(String attribute) {
        String override = this.getOverride(attribute);
        if (override != null) {
            String cmAttribute = this.getAttributeOverrides(attribute);
            return cmAttribute;
        }
        String cmAttribute = this.getAttributeOverrides(attribute);
        if (cmAttribute != null) {
            return cmAttribute;
        }
        return attribute;
    }

    private String getAttributeOverrides(String override) {
        Map<String, Map<Integer, String>> map = attributeOverridesByConfiguration.get(this.name);
        if (map != null) {
            Map<Integer, String> possibleOverride = map.get(override);
            if (possibleOverride != null) {
                Vector<Integer> sortedReleases = new Vector<Integer>(possibleOverride.keySet());
                Collections.sort(sortedReleases);
                for (Integer fromRelease : sortedReleases) {
                    if (fromRelease == -1) {
                        return override;
                    }
                    if (fromRelease != -2 && fromRelease > this.release) continue;
                    override = possibleOverride.get(fromRelease);
                    return override;
                }
                override = null;
            } else {
                override = null;
            }
        } else {
            override = null;
        }
        return override;
    }
}

