/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.comm.IHistoryContext;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.common.util.StringUtil;
import java.util.Map;

public class HistoryContext
implements IHistoryContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private History historicalDefinition;
    private ICMDefinition definition;
    private Configuration configuration;

    public HistoryContext(History historicalDefinition) {
        String confName;
        this.historicalDefinition = historicalDefinition;
        IHistoryProvider provider = historicalDefinition.getProvider();
        if (provider != null) {
            this.configuration = provider.getConfiguration();
        }
        if (this.configuration == null && StringUtil.hasContent((String)(confName = (String)historicalDefinition.attributes.get("CCONFIG")))) {
            this.configuration = ConfigurationManager.getCurrent().getCachedConfiguration(confName);
        }
    }

    public String getScope() {
        return this.configuration.getName();
    }

    public String getContext() {
        return this.configuration.getName();
    }

    public Map<String, String> getDefinitionAttributes() {
        return this.historicalDefinition.getAttributesBeforeChange();
    }

    public ICMDefinition getDefinition() {
        return this.definition;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public History getHistoricalDefinition() {
        return this.historicalDefinition;
    }
}

