/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.MigrationPath;
import com.ibm.cics.cm.model.MutableMigrationScheme;
import com.ibm.cics.cm.model.TransformationVariable;
import com.ibm.cics.cm.model.builder.MigrationSchemeBuilder;
import com.ibm.cics.cm.model.runtime.CMServerDeleteException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.common.util.Debug;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MigrationScheme
extends CMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Date changeTime;
    private HistoryProviderDelegate historyProviderDelegate;
    protected static Logger logger = Logger.getLogger("com.ibm.cics.cm.model");
    private List<MigrationSchemeListener> listeners = new ArrayList<MigrationSchemeListener>();
    private boolean deleted;
    private ArrayList<MigrationPath> migrationPaths;
    private ArrayList<TransformationVariable> transformationVariables;

    public MigrationScheme(Map<String, String> anAttributesMap) {
        super(anAttributesMap);
        this.setName(anAttributesMap.get("NAME"));
    }

    public MutableMigrationScheme asMutableMigrationScheme() {
        return new MutableMigrationScheme(this, ConfigurationManager.getCurrent());
    }

    public boolean equals(Object o) {
        return o instanceof MigrationScheme && ((MigrationScheme)o).getName().equals(this.getName());
    }

    public MigrationScheme getMigrationScheme() {
        return this;
    }

    public Date getChangeTime() {
        String changeTimeAttrib = (String)this.attributes.get("CHANGETIME");
        if (changeTimeAttrib != null) {
            try {
                this.changeTime = CMUtilities.getyyyyMMddDateFormat().parse(changeTimeAttrib);
            }
            catch (ParseException e) {
                Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"MigrationScheme", (Object[])new Object[]{this.attributes, e});
            }
            catch (Exception e) {
                Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"MigrationScheme", (Object[])new Object[]{this.attributes, e});
            }
        }
        return this.changeTime;
    }

    public MessageResponse update() {
        MigrationSchemeBuilder builder = new MigrationSchemeBuilder();
        builder.setName(this.getName());
        builder.setDescription(this.getDescription());
        builder.setApproval(this.getApproval());
        builder.setMigrationPaths(this.migrationPaths);
        builder.setTransformationVariables(this.transformationVariables);
        MessageResponse response = builder.update(ConfigurationManager.getCurrent(), (String)this.attributes.get("INTEGRITYTOKEN"));
        this.getFullMigrationScheme();
        return response;
    }

    public boolean delete() throws CMServerDeleteException {
        boolean result = false;
        try {
            LocationCriteria locationCriteria = LocationCriteria.newRepositoryLocationCriteria();
            ObjectCriteria objectCriteria = ObjectCriteria.newMigrationSchemeCriteria();
            objectCriteria.setObjectName(this.getName());
            result = ConfigurationManager.getCurrent().delete(locationCriteria, objectCriteria);
        }
        catch (CMServerDeleteException de) {
            Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"delete", (String)"Delete failed.", (Throwable)de);
            throw de;
        }
        this.deleted = result;
        this.notifyListeners(true);
        return result;
    }

    public boolean addListener(MigrationSchemeListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(MigrationSchemeListener listener) {
        return this.listeners.remove(listener);
    }

    private void notifyListeners(boolean changed) {
        for (MigrationSchemeListener next : this.listeners) {
            next.notify(changed, this);
        }
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void getFullMigrationScheme() {
        ConfigurationManager.getCurrent().getMigrationScheme(this.getName());
        this.notifyListeners(true);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted() {
        this.deleted = true;
        this.notifyListeners(true);
    }

    public void setAttributes(Map<String, String> attributes) {
        Date oldChangeTime = this.getChangeTime();
        this.fillAttributes(attributes);
        Date newChangeTime = this.getChangeTime();
        if (oldChangeTime.compareTo(newChangeTime) < 0) {
            this.notifyListeners(true);
        }
    }

    public boolean getApproval() {
        String approval;
        return this.attributes != null && (approval = (String)this.attributes.get("APPOPTION")) != null && approval.equalsIgnoreCase("YES");
    }

    public ArrayList<MigrationPath> getMigrationPaths() {
        ArrayList<MigrationPath> paths = new ArrayList<MigrationPath>();
        int i = 0;
        while (this.attributes.get("S_CCONFIG" + i) != null) {
            String source = (String)this.attributes.get("S_CCONFIG" + i);
            String target = (String)this.attributes.get("T_CCONFIG" + i);
            String rule = (String)this.attributes.get("XFORMRSET" + i);
            String das = (String)this.attributes.get("SCE_DEL_OPT" + i);
            if (source != null && !source.isEmpty() || target != null && !target.isEmpty() || rule != null && !rule.isEmpty() || das != null && !das.isEmpty()) {
                paths.add(new MigrationPath(source, target, rule, das.equals("YES")));
            }
            ++i;
        }
        this.migrationPaths = paths;
        return paths;
    }

    public ArrayList<TransformationVariable> getTranformationVariables() {
        ArrayList<TransformationVariable> vars = new ArrayList<TransformationVariable>();
        int i = 0;
        while (this.attributes.get("S_CCONFIG" + i) != null) {
            String name = (String)this.attributes.get("S_NAME" + i);
            String s_value = (String)this.attributes.get("S_VALUE" + i);
            String t_value = (String)this.attributes.get("T_VALUE" + i);
            if (name != null && !name.isEmpty() || s_value != null && !s_value.isEmpty() || t_value != null && !t_value.isEmpty()) {
                vars.add(new TransformationVariable(name, s_value, t_value));
            }
            ++i;
        }
        this.transformationVariables = vars;
        return vars;
    }

    public void setDescription(String newDescription) {
        this.attributes.put("DESCRIPTION", newDescription);
    }

    public void setApproval(boolean approval) {
        if (this.attributes != null) {
            this.attributes.put("APPOPTION", approval ? "YES" : "NO");
        }
    }

    public void setMigrationPaths(ArrayList<MigrationPath> migrationPaths) {
        this.migrationPaths = migrationPaths;
    }

    public void setTransformationVariables(ArrayList<TransformationVariable> transformationVariables) {
        this.transformationVariables = transformationVariables;
    }

    public abstract class MigrationSchemeListener {
        private MigrationScheme host;

        public MigrationSchemeListener(MigrationScheme next) {
            this.host = next;
        }

        public abstract void notify(boolean var1, MigrationScheme var2);

        public void dispose() {
            this.host.removeListener(this);
        }
    }
}

