/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.Messages;
import com.ibm.cics.cm.model.ReadyListObject;
import java.util.Map;

public class ReadyListCommand
extends ReadyListObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String COMMAND_ASSOCIATION = "COMMAND_ASSOCIATION";

    public ReadyListCommand(Map<String, String> attributes) {
        super(attributes);
    }

    @Override
    public boolean isCommand() {
        return true;
    }

    public boolean associatedWithSource() {
        String commandAssocType = (String)this.attributes.get(COMMAND_ASSOCIATION);
        return commandAssocType != null && commandAssocType.matches("CMDASOURCE");
    }

    public String wrapDescriptiveCommandText(String resourceString) {
        StringBuffer sb = new StringBuffer();
        String commandType = (String)this.attributes.get("SEL_COMMAND");
        String objectType = (String)this.attributes.get("SEL_OBJTYPE");
        boolean resourceMode = true;
        if (objectType != null) {
            resourceMode = !objectType.matches("RESGROUP");
        }
        String toContainer = resourceMode ? Messages.getString("ReadyListCommand.descriptive.togroup") : Messages.getString("ReadyListCommand.descriptive.tolist");
        String fromContainer = resourceMode ? Messages.getString("ReadyListCommand.descriptive.fromgroup") : Messages.getString("ReadyListCommand.descriptive.fromlist");
        sb.append(resourceString);
        if (commandType.matches("A")) {
            sb.insert(0, String.valueOf(Messages.getString("ReadyListCommand.descriptive.add")) + " ");
            sb.append(" " + toContainer + " ");
            String targetContainer = (String)this.attributes.get("SEL_TCONTAINER");
            sb.append(targetContainer);
        } else if (commandType.matches("D")) {
            sb.insert(0, String.valueOf(Messages.getString("ReadyListCommand.descriptive.delete")) + " ");
        } else if (commandType.matches("R")) {
            sb.insert(0, String.valueOf(Messages.getString("ReadyListCommand.descriptive.remove")) + " ");
            sb.append(" " + fromContainer + " ");
            String targetContainer = (String)this.attributes.get("SEL_TCONTAINER");
            sb.append(targetContainer);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String commandType = (String)this.attributes.get("SEL_COMMAND");
        sb.append(this.name);
        if (commandType.matches("A")) {
            sb.insert(0, String.valueOf(Messages.getString("ReadyListCommand.descriptive.add")) + " ");
            sb.append(" " + Messages.getString("ReadyListCommand.descriptive.togroup") + " ");
            String targetContainer = (String)this.attributes.get("SEL_TCONTAINER");
            sb.append(targetContainer);
        } else if (commandType.matches("D")) {
            sb.insert(0, String.valueOf(Messages.getString("ReadyListCommand.descriptive.delete")) + " ");
        } else if (commandType.matches("R")) {
            sb.insert(0, String.valueOf(Messages.getString("ReadyListCommand.descriptive.remove")) + " ");
            sb.append(" " + Messages.getString("ReadyListCommand.descriptive.fromgroup") + " ");
            String targetContainer = (String)this.attributes.get("SEL_TCONTAINER");
            sb.append(targetContainer);
        }
        sb.insert(0, String.valueOf(Messages.getString("ReadyListCommand.descriptive.commandPrefix")) + " ");
        return sb.toString();
    }
}

