/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CMServerException
extends Exception {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MessageResponse response;
    private Map<String, String> additionalInfo;
    private static final long serialVersionUID = -3512983000574255867L;
    private String additionalAttribute;
    private int feedbackErrorCode = -1;
    private int additionalReasonCode = -1;
    private int additionalResponseCode = -1;

    public CMServerException(MessageResponse response) {
        this.response = response;
    }

    public String getReturnResponse() {
        return this.response.getReturnResponse();
    }

    public boolean isMaybeIncomplete() {
        return this.is(8, "002A");
    }

    public boolean isSpecifiedObjectNotFound() {
        return this.is(8, "0003") || this.is(4, "0003");
    }

    public boolean isObjectAlreadyExists() {
        return this.is(8, "0029");
    }

    public boolean is(int returnCode, String reasonCodeEndsWith) {
        return this.response.returnCode == returnCode && this.response.reasonCode.endsWith(reasonCodeEndsWith);
    }

    public MessageResponse getMessageResponse() {
        return this.response;
    }

    public boolean isIntegrityTokenMismatch() {
        return this.is(16, "0007");
    }

    @Override
    public String getMessage() {
        StringBuffer sb = new StringBuffer(this.response.getReturnResponse());
        List<String> additionalMessages = this.getAdditionalMessages();
        for (String next : additionalMessages) {
            sb.append("\n");
            sb.append(next);
        }
        return sb.toString();
    }

    public boolean isSeverError() {
        return this.response.returnCode == 16;
    }

    public boolean isInvalidResourceType() {
        return this.is(8, "002C");
    }

    public List<String> getAdditionalMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        List<MessageResponse.ErrorObject> errorObjects = this.response.getErrorObjects();
        for (MessageResponse.ErrorObject errorObject : errorObjects) {
            List<MessageResponse.ErrorMessage> errorMessages = errorObject.getErrorMessages();
            for (MessageResponse.ErrorMessage errorMessage : errorMessages) {
                messages.add(errorMessage.getMessage());
            }
        }
        return messages;
    }

    public boolean isOKWarning() {
        return this.is(8, "0000") || this.is(4, "0000");
    }

    public boolean isAPIMismatch() {
        return this.is(8, "0079");
    }

    public boolean isDFHEDAPWarning() {
        return this.is(4, "0024");
    }

    public boolean isInvalidResourceGroup() {
        return false;
    }

    public Map<String, String> getAdditionalInfo() {
        if (this.additionalInfo == null) {
            this.additionalInfo = CMUtilities.parseAdditionalErrorInfo(this);
        }
        return this.additionalInfo;
    }

    public String getAdditionalAttribute() {
        if (this.additionalAttribute == null) {
            this.getAdditionalInfo();
            this.additionalAttribute = this.additionalInfo.get("ATT1");
        }
        return this.additionalAttribute;
    }

    public boolean hasAdditionalInfo() {
        this.getAdditionalInfo();
        return !this.additionalInfo.isEmpty();
    }

    public int getFeedbackErrorCode() {
        if (this.feedbackErrorCode == -1) {
            this.getAdditionalInfo();
            String string = this.additionalInfo.get("ErrorCode");
            try {
                this.feedbackErrorCode = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
        return this.feedbackErrorCode;
    }

    public int getAdditionalReasonCode() {
        if (this.additionalReasonCode == -1) {
            this.getAdditionalInfo();
            String string = this.additionalInfo.get("ReasonCode");
            try {
                this.additionalReasonCode = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
        return this.additionalReasonCode;
    }

    public int getAdditionalResponseCode() {
        if (this.additionalResponseCode == -1) {
            this.getAdditionalInfo();
            String string = this.additionalInfo.get("ReturnCode");
            try {
                this.additionalResponseCode = Integer.parseInt(string);
            }
            catch (Exception exception) {}
        }
        return this.additionalResponseCode;
    }

    public boolean isWarningCopyReplaced() {
        return this.is(4, "0054");
    }

    public boolean isWarningObjectAlreadyExists() {
        return this.is(4, "0029");
    }
}

