/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.runtime.INode;
import com.ibm.cics.cm.model.runtime.MessageBuffer;
import java.util.ArrayList;
import java.util.List;

public class Element {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    String tagName;
    String tagValue;
    List<Element> elements;

    public Element(String tagName) {
        this.tagName = tagName;
    }

    public Element createElement(INode aNode) {
        return aNode == null ? null : aNode.createElement(this);
    }

    public Element createChild(String tagName) {
        Element childElement = new Element(tagName);
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(childElement);
        return childElement;
    }

    public Element createChild(String tagName, String tagValue) {
        Element childElement = this.createChild(tagName);
        String sanitisedValue = tagValue;
        if (Element.containsProblemCharacters(sanitisedValue).booleanValue()) {
            sanitisedValue = CMUtilities.encodeToEBCDICValue(sanitisedValue);
        }
        childElement.setValue(sanitisedValue);
        return childElement;
    }

    private static Boolean containsProblemCharacters(String s) {
        Boolean result = false;
        if (s != null) {
            result = s.matches(".*[<>&]+.*");
        }
        return result;
    }

    public void setValue(String tagValue) {
        this.tagValue = tagValue;
    }

    public void appendTo(MessageBuffer buffer) {
        this.appendTo(buffer, 0);
    }

    public void appendTo(MessageBuffer buffer, int depth) {
        StringBuffer spacesBuffer = new StringBuffer();
        int i = 0;
        while (i < depth) {
            spacesBuffer.append(" ");
            ++i;
        }
        if (this.tagValue != null) {
            buffer.append(String.valueOf(spacesBuffer.toString()) + "<" + this.tagName + ">" + this.tagValue + "</" + this.tagName + ">");
        } else {
            buffer.append(String.valueOf(spacesBuffer.toString()) + "<" + this.tagName + ">");
            if (this.elements != null) {
                for (Element childElement : this.elements) {
                    childElement.appendTo(buffer, depth + 2);
                }
            }
            buffer.append(String.valueOf(spacesBuffer.toString()) + "</" + this.tagName + ">");
        }
    }

    public String toString() {
        MessageBuffer buffer = new MessageBuffer();
        this.appendTo(buffer, 1);
        return buffer.toString();
    }
}

