/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.ContainerData;
import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.ListElement;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageBuffer;
import com.ibm.cics.cm.model.runtime.Node;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList;
import com.ibm.cics.cm.model.runtime.ObjectData;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.SelectionCriteria;
import com.ibm.cics.cm.model.runtime.TargetCriteria;
import com.ibm.cics.cm.model.runtime.TargetLocationCriteria;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageFactory
implements Constants {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static boolean hasContent(String aString) {
        return aString != null && aString.trim().length() > 0;
    }

    public static String getDeleteMessage(String configurationName, String groupName, String type, String resourceName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element deleteElement = new Element("DELETE");
        Element locationCriteriaElement = deleteElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "CCONFIG");
        locationCriteriaElement.createChild("LOCATIONNAME", configurationName);
        Element objectCriteriaElement = deleteElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("LISTCOUNT", "1");
        Element listElement = objectCriteriaElement.createChild("LISTELEMENT");
        listElement.createChild("OBJNAME", resourceName);
        listElement.createChild("OBJTYPE", type);
        listElement.createChild("OBJGROUP", groupName);
        deleteElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getListLocationsMessageContents() {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        buffer.append("<LIST>");
        buffer.append("  <LOCATIONCRITERIA>");
        buffer.append("    <LOCATIONTYPE>REPOSITORY</LOCATIONTYPE>");
        buffer.append("  </LOCATIONCRITERIA>");
        buffer.append("  <OBJECTCRITERIA>");
        buffer.append("    <OBJTYPE>SVRINFO</OBJTYPE>");
        buffer.append("  </OBJECTCRITERIA>");
        buffer.append("</LIST>");
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getObjectsMessage(String objectType) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("LIST");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "REPOSITORY");
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", objectType);
        objectCriteriaElement.createChild("OBJNAME", "*");
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getConfigurationsMessage() {
        return MessageFactory.getObjectsMessage("CCONFIG");
    }

    public static String getPackagesMessage() {
        return MessageFactory.getObjectsMessage("CHGPKG");
    }

    public static void appendMessageStart(MessageBuffer buffer) {
        buffer.append("<?xml version=\"1.0\"?>");
        buffer.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        buffer.append("<SOAP-ENV:Body>");
        buffer.appendInline("<");
        buffer.appendInline(CMConnection.apiLevel);
        buffer.append(">");
    }

    public static void appendMessageEnd(MessageBuffer buffer) {
        buffer.appendInline("</");
        buffer.appendInline(CMConnection.apiLevel);
        buffer.append(">");
        buffer.append("</SOAP-ENV:Body>");
        buffer.append("</SOAP-ENV:Envelope>");
    }

    public static String getListsForConfiguration(String locationName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("LIST");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONNAME", locationName);
        locationCriteriaElement.createChild("LOCATIONTYPE", "CCONFIG");
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", "RESDESC");
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getDescriptorsForResourceGroup(String locationName, String locationType, String resourceGroupName, String objectType) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        buffer.append("<LIST>");
        buffer.append("  <LOCATIONCRITERIA>");
        buffer.append("    <LOCATIONNAME>");
        buffer.append(locationName);
        buffer.append("    </LOCATIONNAME>");
        buffer.append("    <LOCATIONTYPE>");
        buffer.append(locationType);
        buffer.append("    </LOCATIONTYPE>");
        buffer.append("  </LOCATIONCRITERIA>");
        buffer.append("  <OBJECTCRITERIA>");
        buffer.append("    <OBJTYPE>");
        buffer.append(objectType);
        buffer.append("    </OBJTYPE>");
        buffer.append("    <OBJGROUP>");
        buffer.append(resourceGroupName);
        buffer.append("    </OBJGROUP>");
        buffer.append("    <OBJNAME>");
        buffer.append("*");
        buffer.append("    </OBJNAME>");
        buffer.append("  </OBJECTCRITERIA>");
        buffer.append("  <PROCESSPARMS>");
        buffer.append("    <LIMIT>10000</LIMIT>");
        buffer.append("    <COUNTS>ALL</COUNTS>");
        buffer.append("  </PROCESSPARMS>");
        buffer.append("</LIST>");
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String inquire(String locationName, String locationType, String resourceGroupName, String resourceType, String resourceName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element inquireElement = new Element("INQUIRE");
        Element locationCriteriaElement = inquireElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONNAME", locationName);
        locationCriteriaElement.createChild("LOCATIONTYPE", locationType);
        Element objectCriteriaElement = inquireElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", resourceType);
        objectCriteriaElement.createChild("OBJGROUP", resourceGroupName);
        objectCriteriaElement.createChild("OBJNAME", resourceName);
        inquireElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String inquirePackage(String locationType, String resourceType, String resourceID) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element inquireElement = new Element("INQUIRE");
        Element locationCriteriaElement = inquireElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", locationType);
        Element objectCriteriaElement = inquireElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", resourceType);
        objectCriteriaElement.createChild("CPID", resourceID);
        inquireElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getGroupsForConfiguration(String locationName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("LIST");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONNAME", locationName);
        locationCriteriaElement.createChild("LOCATIONTYPE", "CCONFIG");
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", "RESGROUP");
        objectCriteriaElement.createChild("OBJNAME", "*");
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getGroupsForList(String locationName, String objectName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("LIST");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONNAME", locationName);
        locationCriteriaElement.createChild("LOCATIONTYPE", "CCONFIG");
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", "RESINDSC");
        objectCriteriaElement.createChild("OBJNAME", objectName);
        objectCriteriaElement.createChild("OBJGROUP", "*");
        Element processParmsElement = listElement.createChild("PROCESSPARMS");
        processParmsElement.createChild("HASHINGSCOPE", "NAME");
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getObjectUpdateMessage(String objectType, String objectName, String integrityToken, Map<String, String> attributes) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("UPDATE");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "REPOSITORY");
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", objectType);
        if (objectType.equals("CHGPKG")) {
            objectCriteriaElement.createChild("CPID", objectName);
        } else if (objectType.equals("SCHEME")) {
            objectCriteriaElement.createChild("SCHEME", objectName);
            objectCriteriaElement.createChild("OBJNAME", objectName);
        } else {
            objectCriteriaElement.createChild("OBJNAME", objectName);
        }
        Element processParmsElement = listElement.createChild("PROCESSPARMS");
        processParmsElement.createChild("INTEGRITYTOKEN", integrityToken);
        Element inputDataElement = listElement.createChild("INPUTDATA");
        Element objectDataElement = inputDataElement.createChild("OBJECTDATA");
        if ("CCONFIG".equals(objectType)) {
            MessageFactory.constructCCONFIGObjectData(objectDataElement, attributes);
        } else if ("SYSOPTS".equals(objectType)) {
            MessageFactory.constructSYSOPTSObjectData(objectDataElement, attributes);
        } else {
            Element rGroupElement = null;
            Element rGroup = null;
            objectDataElement.createChild("DESCRIPTION", attributes.get("DESCRIPTION"));
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attributeName = entry.getKey().trim();
                if ("CCONFIG".equals(attributeName) || "RESGROUP".equals(attributeName) || "OBJNAME".equals(attributeName) || "SCHEME".equals(objectType) && "NAME".equals(attributeName) || "DESCRIPTION".equals(attributeName)) continue;
                String attributeValue = entry.getValue().trim();
                if (attributeValue.length() == 0) {
                    attributeValue = " ";
                }
                if ("T_CCONFIG".equals(attributeName) || "S_CCONFIG".equals(attributeName)) {
                    if (rGroup == null) {
                        rGroup = objectDataElement.createChild("RGroup");
                        rGroup.createChild("STCCOUNT", "1");
                    }
                    if (rGroupElement == null) {
                        rGroupElement = rGroup.createChild("RGroupElement");
                    }
                    rGroupElement.createChild(attributeName, attributeValue);
                    continue;
                }
                objectDataElement.createChild(attributeName, attributeValue);
            }
            if ("SCHEME".equals(objectType)) {
                rGroupElement.createChild("XFORMRSET");
                rGroup = objectDataElement.createChild("RGroup");
                rGroup.createChild("STVCOUNT", "0");
            }
        }
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getUpdateMessage(String locationName, String resourceType, String resourceGroupName, String resourceName, String integrityToken, Map<String, String> attributes) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        buffer.append("<UPDATE>");
        buffer.append("  <LOCATIONCRITERIA>");
        buffer.append("    <LOCATIONNAME>");
        buffer.append(locationName);
        buffer.append("    </LOCATIONNAME>");
        buffer.append("    <LOCATIONTYPE>");
        buffer.append("CCONFIG");
        buffer.append("    </LOCATIONTYPE>");
        buffer.append("  </LOCATIONCRITERIA>");
        buffer.append("  <OBJECTCRITERIA>");
        buffer.append("    <OBJTYPE>");
        buffer.append(resourceType);
        buffer.append("    </OBJTYPE>");
        buffer.append("    <OBJGROUP>");
        buffer.append(resourceGroupName);
        buffer.append("    </OBJGROUP>");
        buffer.append("    <OBJNAME>");
        buffer.append(resourceName);
        buffer.append("    </OBJNAME>");
        buffer.append("  </OBJECTCRITERIA>");
        buffer.append("  <PROCESSPARMS>");
        buffer.append("    <INTEGRITYTOKEN>");
        buffer.append(integrityToken);
        buffer.append("    </INTEGRITYTOKEN>");
        buffer.append("  </PROCESSPARMS>");
        buffer.append("  <INPUTDATA>");
        buffer.append("    <OBJECTDATA>");
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attributeName = entry.getKey().trim();
            String attributeValue = entry.getValue().trim();
            if (attributeValue.length() == 0) {
                attributeValue = " ";
            }
            buffer.append("<" + attributeName + ">" + attributeValue + "</" + attributeName + ">");
        }
        buffer.append("    </OBJECTDATA>");
        buffer.append("  </INPUTDATA>");
        buffer.append("</UPDATE>");
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getTestUpdateMessage(String integrityToken) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element updateElement = new Element("UPDATE");
        Element locationCriteriaElement = updateElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONNAME", "CPSMBAS1");
        locationCriteriaElement.createChild("LOCATIONTYPE", "CCONFIG");
        Element objectCriteriaElement = updateElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", "TRANDEF");
        objectCriteriaElement.createChild("OBJGROUP", "ABC123");
        objectCriteriaElement.createChild("OBJNAME", "FOO1");
        Element processParmsElement = updateElement.createChild("PROCESSPARMS");
        processParmsElement.createChild("INTEGRITYTOKEN", integrityToken);
        Element inputDataElement = updateElement.createChild("INPUTDATA");
        Element objectDataElement = inputDataElement.createChild("OBJECTDATA");
        objectDataElement.createChild("DESCRIPTION", "Changed by Joe - again !!!");
        updateElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getJournalFor(String config, String groupName, String type, String name) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("LIST");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "JOURNAL");
        Element journalCriteriaElement = listElement.createChild("JNLCRITERIA");
        journalCriteriaElement.createChild("JNLRECTYPE", "BAIMAGE");
        journalCriteriaElement.createChild("JNLOBJTYPE", type);
        journalCriteriaElement.createChild("JNLOBJGROUP", groupName);
        journalCriteriaElement.createChild("JNLOBJNAME", name);
        Element restrictionCriteriaElement = listElement.createChild("RESTRICTIONCRITERIA");
        restrictionCriteriaElement.createChild("LISTCOUNT", "5");
        Element restrictionListElement = restrictionCriteriaElement.createChild("LISTELEMENT");
        restrictionListElement.createChild("RESTRICTIONFIELD", "B_CHANGETIME");
        restrictionListElement.createChild("RESTRICTIONOPERATOR", "LE");
        restrictionListElement.createChild("RESTRICTIONVALUE", "9999/12/31.23:59:59.99");
        restrictionListElement = restrictionCriteriaElement.createChild("LISTELEMENT");
        restrictionListElement.createChild("RESTRICTIONFIELD", "A_CHANGETIME");
        restrictionListElement.createChild("RESTRICTIONOPERATOR", "LE");
        restrictionListElement.createChild("RESTRICTIONVALUE", "9999/12/31.23:59:59.99");
        restrictionListElement = restrictionCriteriaElement.createChild("LISTELEMENT");
        restrictionListElement.createChild("RESTRICTIONFIELD", "JNLOBJNAME");
        restrictionListElement.createChild("RESTRICTIONOPERATOR", "EQ");
        restrictionListElement.createChild("RESTRICTIONVALUE", name);
        restrictionListElement = restrictionCriteriaElement.createChild("LISTELEMENT");
        restrictionListElement.createChild("RESTRICTIONFIELD", "JNLRET_CODE");
        restrictionListElement.createChild("RESTRICTIONOPERATOR", "LE");
        restrictionListElement.createChild("RESTRICTIONVALUE", "0004");
        restrictionListElement = restrictionCriteriaElement.createChild("LISTELEMENT");
        restrictionListElement.createChild("RESTRICTIONFIELD", "JNLCCONFIG");
        restrictionListElement.createChild("RESTRICTIONOPERATOR", "EQ");
        restrictionListElement.createChild("RESTRICTIONVALUE", config);
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String inquireJournalEntry(String objectInstanceName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("INQUIRE");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "JOURNAL");
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", "BAIMAGE");
        objectCriteriaElement.createChild("OBJECTINSTANCE", objectInstanceName);
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getSystemDefinitionsForConfiguration(String configurationName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("LIST");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "CCONFIG");
        locationCriteriaElement.createChild("LOCATIONNAME", configurationName);
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", "CSYSDEF");
        objectCriteriaElement.createChild("OBJNAME", "*");
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getRepositoryDetailsFor(String configurationName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element listElement = new Element("INQUIRE");
        Element locationCriteriaElement = listElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "REPOSITORY");
        Element objectCriteriaElement = listElement.createChild("OBJECTCRITERIA");
        objectCriteriaElement.createChild("OBJTYPE", "CCONFIG");
        objectCriteriaElement.createChild("OBJNAME", configurationName);
        listElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String getObjectCreateMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ObjectData objectData) {
        Element updateElement = new Element("CREATE");
        updateElement.createElement(locationCriteria);
        updateElement.createElement(objectCriteria);
        Element inputDataElement = updateElement.createChild("INPUTDATA");
        inputDataElement.createElement(objectData);
        return MessageFactory.createMessage(updateElement);
    }

    public static String getDeleteResourceMessage(String objectType, String objectName) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        Element deleteElement = new Element("DELETE");
        Element locationCriteriaElement = deleteElement.createChild("LOCATIONCRITERIA");
        locationCriteriaElement.createChild("LOCATIONTYPE", "REPOSITORY");
        Element objectCriteriaElement = deleteElement.createChild("OBJECTCRITERIA");
        if ("CHGPKG".equals(objectType)) {
            objectCriteriaElement.createChild("CPID", objectName);
        } else if ("SCHEME".equals(objectType)) {
            objectCriteriaElement.createChild("OBJNAME", objectName);
        } else {
            objectCriteriaElement.createChild("OBJNAME", objectName);
        }
        objectCriteriaElement.createChild("OBJTYPE", objectType);
        deleteElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer.toString();
    }

    public static String inquire(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria) {
        Element inquireElement = new Element("INQUIRE");
        inquireElement.createElement(aLocationCriteria);
        inquireElement.createElement(anObjectCriteria);
        return MessageFactory.createMessage(inquireElement);
    }

    private static String createMessage(Element anElement) {
        return MessageFactory.createMessageBuffer(anElement).toString();
    }

    private static MessageBuffer createMessageBuffer(Element anElement) {
        MessageBuffer buffer = new MessageBuffer();
        MessageFactory.appendMessageStart(buffer);
        anElement.appendTo(buffer);
        MessageFactory.appendMessageEnd(buffer);
        return buffer;
    }

    public static String getInstallMessage(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteriaList, ProcessParms processParms) {
        Element installElement = new Element("INSTALL");
        installElement.createElement(locationCriteria);
        installElement.createElement(objectCriteriaList);
        installElement.createElement(processParms);
        return MessageFactory.createMessage(installElement);
    }

    public static String getDiscardMessage(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteriaList, ProcessParms processParms) {
        Element discardElement = new Element("DISCARD");
        discardElement.createElement(locationCriteria);
        discardElement.createElement(objectCriteriaList);
        discardElement.createElement(processParms);
        return MessageFactory.createMessage(discardElement);
    }

    public static String getDeleteMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria) {
        Element deleteElement = new Element("DELETE");
        deleteElement.createElement(locationCriteria);
        deleteElement.createElement(objectCriteria);
        return MessageFactory.createMessage(deleteElement);
    }

    public static String getCopyMessage(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteriaList, ProcessParms processParms, TargetLocationCriteria targetLocationCriteria) {
        Element copyElement = new Element("COPY");
        copyElement.createElement(locationCriteria);
        copyElement.createElement(objectCriteriaList);
        copyElement.createElement(targetLocationCriteria);
        copyElement.createElement(processParms);
        return MessageFactory.createMessage(copyElement);
    }

    public static String getObjectUpdateMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ObjectData objectData, String integrityToken) {
        Element updateElement = new Element("UPDATE");
        updateElement.createElement(locationCriteria);
        updateElement.createElement(objectCriteria);
        Element processParmsElement = updateElement.createChild("PROCESSPARMS");
        processParmsElement.createChild("INTEGRITYTOKEN", integrityToken);
        Element inputElement = updateElement.createChild("INPUTDATA");
        inputElement.createElement(objectData);
        return MessageFactory.createMessage(updateElement);
    }

    public static String getObjectsMessage(LocationCriteria locationCriteria, JournalCriteria journalCriteria, RestrictionCriteriaList restrictionCriteriaList) {
        return MessageFactory.getObjectsMessage(locationCriteria, (Node)journalCriteria, restrictionCriteriaList);
    }

    public static String getObjectsMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, RestrictionCriteriaList restrictionCriteriaList) {
        return MessageFactory.getObjectsMessage(locationCriteria, (Node)objectCriteria, restrictionCriteriaList);
    }

    private static String getObjectsMessage(LocationCriteria locationCriteria, Node aNodeCriteria, RestrictionCriteriaList restrictionCriteriaList) {
        Element updateElement = new Element("LIST");
        updateElement.createElement(locationCriteria);
        updateElement.createElement(aNodeCriteria);
        updateElement.createElement(restrictionCriteriaList);
        return MessageFactory.createMessage(updateElement);
    }

    public static String getObjectsMessage(LocationCriteria locationCriteria, Node aNodeCriteria, RestrictionCriteriaList restrictionCriteriaList, ProcessParms processParms) {
        Element updateElement = new Element("LIST");
        updateElement.createElement(locationCriteria);
        updateElement.createElement(aNodeCriteria);
        updateElement.createElement(restrictionCriteriaList);
        updateElement.createElement(processParms);
        return MessageFactory.createMessage(updateElement);
    }

    public static String getObjectsMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ProcessParms processParms) {
        Element updateElement = new Element("LIST");
        updateElement.createElement(locationCriteria);
        updateElement.createElement(objectCriteria);
        updateElement.createElement(processParms);
        return MessageFactory.createMessage(updateElement);
    }

    public static String getObjectRenameMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, TargetCriteria targetCriteria, ProcessParms processParms) {
        Element updateElement = new Element("RENAME");
        updateElement.createElement(locationCriteria);
        updateElement.createElement(objectCriteria);
        Element inputDataElement = updateElement.createChild("INPUTDATA");
        inputDataElement.createChild("TARGETCOUNT", "1");
        inputDataElement.createElement(targetCriteria);
        updateElement.createElement(processParms);
        return MessageFactory.createMessage(updateElement);
    }

    public static String getAddToContainerMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ContainerData containerData, ProcessParms processParms) {
        return MessageFactory.getAddRemoveFromContainerMessage(locationCriteria, objectCriteria, containerData, processParms, "ADD");
    }

    public static String getAddToContainerMessage(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteria, ContainerData containerData, ProcessParms processParms) {
        return MessageFactory.getAddRemoveFromContainerMessage(locationCriteria, objectCriteria, containerData, processParms, "ADD");
    }

    public static String getRemoveFromContainerMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ContainerData containerData, ProcessParms processParms) {
        return MessageFactory.getAddRemoveFromContainerMessage(locationCriteria, objectCriteria, containerData, processParms, "REMOVE");
    }

    public static String getRemoveFromContainerMessage(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteria, ContainerData containerData, ProcessParms processParms) {
        return MessageFactory.getAddRemoveFromContainerMessage(locationCriteria, objectCriteria, containerData, processParms, "REMOVE");
    }

    private static String getAddRemoveFromContainerMessage(LocationCriteria locationCriteria, ObjectCriteria objectCriteria, ContainerData containerData, ProcessParms processParms, String parentElementName) {
        Element parentElement = new Element(parentElementName);
        parentElement.createElement(locationCriteria);
        if (CMConnection.apiLevel.compareTo("CCV210") >= 0) {
            Map attributes = objectCriteria.attributes;
            objectCriteria = new ObjectCriteria(){

                @Override
                public Element createElement(Element parentElement) {
                    Element element = parentElement.createChild(this.getName());
                    String parentTagName = null;
                    parentTagName = ((String)this.attributes.get("OBJTYPE")).equals("RESGROUP") ? "GRPA" : "DEFA";
                    Element child = element.createChild(parentTagName);
                    for (Map.Entry<String, String> nodeTag : this.getElements()) {
                        if (nodeTag.getValue() == null) continue;
                        child.createChild(nodeTag.getKey(), CMUtilities.encodeToEBCDICValue(nodeTag.getValue()));
                    }
                    return element;
                }
            };
            objectCriteria.attributes = attributes;
        }
        parentElement.createElement(objectCriteria);
        parentElement.createElement(containerData);
        if (processParms != null) {
            parentElement.createElement(processParms);
        }
        return MessageFactory.createMessage(parentElement);
    }

    private static String getAddRemoveFromContainerMessage(LocationCriteria locationCriteria, ObjectCriteriaList objectCriteria, final ContainerData containerData, ProcessParms processParms, String parentElementName) {
        Element parentElement = new Element(parentElementName);
        parentElement.createElement(locationCriteria);
        if (CMConnection.apiLevel.compareTo("CCV210") >= 0) {
            List<ListElement> listElements = objectCriteria.listElements;
            final HashMap<String, String> parms = objectCriteria.extraParms;
            objectCriteria = new ObjectCriteriaList(){

                @Override
                public Element createElement(Element parentElement) {
                    if (this.listElements.isEmpty()) {
                        return null;
                    }
                    Element element = parentElement.createChild(this.getName());
                    if (parms != null) {
                        for (String key : parms.keySet()) {
                            element.createChild(key, (String)parms.get(key));
                        }
                    }
                    element.createChild("LISTCOUNT", Integer.toString(this.listElements.size()));
                    for (ListElement listElement : this.listElements) {
                        if (containerData != null && ((String)containerData.attributes.get("CONTAINERTYPE")).equals("CHGPKG")) {
                            if (listElement.attributes.containsKey("COMMAND")) {
                                listElement.setSubElementName("CMDAPOST");
                            } else {
                                listElement.setSubElementName("KEYA");
                            }
                        } else if (((String)((ListElement)this.listElements.get((int)0)).attributes.get("OBJTYPE")).equals("RESGROUP")) {
                            listElement.setSubElementName("GRPA");
                        } else {
                            listElement.setSubElementName("DEFA");
                        }
                        listElement.createElement(element);
                    }
                    return element;
                }
            };
            objectCriteria.listElements = listElements;
        }
        parentElement.createElement(objectCriteria);
        parentElement.createElement(containerData);
        if (processParms != null) {
            parentElement.createElement(processParms);
        }
        return MessageFactory.createMessage(parentElement);
    }

    public static String getServerAPILevelMessage() {
        MessageBuffer buffer = new MessageBuffer();
        buffer.append("<?xml version=\"1.0\"?>");
        buffer.append("<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        buffer.append("<SOAP-ENV:Body>");
        buffer.append("<CCV>");
        buffer.append("<QUERYVRM/>");
        buffer.append("</CCV>");
        buffer.append("</SOAP-ENV:Body>");
        buffer.append("</SOAP-ENV:Envelope>");
        return buffer.toString();
    }

    public static String getKillMessage(String token) {
        Element killElement = new Element("KILL");
        Element inputElement = killElement.createChild("INPUTDATA");
        Element killTokenElement = inputElement.createChild("KILLTOKEN");
        killTokenElement.setValue(token);
        return MessageFactory.createMessage(killElement);
    }

    public static String getReadyMessage(SelectionCriteria packageSelectionCriteria, boolean readyUnready) {
        Element readyElement = readyUnready ? new Element("READY") : new Element("UNREADY");
        readyElement.createElement(packageSelectionCriteria);
        return MessageFactory.createMessage(readyElement);
    }

    public static String getMigrateMessage(SelectionCriteria packageSelectionCriteria) {
        Element migrateElement = new Element("MIGRATE");
        migrateElement.createElement(packageSelectionCriteria);
        return MessageFactory.createMessage(migrateElement);
    }

    public static String getBackoutMessage(SelectionCriteria packageSelectionCriteria) {
        Element migrateElement = new Element("BACKOUT");
        migrateElement.createElement(packageSelectionCriteria);
        return MessageFactory.createMessage(migrateElement);
    }

    private static void constructCCONFIGObjectData(Element objectDataElement, Map<String, String> attributes) {
        int i;
        Element rGroup;
        String elementData = "";
        elementData = attributes.get("NAME");
        if (elementData == null) {
            elementData = "";
        }
        objectDataElement.createChild("NAME", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("DESCRIPTION");
        if (elementData != null) {
            objectDataElement.createChild("DESCRIPTION", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("CONTEXT")) == null) {
            elementData = "";
        }
        objectDataElement.createChild("CONTEXT", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("CSDNAME");
        if (elementData == null) {
            elementData = "";
        }
        objectDataElement.createChild("CSDNAME", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("EXPTARG");
        if (elementData == null) {
            elementData = "";
        }
        objectDataElement.createChild("EXPTARG", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("FILETYPE");
        if (elementData == null) {
            elementData = "";
        }
        objectDataElement.createChild("FILETYPE", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("EXPFORMAT");
        if (elementData == null) {
            elementData = "";
        }
        objectDataElement.createChild("EXPFORMAT", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("EXPVER");
        if (elementData == null) {
            elementData = "";
        }
        objectDataElement.createChild("EXPVER", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("EXPDISP");
        if (elementData == null) {
            elementData = "OLD";
        }
        objectDataElement.createChild("EXPDISP", CMUtilities.encodeToEBCDICValue(elementData));
        elementData = attributes.get("CSDRLS");
        if (elementData == null) {
            elementData = "";
        }
        objectDataElement.createChild("CSDRLS", CMUtilities.encodeToEBCDICValue(elementData));
        if (attributes.get("FILETYPE").equals("CSD")) {
            rGroup = objectDataElement.createChild("RGroup");
            String mroCountString = attributes.get("MROCOUNT");
            if (mroCountString == null) {
                mroCountString = "00000000";
            }
            rGroup.createChild("MROCOUNT", mroCountString);
            int mroCount = Integer.parseInt(mroCountString);
            i = 0;
            while (i < mroCount) {
                String mroLink = attributes.get("MROLINK" + i);
                if (mroLink != null) {
                    Element rGroupElement = rGroup.createChild("RGroupElement");
                    rGroupElement.createChild("MROLINK", mroLink);
                }
                ++i;
            }
        }
        rGroup = objectDataElement.createChild("RGroup");
        String ltvCountString = attributes.get("LTVCOUNT");
        if (ltvCountString == null) {
            ltvCountString = "00000000";
        }
        rGroup.createChild("LTVCOUNT", ltvCountString);
        int ltvCount = Integer.parseInt(ltvCountString);
        i = 0;
        while (i < ltvCount) {
            String xvalue;
            String xname = attributes.get("XNAME" + i);
            if (xname != null && (xvalue = attributes.get("XVALUE" + i)) != null) {
                Element rGroupElement = rGroup.createChild("RGroupElement");
                rGroupElement.createChild("XNAME", xname);
                rGroupElement.createChild("XVALUE", xvalue);
            }
            ++i;
        }
    }

    private static void constructSYSOPTSObjectData(Element objectDataElement, Map<String, String> attributes) {
        String elementData = "";
        elementData = attributes.get("NAME");
        if (elementData != null) {
            objectDataElement.createChild("NAME", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("PKGAPPACT")) != null) {
            objectDataElement.createChild("PKGAPPACT", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("PKGAUTNUM")) != null) {
            objectDataElement.createChild("PKGAUTNUM", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("XFORMACT")) != null) {
            objectDataElement.createChild("XFORMACT", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("AUTOGRPREM")) != null) {
            objectDataElement.createChild("AUTOGRPREM", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("TRACEFLG")) != null) {
            objectDataElement.createChild("TRACEFLG", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("SECCHKACT")) != null) {
            objectDataElement.createChild("SECCHKACT", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("SAFCLASS")) != null) {
            objectDataElement.createChild("SAFCLASS", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("SAFPREFIX")) != null) {
            objectDataElement.createChild("SAFPREFIX", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("SEC02ACT")) != null) {
            objectDataElement.createChild("SEC02ACT", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("SEC02_SAFCLASS")) != null) {
            objectDataElement.createChild("SEC02_SAFCLASS", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("SEC02_SAFPREFIX")) != null) {
            objectDataElement.createChild("SEC02_SAFPREFIX", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("MP_CONTEXT")) != null) {
            objectDataElement.createChild("MP_CONTEXT", CMUtilities.encodeToEBCDICValue(elementData));
        }
        if ((elementData = attributes.get("EXITSACT")) != null) {
            objectDataElement.createChild("EXITSACT", CMUtilities.encodeToEBCDICValue(elementData));
        }
        Element rGroup = objectDataElement.createChild("RGroup");
        String tcpCountString = attributes.get("TCPCOUNT0");
        if (tcpCountString == null) {
            tcpCountString = "00000000";
        }
        rGroup.createChild("TCPCOUNT", tcpCountString);
        int tcpCount = Integer.parseInt(tcpCountString);
        int i = 0;
        while (i < tcpCount) {
            String tcpSvIPA;
            String tcpSvPort;
            String tcpSvName;
            String tcpSvType = attributes.get("TCPSVTYPE" + i);
            if (tcpSvType != null && (tcpSvName = attributes.get("TCPSVNAME" + i)) != null && (tcpSvPort = attributes.get("TCPSVPORT" + i)) != null && (tcpSvIPA = attributes.get("TCPSVIPA" + i)) != null) {
                Element rGroupElement = rGroup.createChild("RGroupElement");
                rGroupElement.createChild("TCPSVTYPE", tcpSvType);
                rGroupElement.createChild("TCPSVNAME", tcpSvName);
                rGroupElement.createChild("TCPSVPORT", tcpSvPort);
                rGroupElement.createChild("TCPSVIPA", tcpSvIPA);
            }
            ++i;
        }
    }
}

