/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.Node;

public class ObjectCriteria
extends Node {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static ObjectCriteria newObjectCriteria(String objectType) {
        ObjectCriteria result = new ObjectCriteria();
        result.setObjectType(objectType);
        result.setObjectName("*");
        result.setObjectGroup("*");
        return result;
    }

    public static ObjectCriteria newObjectCriteria(String anObjectType, String anObjectName) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectName(anObjectName);
        objectCriteria.setObjectType(anObjectType);
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForGroup(String aGroupName, String anObjectType) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectGroup(aGroupName);
        objectCriteria.setObjectType(anObjectType);
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForGroup(String aGroupName, String anObjectType, String anObjectName) {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteria(anObjectType, anObjectName);
        objectCriteria.setObjectGroup(aGroupName);
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForCSysGrp(String aCSysGrpName) {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteria("CSYSGRP", aCSysGrpName);
        objectCriteria.setObjectGroup("");
        return objectCriteria;
    }

    public static ObjectCriteria newJournalInstance(String objectInstance) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("BAIMAGE");
        objectCriteria.attributes.put("OBJECTINSTANCE", objectInstance);
        objectCriteria.attributes.remove("OBJNAME");
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForList() {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectName("*");
        objectCriteria.setObjectType("*");
        objectCriteria.setObjectGroup("*");
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForChangePackageList(String aPackageID) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.attributes.remove("OBJNAME");
        objectCriteria.attributes.remove("OBJGROUP");
        objectCriteria.attributes.put("CPID", aPackageID);
        objectCriteria.setObjectType("READYLST");
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForChangePackageDelete(String aPackageID) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.attributes.remove("OBJNAME");
        objectCriteria.attributes.put("OBJTYPE", "CHGPKG");
        objectCriteria.attributes.put("CPID", aPackageID);
        return objectCriteria;
    }

    public static ObjectCriteria newConfigurationCriteria(String aConfigurationName) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("CCONFIG");
        objectCriteria.setObjectName(aConfigurationName);
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForGroup(String aGroupName) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("*");
        objectCriteria.setObjectGroup(aGroupName);
        return objectCriteria;
    }

    public static ObjectCriteria newResourceListCriteria() {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("RESDESC");
        return objectCriteria;
    }

    public static ObjectCriteria newServerCriteria() {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("SVRINFO");
        return objectCriteria;
    }

    public static ObjectCriteria newMigrationSchemeCriteria() {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("SCHEME");
        return objectCriteria;
    }

    public static ObjectCriteria newPackageSchemeCriteria(String cpid, String scheme) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.attributes.remove("OBJNAME");
        objectCriteria.setObjectType("PSCHEME");
        objectCriteria.attributes.put("CPID", cpid);
        objectCriteria.attributes.put("SCHEME", scheme);
        return objectCriteria;
    }

    public static ObjectCriteria newGroupCriteriaForList(String resourceListName) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("RESINDSC");
        objectCriteria.setObjectName(resourceListName);
        objectCriteria.setObjectGroup("*");
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForOrphanedResource(String type, String name, String version) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectName(name);
        objectCriteria.setObjectType(type);
        objectCriteria.setObjectGroup("");
        objectCriteria.setObjectVersion(version);
        return objectCriteria;
    }

    public static ObjectCriteria newObjectCriteriaForSystemOptions() {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectName("SYSTEM");
        objectCriteria.setObjectType("SYSOPTS");
        return objectCriteria;
    }

    public void setObjectVersion(String version) {
        this.attributes.put("OBJDEFVER", version);
    }

    public String getObjectVersion() {
        return (String)this.attributes.get("OBJDEFVER");
    }

    public ObjectCriteria() {
        this.setObjectName("*");
    }

    private void setListName(String listName) {
    }

    public void setObjectName(String name) {
        this.attributes.put("OBJNAME", name);
    }

    @Override
    public String getName() {
        return "OBJECTCRITERIA";
    }

    public void setObjectType(String type) {
        this.attributes.put("OBJTYPE", type);
    }

    public String toString() {
        return "ObjectCriteria" + this.attributes.toString();
    }

    public void setObjectGroup(String objectGroupName) {
        this.attributes.put("OBJGROUP", objectGroupName);
    }

    public String getObjectType() {
        return (String)this.attributes.get("OBJTYPE");
    }

    public String getObjectName() {
        return (String)this.attributes.get("OBJNAME");
    }

    public String getObjectGroup() {
        return (String)this.attributes.get("OBJGROUP");
    }

    public String getPackage() {
        return (String)this.attributes.get("CPID");
    }

    public void setScheme(String scheme) {
        this.attributes.put("SCHEME", scheme);
    }
}

