/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.AbstractConfigurationOperation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AddConfigurationOperation
extends AbstractConfigurationOperation {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String name;
    private String connectionTypeId;
    private ConnectionParameters.AttributeValue[] attributes;
    private IWritableConnectionProvider connectionProvider;
    private ConnectionParameters configuration;

    public AddConfigurationOperation(String name, String connectionTypeId, ConnectionParameters.AttributeValue[] attributes, IWritableConnectionProvider connectionProvider) {
        super("Add connection");
        this.name = name;
        this.connectionTypeId = connectionTypeId;
        this.attributes = attributes;
        this.connectionProvider = connectionProvider;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.configuration = this.connectionProvider.createConnectionParameters(this.name, this.connectionTypeId, this.attributes);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.connectionProvider.removeConfiguration(this.configuration.getId());
        return Status.OK_STATUS;
    }

    @Override
    public String getConfigurationId() {
        return this.configuration.getId();
    }
}

