/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.connections.AbstractConnectionProvider;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import com.ibm.cics.core.connections.internal.IConnectionSerializer;
import com.ibm.cics.core.connections.internal.Messages;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CachingConnectionProvider
extends AbstractConnectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CachingConnectionProvider.class);
    private final IConnectionDeserializer deser;
    private final String description;
    private IStatus status = Status.OK_STATUS;
    private final IConnectionDeserializer cacheDeserializer;
    private final IConnectionSerializer cacheSerializer;

    public CachingConnectionProvider(String id, String description, IConnectionDeserializer deser, IConnectionDeserializer cacheDeserializer, IConnectionSerializer cacheSerializer, ConnectionRegistry registry) {
        super(id, registry);
        this.description = description;
        this.deser = deser;
        this.cacheDeserializer = cacheDeserializer;
        this.cacheSerializer = cacheSerializer;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    protected List<ConnectionParameters> getUpdatedConfigurations(IProgressMonitor monitor) {
        try {
            List<ConnectionParameters> connectionParameters = this.deser.load();
            this.saveToCache(connectionParameters);
            this.status = Status.OK_STATUS;
            return connectionParameters;
        }
        catch (IOException e) {
            this.status = new Status(2, "com.ibm.cics.core.connections", Messages.CachingConnectionProvider_usingLocalCache, (Throwable)e);
            debug.warning("getUpdatedConfigurations", "Exception loading remote connections", (Throwable)e);
            return this.loadFromCache();
        }
    }

    private List<ConnectionParameters> loadFromCache() {
        try {
            return this.cacheDeserializer.load();
        }
        catch (IOException ex) {
            debug.warning("loadFromCache", "Cache load failed for provider: " + this, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    private void saveToCache(List<ConnectionParameters> connectionParameters) {
        try {
            this.cacheSerializer.save(connectionParameters);
        }
        catch (IOException ex) {
            debug.warning("saveToCache", "Cache save failed for provider: " + this, (Throwable)ex);
        }
    }

    @Override
    protected IStatus getStatus() {
        return this.status;
    }
}

