/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import com.ibm.cics.core.connections.internal.MemoryConnectionSerializer;
import com.ibm.cics.core.connections.internal.WritableConnectionProvider;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionParametersExporter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IWritableConnectionProvider exportConnectionProvider;
    private MemoryConnectionSerializer serializer;
    private final ConnectionRegistry registry;

    public ConnectionParametersExporter(Collection<ConnectionParameters> parametersList, ConnectionRegistry registry) {
        this.registry = registry;
        this.serializer = new MemoryConnectionSerializer();
        this.exportConnectionProvider = new WritableConnectionProvider("self", "exporter", this.serializer, NullConnectionDeserializer.getInstance(), registry);
        this.createNewParameters(parametersList);
    }

    private void createNewParameters(Collection<ConnectionParameters> parametersList) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        for (ConnectionParameters parameters : parametersList) {
            IConnectionDescriptor descriptor = this.registry.find(parameters.getConnectionTypeId());
            if (descriptor == null || descriptor.isTransient()) continue;
            ConnectionParameters exportParams = this.exportConnectionProvider.createConnectionParameters(parameters.getName(), parameters.getConnectionTypeId(), parameters.getAttributes());
            idsMap.put(parameters.getId(), exportParams.getId());
        }
        for (ConnectionParameters parameters : this.exportConnectionProvider.getConnections()) {
            parameters = ConnectionParametersExporter.updateReferences(parameters, this.registry, idsMap);
            this.exportConnectionProvider.updateConnectionParameters(parameters);
        }
    }

    static ConnectionParameters updateReferences(ConnectionParameters parameters, ConnectionRegistry registry, Map<String, String> idsMap) {
        IConnectionDescriptor descriptor = registry.find(parameters.getConnectionTypeId());
        if (descriptor != null) {
            for (Map.Entry<String, String> attribute : parameters.getAttributes().entrySet()) {
                if (!ConnectionUtils.isIdReference(descriptor, attribute.getKey()) || !idsMap.containsKey(attribute.getValue())) continue;
                parameters = parameters.setAttribute(attribute.getKey(), idsMap.get(attribute.getValue()));
            }
        }
        return parameters;
    }

    public List<ConnectionParameters> getConnections() {
        return this.serializer.getConnections();
    }

    private static class NullConnectionDeserializer
    implements IConnectionDeserializer {
        private static NullConnectionDeserializer instance = new NullConnectionDeserializer();

        private NullConnectionDeserializer() {
        }

        public static NullConnectionDeserializer getInstance() {
            return instance;
        }

        @Override
        public List<ConnectionParameters> load() throws IOException {
            return Collections.emptyList();
        }
    }
}

