/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import org.osgi.service.prefs.Preferences;

public class DefaultConnectionDeserializer {
    private static final String DEFAULT_CONNECTIONS = "defaultConnections";
    private Preferences defaultConnectionsNode;

    public DefaultConnectionDeserializer(DefaultConnectionService defaultConnectionService, ConnectionManager connectionManager, Preferences preferences, ConnectionRegistry connectionRegistry) {
        this.defaultConnectionsNode = preferences.node(DEFAULT_CONNECTIONS);
        IConnectionCategory[] iConnectionCategoryArray = connectionRegistry.getConnectionCategories();
        int n = iConnectionCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionCategory connectionCategory = iConnectionCategoryArray[n2];
            String defaultConnectionID = this.defaultConnectionsNode.get(connectionCategory.getId(), null);
            if (defaultConnectionID != null) {
                ConnectionProfile profile = connectionManager.getConnectionProfile(defaultConnectionID);
                if (profile != null) {
                    defaultConnectionService.setDefaultConnectionProfile(connectionCategory, profile);
                } else {
                    this.defaultConnectionsNode.remove(connectionCategory.getId());
                }
            }
            ++n2;
        }
        defaultConnectionService.addDefaultConnectionServiceListener(new DefaultConnectionService.DefaultConnectionServiceListener(){

            public void event(DefaultConnectionService.DefaultConnectionChangedEvent event) {
                if (event.getNewProfile() == null) {
                    DefaultConnectionDeserializer.this.defaultConnectionsNode.remove(event.getCategory().getId());
                } else {
                    DefaultConnectionDeserializer.this.defaultConnectionsNode.put(event.getCategory().getId(), event.getNewProfile().getId());
                }
            }
        });
    }
}

