/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.IActiveConnectionCategoryListener;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractSignonSignoffAction
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AbstractSignonSignoffAction.class);
    private ConnectionServiceListener connectionServiceListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if (event instanceof ConnectionServiceListener.ConnectingEvent || event instanceof ConnectionServiceListener.ConnectedEvent || event instanceof ConnectionServiceListener.DisconnectedEvent || event instanceof ConnectionServiceListener.ExceptionEvent) {
                AbstractSignonSignoffAction.this.connectedOrConnecting.put(event.getConnectionCategoryId(), event instanceof ConnectionServiceListener.ConnectingEvent || event instanceof ConnectionServiceListener.ConnectedEvent);
                AbstractSignonSignoffAction.this.refreshActionEnablement(AbstractSignonSignoffAction.this.action);
            }
        }
    };
    private final ConnectionManagerListener connectionManagerListener = new ConnectionManagerListener(){

        public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
            if (event instanceof ConnectionManagerListener.ConnectionProfileAddedEvent) {
                debug.enter("configurationAdded", (Object)this, (Object)event);
                for (String cat : AbstractSignonSignoffAction.this.checkConfigurationsExist.keySet()) {
                    AbstractSignonSignoffAction.this.checkConfigurationsExist.put(cat, true);
                }
                AbstractSignonSignoffAction.this.refreshActionEnablement(AbstractSignonSignoffAction.this.action);
                debug.exit("configurationAdded", (Object)AbstractSignonSignoffAction.this.configurationsExist);
            } else if (event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                debug.enter("configurationRemoved", (Object)this, (Object)event);
                String connectionCategory = event.getConnectionProfile().getConnectionDescriptor().getCategory().getId();
                AbstractSignonSignoffAction.this.checkConfigurationsExist.put(connectionCategory, true);
                AbstractSignonSignoffAction.this.refreshActionEnablement(AbstractSignonSignoffAction.this.action);
                debug.exit("configurationRemoved", (Object)AbstractSignonSignoffAction.this.configurationsExist);
            }
        }
    };
    private IActiveConnectionCategoryListener categoryListener = new IActiveConnectionCategoryListener(){

        @Override
        public void currentConnectionCategory(String category) {
            AbstractSignonSignoffAction.this.refreshActionEnablement(AbstractSignonSignoffAction.this.action);
        }
    };
    private IAction action;
    private Map<String, Boolean> connectedOrConnecting = new HashMap<String, Boolean>();
    private Map<String, Boolean> configurationsExist = new HashMap<String, Boolean>();
    private Map<String, Boolean> checkConfigurationsExist = new HashMap<String, Boolean>();
    private IConnectionService connectionService = InternalConnectionsPlugin.getDefault().getConnectionService();

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IWorkbenchWindow window) {
        debug.enter("init", (Object)this, (Object)window);
        IConnectionCategory[] cats = ConnectionRegistry.getConnectionRegistry().getConnectionCategories();
        int i = 0;
        while (i < cats.length) {
            String connectionCategory = cats[i].getId();
            this.connectedOrConnecting.put(connectionCategory, false);
            this.configurationsExist.put(connectionCategory, false);
            this.checkConfigurationsExist.put(connectionCategory, true);
            ++i;
        }
        this.connectionService.addConnectionServiceListener(this.connectionServiceListener);
        this.connectionService.getConnectionManager().addListener(this.connectionManagerListener);
        InternalConnectionsPlugin.getDefault().getActiveConnectionCategoryService().addActiveConnectionCategoryListener(this.categoryListener);
        this.refreshActionEnablement(this.action);
        debug.exit("init");
    }

    public void dispose() {
        this.connectionManagerListener.makeStale();
        this.connectionServiceListener.makeStale();
        InternalConnectionsPlugin.getDefault().getActiveConnectionCategoryService().removeActiveConnectionCategoryListener(this.categoryListener);
    }

    public void runWithEvent(IAction action, Event event) {
        this.refreshActionEnablement(action);
        this.run(action);
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected void refreshActionEnablement(IAction action) {
        String currentConnectionCategory = InternalConnectionsPlugin.getDefault().getActiveConnectionCategoryService().getActiveConnectionCategory();
        if (action != null) {
            boolean enabled = currentConnectionCategory != null && this.connectionsExists(currentConnectionCategory) && this.isConnected(currentConnectionCategory) == this.enabledWhenConnected();
            action.setEnabled(enabled);
        }
    }

    abstract boolean enabledWhenConnected();

    protected boolean isConnected(String connectionCategory) {
        if (!this.connectedOrConnecting.containsKey(connectionCategory)) {
            this.connectedOrConnecting.put(connectionCategory, false);
        }
        return this.connectedOrConnecting.get(connectionCategory);
    }

    protected boolean connectionsExists(final String connectionCategory) {
        IConnectionManager connectionManager = this.connectionService.getConnectionManager();
        if (!this.checkConfigurationsExist.containsKey(connectionCategory) || !this.configurationsExist.containsKey(connectionCategory)) {
            this.checkConfigurationsExist.put(connectionCategory, true);
        }
        if (this.checkConfigurationsExist.get(connectionCategory).booleanValue()) {
            boolean categoryHasConnections = !CollectionUtils.filter(connectionManager.getConnectionProfiles(), new Function<ConnectionProfile, Boolean>(){

                @Override
                public Boolean evaluate(ConnectionProfile v) {
                    return v.getConnectionDescriptor().getCategory().getId().equals(connectionCategory);
                }
            }).isEmpty();
            this.configurationsExist.put(connectionCategory, categoryHasConnections);
            debug.event("connectionsExists", (Object)categoryHasConnections, this.configurationsExist);
            this.checkConfigurationsExist.put(connectionCategory, false);
        }
        return this.configurationsExist.get(connectionCategory);
    }
}

