/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.connections.ConfigurationUtils;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AcceptSSLDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2008, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AcceptSSLDialog.class);
    private ConnectionParameters configuration;
    private boolean makeSecure;
    private final IWritableConnectionProvider connectionProvider;
    static Integer forceRc;

    private AcceptSSLDialog(Shell parentShell, ConnectionParameters configuration, boolean makeSecure, IWritableConnectionProvider connectionProvider) {
        super(parentShell);
        this.configuration = configuration;
        this.makeSecure = makeSecure;
        this.connectionProvider = connectionProvider;
        this.setBlockOnOpen(true);
        this.setTitleImage(ConnectionsImages.getImage("SECURITY_QUESTION_WIZ_BAN"));
        this.create();
        this.setTitle(Messages.AcceptSSLDialog_title);
        this.setMessage(makeSecure ? Messages.AcceptSSLDialog_message2 : Messages.AcceptSSLDialog_message1);
    }

    public static boolean showSSLDialog(final ConnectionParameters configuration, final boolean makeSecure, final IWritableConnectionProvider connectionProvider) {
        final boolean[] rc = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                AcceptSSLDialog dialog = new AcceptSSLDialog(shell, configuration, makeSecure, connectionProvider, null);
                rc[0] = dialog.show();
            }
        });
        return rc[0];
    }

    public int open() {
        if (forceRc != null) {
            int rc = forceRc;
            forceRc = null;
            return rc;
        }
        return super.open();
    }

    protected boolean show() {
        boolean updateSecureHint;
        int rc = this.open();
        boolean bl = updateSecureHint = 2 == rc;
        if (updateSecureHint) {
            this.configuration = this.configuration.setAttribute("ATTEMPT_SECURE", String.valueOf(this.makeSecure));
        }
        this.configuration = this.configuration.setAttribute("ssl_confirmed", String.valueOf(true));
        this.connectionProvider.updateConnectionParameters(this.configuration);
        return updateSecureHint;
    }

    protected Control createDialogArea(Composite parent) {
        debug.enter("createDialogArea");
        this.getShell().setText(Messages.AcceptSSLDialog_shell_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.connection_ssl_dialog");
        Control composite = super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createHostAndPort((Composite)composite);
        debug.exit("createDialogArea", (Object)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        debug.enter("createButtonsForButtonBar");
        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
        debug.exit("createButtonsForButtonBar");
    }

    protected void buttonPressed(int buttonId) {
        debug.enter("buttonPressed", (Object)buttonId);
        this.setReturnCode(buttonId);
        this.close();
    }

    private void createHostAndPort(Composite c) {
        debug.enter("createHostAndPort");
        Composite serverGroup = new Composite(c, 0);
        GridData data = new GridData(4, 4, true, true);
        serverGroup.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.horizontalSpacing = 10;
        serverGroup.setLayout((Layout)gridLayout);
        Label l = new Label(serverGroup, 0);
        l.setText(Messages.ConnectionPreferencePage_name);
        final Text nameText = new Text(serverGroup, 2048);
        TextInput.setAccessibleLabel((Text)nameText, (Label)l);
        nameText.forceFocus();
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        nameText.setLayoutData((Object)data);
        nameText.setEnabled(false);
        l = new Label(serverGroup, 0);
        l.setText(Messages.ConnectionPreferencePage_host);
        final Text hostText = new Text(serverGroup, 2048);
        TextInput.setAccessibleLabel((Text)hostText, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        hostText.setLayoutData((Object)data);
        hostText.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                nameText.setLocation(hostText.getLocation().x, nameText.getLocation().y);
                nameText.setSize(hostText.getSize());
            }

            public void controlResized(ControlEvent e) {
                nameText.setLocation(hostText.getLocation().x, nameText.getLocation().y);
                nameText.setSize(hostText.getSize());
            }
        });
        hostText.setEnabled(false);
        l = new Label(serverGroup, 0);
        l.setText(Messages.ConnectionPreferencePage_port);
        Text portText = new Text(serverGroup, 2048);
        TextInput.setAccessibleLabel((Text)portText, (Label)l);
        data = new GridData();
        data.widthHint = 90;
        portText.setLayoutData((Object)data);
        portText.setEnabled(false);
        new Label(serverGroup, 0);
        Label question = new Label(serverGroup, 64);
        question.setText(this.makeSecure ? Messages.AcceptSSLDialog_message4 : Messages.AcceptSSLDialog_message3);
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.horizontalSpan = 3;
        question.setLayoutData((Object)labelData);
        hostText.setText(StringUtil.toDisplayString((String)ConfigurationUtils.getHost(this.configuration)));
        portText.setText(String.valueOf(ConfigurationUtils.getPort(this.configuration)));
        nameText.setText(StringUtil.toDisplayString((String)this.configuration.getName()));
        debug.exit("createHostAndPort");
    }

    /* synthetic */ AcceptSSLDialog(Shell shell, ConnectionParameters connectionParameters, boolean bl, IWritableConnectionProvider iWritableConnectionProvider, AcceptSSLDialog acceptSSLDialog) {
        this(shell, connectionParameters, bl, iWritableConnectionProvider);
    }
}

