/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.BadLocationException;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionPreferences;
import com.ibm.cics.core.connections.internal.ExplorerConnectionProvider;
import com.ibm.cics.core.connections.internal.FileConnectionProvider;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.RefreshConnectionProviderJob;
import com.ibm.cics.core.connections.internal.URLConnectionProvider;
import com.ibm.cics.core.connections.internal.WritableConnectionProvider;
import com.ibm.cics.core.connections.internal.WritableFileConnectionProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.service.prefs.BackingStoreException;

public class ConnectionProviderRegistry
implements IConnectionProviderRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionProviderRegistry.class);
    static final String CONNECTION_SOURCES = "CONNECTION_SOURCES";
    private static final String LOCATION = "LOCATION";
    private static final String TAG_CONNECTION_PROVIDER = "connectionProvider";
    public static final String LOCAL_PROVIDER_ID = "local";
    private static final ConnectionProviderRegistry SINGLETON = new ConnectionProviderRegistry();
    private EventManager<IConnectionProviderRegistry.ConnectionProviderRegistryEvent> eventManager = new EventManager();
    private Map<IConnectionProvider, IStatus> connectionProviders = new HashMap<IConnectionProvider, IStatus>();
    private WritableConnectionProvider localConnectionProvider;
    private ConnectionPreferences connectionPreferences = new ConnectionPreferences("com.ibm.cics.core.connections");

    public static ConnectionProviderRegistry getDefault() {
        return SINGLETON;
    }

    static IPath getPluginMetadataPath(String fileName) {
        debug.enter("getLocalProviderPath");
        Path pluginMetadataPath = null;
        try {
            pluginMetadataPath = new Path(Platform.getInstanceLocation().getDataArea("com.ibm.cics.core.connections").getFile());
            pluginMetadataPath = pluginMetadataPath.append("/" + fileName);
        }
        catch (IOException e) {
            debug.error("getLocalProviderPath", (Throwable)e);
            pluginMetadataPath = new Path(Platform.getInstanceLocation().getURL().getFile());
        }
        debug.exit("getLocalProviderPath", (Object)pluginMetadataPath);
        return pluginMetadataPath;
    }

    private ConnectionProviderRegistry() {
        this.localConnectionProvider = new WritableFileConnectionProvider(LOCAL_PROVIDER_ID, ConnectionProviderRegistry.getPluginMetadataPath("local.xml"));
        this.addConnectionProvider(this.localConnectionProvider);
        if (ExplorerConnectionProvider.fileExists()) {
            this.addConnectionProvider(new ExplorerConnectionProvider());
        }
        this.addPersistedConnectionProviders();
        this.addExtensionPointProviders();
    }

    private void addExtensionPointProviders() {
        debug.enter("addExtensionPointProviders");
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cics.core.comm", "connectionproviders");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                this.readExtension(extensions[i]);
                ++i;
            }
        }
        debug.exit("addExtensionPointProviders");
    }

    private void readExtension(IExtension extension) {
        debug.enter("readExtension", (Object)extension);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            this.readElement(elements[i]);
            ++i;
        }
        debug.exit("readExtension");
    }

    private void readElement(IConfigurationElement element) {
        debug.enter("readElement", (Object)element);
        if (element.getName().equals(TAG_CONNECTION_PROVIDER)) {
            this.readConnectionProvider(element);
        }
        debug.exit("readElement");
    }

    private void readConnectionProvider(IConfigurationElement element) {
        debug.enter("readConnectionProvider", (Object)element);
        IConnectionProvider connectionProvider = null;
        if (element.getAttribute("class") != null) {
            try {
                connectionProvider = (IConnectionProvider)element.createExecutableExtension("class");
                this.addConnectionProvider(connectionProvider);
                debug.event("readConnectionProvider", "added" + connectionProvider);
            }
            catch (CoreException e) {
                debug.error("readConnection(IConfigurationElement)", "Unable to instantiate connection provider '" + element.getAttribute("class") + "'", (Throwable)e);
            }
        }
        debug.exit("readConnectionProvider");
    }

    private void addPersistedConnectionProviders() {
        debug.enter("addPersistedFileConnectionProviders");
        ConnectionPreferences connectionPreferences = new ConnectionPreferences("com.ibm.cics.core.connections");
        ConnectionPreferences preferences = connectionPreferences.node(CONNECTION_SOURCES);
        try {
            String[] childrenNames;
            String[] stringArray = childrenNames = preferences.childrenNames();
            int n = childrenNames.length;
            int n2 = 0;
            while (n2 < n) {
                String providerId = stringArray[n2];
                ConnectionPreferences node = preferences.node(providerId);
                String location = node.get(LOCATION, null);
                try {
                    this.createConnectionProvider(providerId, location);
                }
                catch (BadLocationException ex) {
                    debug.warning("addPersistedConnectionProviders", "Couldn't create a connection provider for location: " + location, (Throwable)ex);
                }
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            debug.error("getPersistedConnectionProviders", (Throwable)e);
        }
        debug.exit("addPersistedFileConnectionProviders");
    }

    private IConnectionProvider createConnectionProvider(String providerId, String location) throws BadLocationException {
        if (location != null) {
            if (location.startsWith("http://") || location.startsWith("https://")) {
                debug.event("addPersistedConnectionProviders", "The preferences loaded a connection source with ID=" + providerId + " and location=" + location);
                try {
                    URL url = new URL(location);
                    URLConnectionProvider connectionProvider = URLConnectionProvider.create(providerId, url, this.getCacheLocation(providerId));
                    this.addConnectionProvider(connectionProvider);
                    return connectionProvider;
                }
                catch (MalformedURLException e) {
                    debug.warning("addPersistedConnectionProvider", "Failed to add persisted URL connection provider for location: " + location, (Throwable)e);
                    throw new BadLocationException(e);
                }
            }
            FileConnectionProvider connectionProvider = new FileConnectionProvider(providerId, (IPath)new Path(location));
            debug.event("addPersistedConnectionProviders", "The preferences loaded a connection source with ID=" + providerId + " and location=" + location);
            this.addConnectionProvider(connectionProvider);
            return connectionProvider;
        }
        throw new BadLocationException("Null location");
    }

    private void addConnectionProvider(final IConnectionProvider connectionProvider) {
        debug.enter("addConnectionProvider", (Object)connectionProvider);
        this.connectionProviders.put(connectionProvider, null);
        connectionProvider.addListener(new IConnectionProvider.ConnectionProviderListener(){

            public void event(IConnectionProvider.ConnectionProviderEvent event) {
                if (event instanceof IConnectionProvider.ConnectionProviderStaleEvent) {
                    ConnectionProviderRegistry.this.refreshConnectionProvider(connectionProvider);
                } else if (event instanceof IConnectionProvider.ConnectionProviderStatusChangedEvent) {
                    IStatus status = ((IConnectionProvider.ConnectionProviderStatusChangedEvent)event).getStatus();
                    ConnectionProviderRegistry.this.connectionProviders.put(connectionProvider, status);
                }
            }

            public synchronized boolean isStale() {
                return !ConnectionProviderRegistry.this.connectionProviders.containsKey(connectionProvider);
            }
        });
        IStatus status = connectionProvider.refresh((IProgressMonitor)new NullProgressMonitor());
        if (status.getSeverity() > 0) {
            ConnectionsPlugin.getDefault().getLog().log(status);
        }
        this.eventManager.notifyListeners((Object)new IConnectionProviderRegistry.ConnectionProviderAddedEvent(connectionProvider));
        debug.exit("addConnectionProvider");
    }

    public void removeConnectionProvider(IConnectionProvider connectionProvider) {
        debug.enter("removeConnectionProvider", (Object)connectionProvider);
        if (this.connectionProviders.containsKey(connectionProvider)) {
            this.connectionProviders.remove(connectionProvider);
            this.removeFileConnectionProviderPersistence(connectionProvider.getId());
            this.eventManager.notifyListeners((Object)new IConnectionProviderRegistry.ConnectionProviderRemovedEvent(connectionProvider));
        }
        debug.exit("addConnectionProvider");
    }

    @Override
    public IStatus getConnectionProviderStatus(IConnectionProvider connectionProvider) {
        debug.enter("getConnectionProviderStatus", (Object)connectionProvider);
        IStatus status = null;
        if (this.connectionProviders.containsKey(connectionProvider)) {
            status = this.connectionProviders.get(connectionProvider);
            if (status == null) {
                status = Status.OK_STATUS;
            }
        } else {
            status = Status.CANCEL_STATUS;
        }
        debug.exit("getConnectionProviderStatus", (Object)status);
        return status;
    }

    @Override
    public WritableConnectionProvider getLocalConnectionProvider() {
        return this.localConnectionProvider;
    }

    private Job refreshConnectionProvider(IConnectionProvider connectionProvider) {
        debug.enter("refreshConnectionProvider", (Object)connectionProvider);
        RefreshConnectionProviderJob job = new RefreshConnectionProviderJob(connectionProvider);
        job.schedule();
        debug.exit("refreshConnectionProvider", (Object)job);
        return job;
    }

    @Override
    public List<IConnectionProvider> getConnectionProviders() {
        return new ArrayList<IConnectionProvider>(this.connectionProviders.keySet());
    }

    @Override
    public void addListener(IConnectionProviderRegistry.ConnectionProviderRegistryListener connectionProviderRegistyListener) {
        debug.enter("addListener", (Object)connectionProviderRegistyListener);
        this.eventManager.addListener((IStaleableEventListener)connectionProviderRegistyListener);
        debug.exit("addListener");
    }

    public IConnectionProvider addConnectionProvider(String path) throws BadLocationException {
        debug.enter("addFileConnectionProvider", (Object)path);
        String id = this.newId();
        IConnectionProvider connectionProvider = this.createConnectionProvider(id, path);
        this.persistConnectionProvider(path, id);
        debug.exit("addFileConnectionProvider");
        return connectionProvider;
    }

    private IPath getCacheLocation(String id) {
        return ConnectionProviderRegistry.getPluginMetadataPath("ConnectionProviderCache-" + id + ".xml");
    }

    private String newId() {
        List<String> usedIds = CollectionUtils.transform(this.connectionProviders.keySet(), new Function<IConnectionProvider, String>(){

            @Override
            public String evaluate(IConnectionProvider v) {
                return v.getId();
            }
        });
        String newId = IDFactory.createNewId();
        while (usedIds.contains(newId)) {
            newId = IDFactory.createNewId();
        }
        return newId;
    }

    private void removeFileConnectionProviderPersistence(String id) {
        ConnectionPreferences connectionSourcesNode = this.connectionPreferences.node(CONNECTION_SOURCES);
        try {
            connectionSourcesNode.childrenNames();
            boolean nodeExists = connectionSourcesNode.nodeExists(id);
            if (nodeExists) {
                ConnectionPreferences provider = connectionSourcesNode.node(id);
                provider.removeNode();
                this.connectionPreferences.flush();
            }
        }
        catch (BackingStoreException e) {
            debug.error("removeFileConnectionProviderPersistence", (Throwable)e);
        }
    }

    private void persistConnectionProvider(String filePath, String id) {
        ConnectionPreferences connectionSourcesNode = this.connectionPreferences.node(CONNECTION_SOURCES);
        try {
            connectionSourcesNode.childrenNames();
            boolean nodeExists = connectionSourcesNode.nodeExists(id);
            if (!nodeExists) {
                ConnectionPreferences providerNode = connectionSourcesNode.node(id);
                providerNode.put(LOCATION, filePath);
                this.connectionPreferences.flush();
            }
        }
        catch (BackingStoreException e) {
            debug.error("persistConnectionProvider", (Throwable)e);
        }
    }
}

