/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

public class IDFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2010 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int idCounter;

    public static String getUserid8() {
        String userID = System.getProperty("user.name");
        return IDFactory.truncateNospaces(userID, 8);
    }

    public static String getUseridWithPrefix(String prefix, int maxLen) {
        if (prefix == null || prefix.length() >= maxLen) {
            throw new IllegalArgumentException("'" + prefix + "' - " + maxLen);
        }
        String userID = System.getProperty("user.name");
        return IDFactory.truncateNospaces(String.valueOf(prefix) + userID, maxLen);
    }

    static String truncateNospaces(String s, int maxLen) {
        int index = s.indexOf(" ");
        if (index > maxLen) {
            index = maxLen;
        }
        if (index != -1) {
            s = s.substring(0, index);
        }
        if (s.length() > maxLen) {
            s = s.substring(0, maxLen);
        }
        return s;
    }

    public static synchronized String createNewId() {
        return String.valueOf(String.valueOf(System.currentTimeMillis())) + "-" + String.valueOf(idCounter++);
    }
}

