/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class VersionTextValue {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    PropertyChangeSupport changes = new PropertyChangeSupport(this);
    public static final String MAJOR_PROPERTY = "major";
    public static final String MINOR_PROPERTY = "minor";
    public static final String MICRO_PROPERTY = "micro";
    public static final String AMALGAMATED_PROPERTY = "amalgamated";
    private Long major = 0L;
    private Long minor = 0L;
    private Long micro = 0L;

    public Long getMajor() {
        return this.major;
    }

    public void setMajor(Long major) {
        String amalgamated = this.getAmalgamated();
        this.major = major;
        this.changes.firePropertyChange(MAJOR_PROPERTY, this.major, this.major);
        this.changes.firePropertyChange(AMALGAMATED_PROPERTY, amalgamated, this.getAmalgamated());
    }

    public Long getMinor() {
        return this.minor;
    }

    public void setMinor(Long minor) {
        String amalgamated = this.getAmalgamated();
        this.minor = minor;
        this.changes.firePropertyChange(MINOR_PROPERTY, this.minor, this.minor);
        this.changes.firePropertyChange(AMALGAMATED_PROPERTY, amalgamated, this.getAmalgamated());
    }

    public Long getMicro() {
        return this.micro;
    }

    public void setMicro(Long micro) {
        String amalgamated = this.getAmalgamated();
        this.micro = micro;
        this.changes.firePropertyChange(MICRO_PROPERTY, this.micro, this.micro);
        this.changes.firePropertyChange(AMALGAMATED_PROPERTY, amalgamated, this.getAmalgamated());
    }

    public void setAmalgamated(String amalgamated) {
        String[] parts = amalgamated.split("\\.");
        if (parts.length < 1 || parts[0].isEmpty() || parts.length > 3) {
            throw new IllegalArgumentException(amalgamated);
        }
        try {
            Long major = 1L;
            Long minor = 0L;
            Long micro = 0L;
            major = this.parseLong(parts[0]);
            if (parts.length >= 2) {
                minor = this.parseLong(parts[1]);
                if (parts.length >= 3) {
                    micro = this.parseLong(parts[2]);
                }
            }
            this.changes.firePropertyChange(AMALGAMATED_PROPERTY, this.getAmalgamated(), amalgamated);
            this.major = major;
            this.changes.firePropertyChange(MAJOR_PROPERTY, this.major, this.major);
            this.minor = minor;
            this.changes.firePropertyChange(MINOR_PROPERTY, this.minor, this.minor);
            this.micro = micro;
            this.changes.firePropertyChange(MICRO_PROPERTY, this.micro, this.micro);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(amalgamated);
        }
    }

    private Long parseLong(String number) {
        if (number.length() == 0) {
            return 0L;
        }
        return Long.parseLong(number);
    }

    public String getAmalgamated() {
        return this.getMajor() + "." + this.getMinor() + "." + this.getMicro();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes.removePropertyChangeListener(listener);
    }

    public static boolean isVersionParseable(String versionField) {
        String[] versionArray = versionField.split("\\.", 3);
        int i = 0;
        while (i < versionArray.length) {
            try {
                Integer.parseInt(versionArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

