/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DynamicStorageAreaReference;
import com.ibm.cics.core.model.DynamicStorageAreaType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IDynamicStorageArea;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableDynamicStorageArea;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableDynamicStorageArea
extends MutableCICSResource
implements IMutableDynamicStorageArea {
    private IDynamicStorageArea delegate;
    private MutableSMRecord record;

    public MutableDynamicStorageArea(ICPSM cpsm, IContext context, IDynamicStorageArea cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("CICSDSA");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public Long getSize() {
        return this.delegate.getSize();
    }

    public Long getCushion() {
        String result = this.record.get("CUSHION");
        if (result == null) {
            return this.delegate.getCushion();
        }
        return (Long)((CICSAttribute)DynamicStorageAreaType.CUSHION).get(result, this.record.getNormalizers());
    }

    public Long getPgmoniu() {
        return this.delegate.getPgmoniu();
    }

    public Long getGetmtotl() {
        return this.delegate.getGetmtotl();
    }

    public Long getFremtotl() {
        return this.delegate.getFremtotl();
    }

    public Long getAsubtotl() {
        return this.delegate.getAsubtotl();
    }

    public Long getDsubtotl() {
        return this.delegate.getDsubtotl();
    }

    public Long getNstgtotl() {
        return this.delegate.getNstgtotl();
    }

    public Long getStgstotl() {
        return this.delegate.getStgstotl();
    }

    public Long getNstgcurr() {
        return this.delegate.getNstgcurr();
    }

    public Long getStgshwm() {
        return this.delegate.getStgshwm();
    }

    public Long getStgpwcnt() {
        return this.delegate.getStgpwcnt();
    }

    public Long getStgcrelc() {
        return this.delegate.getStgcrelc();
    }

    public Long getStgsosc() {
        return this.delegate.getStgsosc();
    }

    public String getStgsost() {
        return this.delegate.getStgsost();
    }

    public Long getStgnsubp() {
        return this.delegate.getStgnsubp();
    }

    public Long getStgfsize() {
        return this.delegate.getStgfsize();
    }

    public Long getStglsize() {
        return this.delegate.getStglsize();
    }

    public Long getStgvtotl() {
        return this.delegate.getStgvtotl();
    }

    public IDynamicStorageArea.LocationValue getLocation() {
        return this.delegate.getLocation();
    }

    public IDynamicStorageArea.AccesstypeValue getAccesstype() {
        return this.delegate.getAccesstype();
    }

    public Long getStghwm() {
        return this.delegate.getStghwm();
    }

    public Long getLimit() {
        String result = this.record.get("LIMIT");
        if (result == null) {
            return this.delegate.getLimit();
        }
        return (Long)((CICSAttribute)DynamicStorageAreaType.LIMIT).get(result, this.record.getNormalizers());
    }

    public String getPoolpctfree() {
        return this.delegate.getPoolpctfree();
    }

    public String getPctfree() {
        return this.delegate.getPctfree();
    }

    public IDynamicStorageArea.StgprotectValue getStgprotect() {
        return this.delegate.getStgprotect();
    }

    public IDynamicStorageArea.RntpgprotectValue getRntpgprotect() {
        return this.delegate.getRntpgprotect();
    }

    public IDynamicStorageArea.TrnisolationValue getTrnisolation() {
        return this.delegate.getTrnisolation();
    }

    public Long getHwmfree() {
        return this.delegate.getHwmfree();
    }

    public Long getLwmfree() {
        return this.delegate.getLwmfree();
    }

    public Long getCurunqssusrs() {
        return this.delegate.getCurunqssusrs();
    }

    public Long getCumunqssusrs() {
        return this.delegate.getCumunqssusrs();
    }

    public Long getHwmunqssusrs() {
        return this.delegate.getHwmunqssusrs();
    }

    public Long getCurcmnssusrs() {
        return this.delegate.getCurcmnssusrs();
    }

    public Long getCumcmnssusrs() {
        return this.delegate.getCumcmnssusrs();
    }

    public Long getHwmcmnssusrs() {
        return this.delegate.getHwmcmnssusrs();
    }

    public Long getCurralloc() {
        return this.delegate.getCurralloc();
    }

    public Long getHwmalloc() {
        return this.delegate.getHwmalloc();
    }

    public Long getExtentscurr() {
        return this.delegate.getExtentscurr();
    }

    public Long getExtentsadded() {
        return this.delegate.getExtentsadded();
    }

    public Long getExtentsdeltd() {
        return this.delegate.getExtentsdeltd();
    }

    public String getTimewaitmvs() {
        return this.delegate.getTimewaitmvs();
    }

    public Long getReqswaitmvs() {
        return this.delegate.getReqswaitmvs();
    }

    public Long getMemlimit() {
        return this.delegate.getMemlimit();
    }

    public Long getGetstorsize() {
        return this.delegate.getGetstorsize();
    }

    public Long getAsactive() {
        return this.delegate.getAsactive();
    }

    public Long getHwmasactive() {
        return this.delegate.getHwmasactive();
    }

    public Long getGdsaactive() {
        return this.delegate.getGdsaactive();
    }

    public Long getHwmgdsaactiv() {
        return this.delegate.getHwmgdsaactiv();
    }

    public Long getAtbcushrels() {
        return this.delegate.getAtbcushrels();
    }

    public Long getAtbcushlimit() {
        return this.delegate.getAtbcushlimit();
    }

    public void setCushion(Long _cushion) {
        if (_cushion.equals(this.delegate.getCushion())) {
            this.record.set("CUSHION", null);
        } else {
            DynamicStorageAreaType.CUSHION.validate((Object)_cushion);
            String connectionSpecificExternalValue = ((CICSAttribute)DynamicStorageAreaType.CUSHION).set(_cushion, this.record.getNormalizers());
            this.record.set("CUSHION", connectionSpecificExternalValue);
        }
    }

    public void setLimit(Long _limit) {
        if (_limit.equals(this.delegate.getLimit())) {
            this.record.set("LIMIT", null);
        } else {
            DynamicStorageAreaType.LIMIT.validate((Object)_limit);
            String connectionSpecificExternalValue = ((CICSAttribute)DynamicStorageAreaType.LIMIT).set(_limit, this.record.getNormalizers());
            this.record.set("LIMIT", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == DynamicStorageAreaType.NAME) {
            return (V)this.getName();
        }
        if (attribute == DynamicStorageAreaType.SIZE) {
            return (V)this.getSize();
        }
        if (attribute == DynamicStorageAreaType.CUSHION) {
            return (V)this.getCushion();
        }
        if (attribute == DynamicStorageAreaType.PGMONIU) {
            return (V)this.getPgmoniu();
        }
        if (attribute == DynamicStorageAreaType.GETMTOTL) {
            return (V)this.getGetmtotl();
        }
        if (attribute == DynamicStorageAreaType.FREMTOTL) {
            return (V)this.getFremtotl();
        }
        if (attribute == DynamicStorageAreaType.ASUBTOTL) {
            return (V)this.getAsubtotl();
        }
        if (attribute == DynamicStorageAreaType.DSUBTOTL) {
            return (V)this.getDsubtotl();
        }
        if (attribute == DynamicStorageAreaType.NSTGTOTL) {
            return (V)this.getNstgtotl();
        }
        if (attribute == DynamicStorageAreaType.STGSTOTL) {
            return (V)this.getStgstotl();
        }
        if (attribute == DynamicStorageAreaType.NSTGCURR) {
            return (V)this.getNstgcurr();
        }
        if (attribute == DynamicStorageAreaType.STGSHWM) {
            return (V)this.getStgshwm();
        }
        if (attribute == DynamicStorageAreaType.STGPWCNT) {
            return (V)this.getStgpwcnt();
        }
        if (attribute == DynamicStorageAreaType.STGCRELC) {
            return (V)this.getStgcrelc();
        }
        if (attribute == DynamicStorageAreaType.STGSOSC) {
            return (V)this.getStgsosc();
        }
        if (attribute == DynamicStorageAreaType.STGSOST) {
            return (V)this.getStgsost();
        }
        if (attribute == DynamicStorageAreaType.STGNSUBP) {
            return (V)this.getStgnsubp();
        }
        if (attribute == DynamicStorageAreaType.STGFSIZE) {
            return (V)this.getStgfsize();
        }
        if (attribute == DynamicStorageAreaType.STGLSIZE) {
            return (V)this.getStglsize();
        }
        if (attribute == DynamicStorageAreaType.STGVTOTL) {
            return (V)this.getStgvtotl();
        }
        if (attribute == DynamicStorageAreaType.LOCATION) {
            return (V)this.getLocation();
        }
        if (attribute == DynamicStorageAreaType.ACCESSTYPE) {
            return (V)this.getAccesstype();
        }
        if (attribute == DynamicStorageAreaType.STGHWM) {
            return (V)this.getStghwm();
        }
        if (attribute == DynamicStorageAreaType.LIMIT) {
            return (V)this.getLimit();
        }
        if (attribute == DynamicStorageAreaType.POOLPCTFREE) {
            return (V)this.getPoolpctfree();
        }
        if (attribute == DynamicStorageAreaType.PCTFREE) {
            return (V)this.getPctfree();
        }
        if (attribute == DynamicStorageAreaType.STGPROTECT) {
            return (V)this.getStgprotect();
        }
        if (attribute == DynamicStorageAreaType.RNTPGPROTECT) {
            return (V)this.getRntpgprotect();
        }
        if (attribute == DynamicStorageAreaType.TRNISOLATION) {
            return (V)this.getTrnisolation();
        }
        if (attribute == DynamicStorageAreaType.HWMFREE) {
            return (V)this.getHwmfree();
        }
        if (attribute == DynamicStorageAreaType.LWMFREE) {
            return (V)this.getLwmfree();
        }
        if (attribute == DynamicStorageAreaType.CURUNQSSUSRS) {
            return (V)this.getCurunqssusrs();
        }
        if (attribute == DynamicStorageAreaType.CUMUNQSSUSRS) {
            return (V)this.getCumunqssusrs();
        }
        if (attribute == DynamicStorageAreaType.HWMUNQSSUSRS) {
            return (V)this.getHwmunqssusrs();
        }
        if (attribute == DynamicStorageAreaType.CURCMNSSUSRS) {
            return (V)this.getCurcmnssusrs();
        }
        if (attribute == DynamicStorageAreaType.CUMCMNSSUSRS) {
            return (V)this.getCumcmnssusrs();
        }
        if (attribute == DynamicStorageAreaType.HWMCMNSSUSRS) {
            return (V)this.getHwmcmnssusrs();
        }
        if (attribute == DynamicStorageAreaType.CURRALLOC) {
            return (V)this.getCurralloc();
        }
        if (attribute == DynamicStorageAreaType.HWMALLOC) {
            return (V)this.getHwmalloc();
        }
        if (attribute == DynamicStorageAreaType.EXTENTSCURR) {
            return (V)this.getExtentscurr();
        }
        if (attribute == DynamicStorageAreaType.EXTENTSADDED) {
            return (V)this.getExtentsadded();
        }
        if (attribute == DynamicStorageAreaType.EXTENTSDELTD) {
            return (V)this.getExtentsdeltd();
        }
        if (attribute == DynamicStorageAreaType.TIMEWAITMVS) {
            return (V)this.getTimewaitmvs();
        }
        if (attribute == DynamicStorageAreaType.REQSWAITMVS) {
            return (V)this.getReqswaitmvs();
        }
        if (attribute == DynamicStorageAreaType.MEMLIMIT) {
            return (V)this.getMemlimit();
        }
        if (attribute == DynamicStorageAreaType.GETSTORSIZE) {
            return (V)this.getGetstorsize();
        }
        if (attribute == DynamicStorageAreaType.ASACTIVE) {
            return (V)this.getAsactive();
        }
        if (attribute == DynamicStorageAreaType.HWMASACTIVE) {
            return (V)this.getHwmasactive();
        }
        if (attribute == DynamicStorageAreaType.GDSAACTIVE) {
            return (V)this.getGdsaactive();
        }
        if (attribute == DynamicStorageAreaType.HWMGDSAACTIV) {
            return (V)this.getHwmgdsaactiv();
        }
        if (attribute == DynamicStorageAreaType.ATBCUSHRELS) {
            return (V)this.getAtbcushrels();
        }
        if (attribute == DynamicStorageAreaType.ATBCUSHLIMIT) {
            return (V)this.getAtbcushlimit();
        }
        return super.getAttributeValue(attribute);
    }

    public DynamicStorageAreaType getObjectType() {
        return DynamicStorageAreaType.getInstance();
    }

    @Override
    public DynamicStorageAreaReference getCICSObjectReference() {
        return new DynamicStorageAreaReference(this.getCICSContainer(), this.getName());
    }
}

