/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WebServiceReference;
import com.ibm.cics.core.model.WebServiceType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IWebService;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableWebService;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableWebService
extends MutableCICSResource
implements IMutableWebService {
    private IWebService delegate;
    private MutableSMRecord record;

    public MutableWebService(ICPSM cpsm, IContext context, IWebService cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("WEBSERV");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getWSBindFile() {
        return this.delegate.getWSBindFile();
    }

    public String getWSDLFile() {
        return this.delegate.getWSDLFile();
    }

    public String getPipeline() {
        return this.delegate.getPipeline();
    }

    public IWebService.ValidationStatusValue getValidationStatus() {
        String result = this.record.get("VALIDATIONST");
        if (result == null) {
            return this.delegate.getValidationStatus();
        }
        return (IWebService.ValidationStatusValue)((CICSAttribute)WebServiceType.VALIDATION_STATUS).get(result, this.record.getNormalizers());
    }

    public String getURIMap() {
        return this.delegate.getURIMap();
    }

    public String getProgram() {
        return this.delegate.getProgram();
    }

    public String getEndpoint() {
        return this.delegate.getEndpoint();
    }

    public String getBinding() {
        return this.delegate.getBinding();
    }

    public IWebService.ProgramInterfaceValue getProgramInterface() {
        return this.delegate.getProgramInterface();
    }

    public String getContainer() {
        return this.delegate.getContainer();
    }

    public Date getModified() {
        return this.delegate.getModified();
    }

    public IWebService.StateValue getState() {
        return this.delegate.getState();
    }

    public Long getUseCount() {
        return this.delegate.getUseCount();
    }

    public Long getCcsid() {
        return this.delegate.getCcsid();
    }

    public String getMappingLevel() {
        return this.delegate.getMappingLevel();
    }

    public Long getMappingVersion() {
        return this.delegate.getMappingVersion();
    }

    public Long getMappingRelease() {
        return this.delegate.getMappingRelease();
    }

    public String getMinimumRuntimeLevel() {
        return this.delegate.getMinimumRuntimeLevel();
    }

    public Long getMinimumRuntimeVersion() {
        return this.delegate.getMinimumRuntimeVersion();
    }

    public Long getMinimumRuntimeRelease() {
        return this.delegate.getMinimumRuntimeRelease();
    }

    public IWebService.XOPSupportStatusValue getXOPSupportStatus() {
        return this.delegate.getXOPSupportStatus();
    }

    public IWebService.XOPDirectStatusValue getXOPDirectStatus() {
        return this.delegate.getXOPDirectStatus();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public IWebService.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IWebService.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getArchivefile() {
        return this.delegate.getArchivefile();
    }

    public void setValidationStatus(IWebService.ValidationStatusValue _validationStatus) {
        if (_validationStatus.equals((Object)this.delegate.getValidationStatus())) {
            this.record.set("VALIDATIONST", null);
        } else {
            WebServiceType.VALIDATION_STATUS.validate((Object)_validationStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)WebServiceType.VALIDATION_STATUS).set(_validationStatus, this.record.getNormalizers());
            this.record.set("VALIDATIONST", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WebServiceType.NAME) {
            return (V)this.getName();
        }
        if (attribute == WebServiceType.WS_BIND_FILE) {
            return (V)this.getWSBindFile();
        }
        if (attribute == WebServiceType.WSDL_FILE) {
            return (V)this.getWSDLFile();
        }
        if (attribute == WebServiceType.PIPELINE) {
            return (V)this.getPipeline();
        }
        if (attribute == WebServiceType.VALIDATION_STATUS) {
            return (V)this.getValidationStatus();
        }
        if (attribute == WebServiceType.URI_MAP) {
            return (V)this.getURIMap();
        }
        if (attribute == WebServiceType.PROGRAM) {
            return (V)this.getProgram();
        }
        if (attribute == WebServiceType.ENDPOINT) {
            return (V)this.getEndpoint();
        }
        if (attribute == WebServiceType.BINDING) {
            return (V)this.getBinding();
        }
        if (attribute == WebServiceType.PROGRAM_INTERFACE) {
            return (V)this.getProgramInterface();
        }
        if (attribute == WebServiceType.CONTAINER) {
            return (V)this.getContainer();
        }
        if (attribute == WebServiceType.MODIFIED) {
            return (V)this.getModified();
        }
        if (attribute == WebServiceType.STATE) {
            return (V)this.getState();
        }
        if (attribute == WebServiceType.USE_COUNT) {
            return (V)this.getUseCount();
        }
        if (attribute == WebServiceType.CCSID) {
            return (V)this.getCcsid();
        }
        if (attribute == WebServiceType.MAPPING_LEVEL) {
            return (V)this.getMappingLevel();
        }
        if (attribute == WebServiceType.MAPPING_VERSION) {
            return (V)this.getMappingVersion();
        }
        if (attribute == WebServiceType.MAPPING_RELEASE) {
            return (V)this.getMappingRelease();
        }
        if (attribute == WebServiceType.MINIMUM_RUNTIME_LEVEL) {
            return (V)this.getMinimumRuntimeLevel();
        }
        if (attribute == WebServiceType.MINIMUM_RUNTIME_VERSION) {
            return (V)this.getMinimumRuntimeVersion();
        }
        if (attribute == WebServiceType.MINIMUM_RUNTIME_RELEASE) {
            return (V)this.getMinimumRuntimeRelease();
        }
        if (attribute == WebServiceType.XOP_SUPPORT_STATUS) {
            return (V)this.getXOPSupportStatus();
        }
        if (attribute == WebServiceType.XOP_DIRECT_STATUS) {
            return (V)this.getXOPDirectStatus();
        }
        if (attribute == WebServiceType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == WebServiceType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == WebServiceType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == WebServiceType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == WebServiceType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == WebServiceType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == WebServiceType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == WebServiceType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == WebServiceType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == WebServiceType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == WebServiceType.ARCHIVEFILE) {
            return (V)this.getArchivefile();
        }
        return super.getAttributeValue(attribute);
    }

    public WebServiceType getObjectType() {
        return WebServiceType.getInstance();
    }

    @Override
    public WebServiceReference getCICSObjectReference() {
        return new WebServiceReference(this.getCICSContainer(), this.getName());
    }
}

