/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.model.CICSRegionDefinitionInstallTarget;
import com.ibm.cics.model.CICSRegionGroupDefinitionInstallTarget;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.sm.comm.CSDRepository;
import com.ibm.cics.sm.comm.Context;
import com.ibm.cics.sm.comm.DREPRepository;
import com.ibm.cics.sm.comm.FilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.ScopedContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RepositoryDiscoverer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(RepositoryDiscoverer.class);

    public static List<IRepository> getRepositories(ISystemManagerConnection conn) {
        HashMap cicsplexMap = new HashMap();
        HashMap cicsplexRegions = new HashMap();
        ArrayList<String> cicsplexes = new ArrayList<String>();
        try {
            SMConnectionResponse response = conn.getResources("CICSPLEX", new Context(null));
            int i = 0;
            while (i < response.getRecordCount()) {
                cicsplexes.add(response.getRecord(i).get("PLEXNAME"));
                ++i;
            }
        }
        catch (AuthenticationException e) {
            RepositoryDiscoverer.handleAuthException(e);
            return Collections.emptyList();
        }
        catch (ConnectionException e) {
            debug.event("getRepositories0", (Object)e);
        }
        ArrayList<Object> cicsplexTargets = new ArrayList<Object>();
        ArrayList<String> cicsplexRegionNames = new ArrayList<String>();
        for (String cicsplex : cicsplexes) {
            cicsplexTargets.clear();
            cicsplexRegionNames.clear();
            try {
                SMConnectionResponse response = conn.getResources("CSYSDEF", new Context(cicsplex));
                int i = 0;
                while (i < response.getRecordCount()) {
                    String regName = response.getRecord(i).get("NAME");
                    cicsplexTargets.add(new CICSRegionDefinitionInstallTarget(cicsplex, regName));
                    cicsplexRegionNames.add(regName);
                    ++i;
                }
                cicsplexRegions.put(cicsplex, new ArrayList(cicsplexRegionNames));
                response = conn.getResources("CSYSGRP", new Context(cicsplex));
                i = 0;
                while (i < response.getRecordCount()) {
                    String groupName = response.getRecord(i).get("GROUP");
                    cicsplexTargets.add(new CICSRegionGroupDefinitionInstallTarget(cicsplex, groupName));
                    ++i;
                }
                if (cicsplexTargets.size() <= 0) continue;
                cicsplexMap.put(cicsplex, new ArrayList(cicsplexTargets));
            }
            catch (AuthenticationException e) {
                RepositoryDiscoverer.handleAuthException(e);
                return Collections.emptyList();
            }
            catch (ConnectionException e) {
                debug.event("getRepositories1", (Object)e);
            }
        }
        HashMap csdMap = new HashMap();
        for (Map.Entry entry : cicsplexRegions.entrySet()) {
            Context cicsplexContext = new Context((String)entry.getKey());
            for (String regionName : (List)entry.getValue()) {
                ScopedContext regionContext = new ScopedContext(cicsplexContext, regionName);
                try {
                    SMConnectionResponse fileResponse = conn.getResources("LOCFILE", RepositoryDiscoverer.getDFHCSDFilteredContext(regionContext));
                    if (fileResponse.getRecordCount() == 1) {
                        String csd = fileResponse.getRecord(0).get("DSNAME");
                        if (!csdMap.containsKey(csd)) {
                            csdMap.put(csd, new ArrayList());
                        }
                        ((List)csdMap.get(csd)).add(new CICSRegionDefinitionInstallTarget(cicsplexContext.getContext(), regionName));
                        continue;
                    }
                    debug.event("getRepositories3", "Couldn't find a csd for region " + regionName);
                }
                catch (AuthenticationException e) {
                    RepositoryDiscoverer.handleAuthException(e);
                    return Collections.emptyList();
                }
                catch (ConnectionException e) {
                    debug.event("getRepositories2", (Object)e);
                }
            }
        }
        ArrayList<IRepository> repos = new ArrayList<IRepository>();
        for (Map.Entry entry : cicsplexMap.entrySet()) {
            repos.add(new DREPRepository((String)entry.getKey(), (List)entry.getValue()));
        }
        for (Map.Entry entry : csdMap.entrySet()) {
            repos.add(new CSDRepository((String)entry.getKey(), (List)entry.getValue()));
        }
        return repos;
    }

    /*
     * WARNING - void declaration
     */
    public static List<IRepository> getSingleServerRepositories(ISystemManagerConnection conn) {
        ArrayList<Object> regNames = new ArrayList<Object>();
        try {
            void var3_6;
            SMConnectionResponse response = conn.getResources("CSYSDEF", new Context(null));
            boolean bl = false;
            while (var3_6 < response.getRecordCount()) {
                String regName = response.getRecord((int)var3_6).get("NAME");
                regNames.add(regName);
                ++var3_6;
            }
        }
        catch (AuthenticationException e) {
            RepositoryDiscoverer.handleAuthException(e);
            return Collections.emptyList();
        }
        catch (ConnectionException e) {
            debug.event("getSingleServerRepositories1", (Object)e);
        }
        HashMap csdMap = new HashMap();
        for (String string : regNames) {
            Context regionContext = new Context(string);
            try {
                SMConnectionResponse fileResponse = conn.getResources("LOCFILE", RepositoryDiscoverer.getDFHCSDFilteredContext(regionContext));
                if (fileResponse.getRecordCount() == 1) {
                    String csd = fileResponse.getRecord(0).get("DSNAME");
                    if (!csdMap.containsKey(csd)) {
                        csdMap.put(csd, new ArrayList());
                    }
                    ((List)csdMap.get(csd)).add(new CICSRegionDefinitionInstallTarget(regionContext.getContext(), string));
                    continue;
                }
                debug.event("getSingleServerRepositories3", "Couldn't find a csd for region " + string);
            }
            catch (AuthenticationException e) {
                RepositoryDiscoverer.handleAuthException(e);
                return Collections.emptyList();
            }
            catch (ConnectionException e) {
                debug.event("getSingleServerRepositories2", (Object)e);
            }
        }
        ArrayList<IRepository> arrayList = new ArrayList<IRepository>();
        for (Map.Entry entry : csdMap.entrySet()) {
            arrayList.add(new CSDRepository((String)entry.getKey(), (List)entry.getValue()));
        }
        return arrayList;
    }

    private static void handleAuthException(AuthenticationException e) {
        debug.error("handleAuthException", (Throwable)e);
    }

    private static IContext getDFHCSDFilteredContext(IContext baseContext) {
        return new FilteredContext(baseContext, FilteredContext.av("FILE", "DFHCSD"));
    }
}

