/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.ApplicationContext;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IApplicationContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;

public class ScopedContext
implements IScopedContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String context;
    private String scope;

    public ScopedContext(IContext context, String scope) {
        this.context = context.getContext();
        this.scope = scope;
    }

    public ScopedContext(String context, String scope) {
        this.context = context;
        this.scope = scope;
    }

    public ScopedContext(IScopedContext scopedContext) {
        this.context = scopedContext.getContext();
        this.scope = scopedContext.getScope();
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IScopedContext) {
            if (this.equals((IScopedContext)obj)) {
                IApplicationContext objAppCtxt = ContextHelper.getContextFrom((IScopedContext)obj, IApplicationContext.class);
                IApplicationContext thisAppCtxt = ContextHelper.getContextFrom(this, IApplicationContext.class);
                return ApplicationContext.isApplicationContextTheSame(objAppCtxt, thisAppCtxt);
            }
            return false;
        }
        return false;
    }

    private static boolean contextsEqual(IScopedContext one, IScopedContext two) {
        return one.getContext() == null ? two.getContext() == null : one.getContext().equals(two.getContext());
    }

    private static boolean scopesEquals(IScopedContext one, IScopedContext two) {
        return one.getScope() == null ? two.getScope() == null : one.getScope().equals(two.getScope());
    }

    public boolean equals(IScopedContext that) {
        return that != null && ScopedContext.contextsEqual(this, that) && ScopedContext.scopesEquals(this, that);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.context + "/" + this.scope + "]";
    }
}

