/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.common.util.StaleableEventListener;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.IConnectionManager;
import java.util.HashMap;
import java.util.Map;

public class DefaultConnectionService {
    private final Map<IConnectionCategory, ConnectionProfile> defaultConnections = new HashMap<IConnectionCategory, ConnectionProfile>();
    private boolean isConnectAutomatically = false;
    private EventManager<DefaultConnectionChangedEvent> eventManager = new EventManager();
    private IConnectionManager connectionManager;

    public DefaultConnectionService(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.addListener(new ConnectionManagerListener(){

            public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
                if (event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                    ConnectionManagerListener.ConnectionProfileRemovedEvent connectionProfileRemovedEvent = (ConnectionManagerListener.ConnectionProfileRemovedEvent)event;
                    this.updateDefault(connectionProfileRemovedEvent.getConnectionProfile(), null);
                } else if (event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent) {
                    ConnectionManagerListener.ConnectionProfileUpdatedEvent connectionProfileUpdatedEvent = (ConnectionManagerListener.ConnectionProfileUpdatedEvent)event;
                    this.updateDefault(connectionProfileUpdatedEvent.getOldConnectionProfile(), connectionProfileUpdatedEvent.getConnectionProfile());
                }
            }

            public void updateDefault(ConnectionProfile oldConnectionProfile, ConnectionProfile newConnectionProfile) {
                if (DefaultConnectionService.this.isDefault(oldConnectionProfile)) {
                    DefaultConnectionService.this.setDefaultConnectionProfile(oldConnectionProfile.getConnectionDescriptor().getCategory(), newConnectionProfile);
                }
            }
        });
    }

    public boolean isDefault(ConnectionProfile connectionProfile) {
        if (connectionProfile != null) {
            IConnectionCategory category = connectionProfile.getConnectionDescriptor().getCategory();
            ConnectionProfile defaultConnectionProfile = this.getDefaultConnectionProfile(category);
            if (defaultConnectionProfile != null) {
                return connectionProfile.equals(defaultConnectionProfile);
            }
            return connectionProfile == null;
        }
        return false;
    }

    public ConnectionProfile getDefaultConnectionProfile(IConnectionCategory category) {
        return this.defaultConnections.get(category);
    }

    public void setDefaultConnectionProfile(IConnectionCategory category, ConnectionProfile profile) {
        ConnectionProfile oldProfile = this.defaultConnections.put(category, profile);
        this.eventManager.notifyListeners((Object)new DefaultConnectionChangedEvent(category, oldProfile, profile));
    }

    public void addDefaultConnectionServiceListener(DefaultConnectionServiceListener defaultConnectionServiceListener) {
        this.eventManager.addListener((IStaleableEventListener)defaultConnectionServiceListener);
    }

    public static class DefaultConnectionChangedEvent {
        private final IConnectionCategory category;
        private final ConnectionProfile oldProfile;
        private final ConnectionProfile newProfile;

        DefaultConnectionChangedEvent(IConnectionCategory category, ConnectionProfile oldProfile, ConnectionProfile newProfile) {
            this.category = category;
            this.oldProfile = oldProfile;
            this.newProfile = newProfile;
        }

        public IConnectionCategory getCategory() {
            return this.category;
        }

        public ConnectionProfile getNewProfile() {
            return this.newProfile;
        }

        public ConnectionProfile getOldProfile() {
            return this.oldProfile;
        }
    }

    public static abstract class DefaultConnectionServiceListener
    extends StaleableEventListener<DefaultConnectionChangedEvent> {
    }
}

