/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.Activator;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IPassphraseManager;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionWidgetManager;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionCredentialsManager;
import com.ibm.cics.core.connections.IConnectionUserInterfaceService;
import com.ibm.cics.core.connections.internal.ConnectablesRegistry;
import com.ibm.cics.core.connections.internal.ConnectionCredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionCustomizerRegistry;
import com.ibm.cics.core.connections.internal.ConnectionExceptionMessageHelper;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionParameterImporter;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.ConnectionUserInterfaceService;
import com.ibm.cics.core.connections.internal.CredentialsManager;
import com.ibm.cics.core.connections.internal.DefaultConnectionDeserializer;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.MisconfiguredSecurityResolver;
import com.ibm.cics.core.connections.internal.OldConnectionReader;
import com.ibm.cics.core.connections.internal.PassphraseManager;
import com.ibm.cics.core.connections.internal.PasswordDialogAuthenticationProvider;
import com.ibm.cics.eclipse.common.IConnectionPasswordStorage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class InternalConnectionsPlugin
extends ConnectionsPlugin {
    private static final String CONNECT_AUTOMATICALLY_KEY = "isConnectAutomatically";
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static InternalConnectionsPlugin plugin;
    private static final Debug debug;
    public static final String CICS_SM_CONNECTION_CATEGORY_ID = "com.ibm.cics.sm.connection";
    public static final String FILE_CONNECTIONS_SUFFIX = ".pref";
    private static final String LAST_CONNECTIONS_PREF_NODE = "lastConnections";
    private static final String CONNECTIONS_NODE_NAME = "connections";
    private ConnectionCustomizerRegistry connectionCustomizerRegistry;
    private ConnectionService connectionService;
    private ConnectionManager connectionManager;
    private CredentialsManager credentialsManager;
    private ConnectionWidgetManager connectionWidgetManager;
    private ConnectionUserInterfaceService connectionUserInterfaceService;
    private IPassphraseManager passphraseManager;
    private ConnectionProviderRegistry connectionProviderRegistry;
    private ConnectionCredentialsManager connectionCredentialsManager;
    private ConnectionRegistry connectionRegistry;
    private DefaultConnectionService defaultConnectionService;

    static {
        debug = new Debug(InternalConnectionsPlugin.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Logger logger = Logger.getLogger("com.ibm.cics.core.connections");
        logger.setLevel(Level.FINER);
        boolean canSavePasswords = true;
        if (this.getPreferenceStore().contains("passwordSaveable")) {
            canSavePasswords = this.getPreferenceStore().getBoolean("passwordSaveable");
        }
        if (canSavePasswords) {
            boolean cantSavePasswords = InstanceScope.INSTANCE.getNode("com.ibm.cics.core.ui").getBoolean("canSavePassword", false);
            canSavePasswords = !cantSavePasswords;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.ibm.cics.core.connections");
        boolean cSP = canSavePasswords;
        this.initialiseTrust(cSP);
        IConnectionPasswordStorage passwordStorage = IConnectionPasswordStorage.Factory.create((String)"com.ibm.cics.core.connections");
        this.credentialsManager = new CredentialsManager((Preferences)prefs, passwordStorage, canSavePasswords);
        this.connectionProviderRegistry = ConnectionProviderRegistry.getDefault();
        this.connectionCredentialsManager = new ConnectionCredentialsManager(this.credentialsManager);
        this.connectionRegistry = ConnectionRegistry.getConnectionRegistry();
        this.connectionManager = new ConnectionManager(this.connectionProviderRegistry, this.connectionRegistry, this.connectionCredentialsManager);
        PasswordDialogAuthenticationProvider authenticationProvider = new PasswordDialogAuthenticationProvider(this.credentialsManager, this.connectionManager);
        MisconfiguredSecurityResolver securityResolver = new MisconfiguredSecurityResolver();
        Map<String, String> lastUsedConfigs = this.getLastUsedConfigs();
        this.defaultConnectionService = new DefaultConnectionService(this.connectionManager);
        new DefaultConnectionDeserializer(this.defaultConnectionService, this.connectionManager, (Preferences)prefs, this.connectionRegistry);
        ConnectablesRegistry connectablesRegistry = new ConnectablesRegistry();
        this.connectionService = new ConnectionService(this.connectionManager, this.credentialsManager, this.connectionRegistry, authenticationProvider, securityResolver, lastUsedConfigs, this.defaultConnectionService, connectablesRegistry);
        this.connectionService.addConnectionServiceListener(new ConnectionServiceListener(){

            public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
                Exception ex;
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    event.getConnectable().getConnection();
                    String message = MessageFormat.format(Messages.IZE0100I_connected, event.getConnectionProfile().getDescription());
                    InternalConnectionsPlugin.logInfo(message);
                } else if (event instanceof ConnectionServiceListener.ExceptionEvent && (ex = ((ConnectionServiceListener.ExceptionEvent)event).getException()) != null) {
                    String message = ConnectionExceptionMessageHelper.getMessage(ex, event.getConnectionProfile().getName());
                    InternalConnectionsPlugin.logWarning(message, ex);
                }
            }
        });
        this.connectionWidgetManager = new ConnectionWidgetManager(this.connectionService);
        this.connectionUserInterfaceService = new ConnectionUserInterfaceService(this.connectionManager);
        if (prefs.nodeExists(CONNECTIONS_NODE_NAME)) {
            Preferences connectionsNode = prefs.node(CONNECTIONS_NODE_NAME);
            ConnectionParameterImporter migrator = new ConnectionParameterImporter(ConnectionRegistry.getConnectionRegistry(), this.connectionProviderRegistry.getLocalConnectionProvider());
            OldConnectionReader connectionReader = new OldConnectionReader(connectionsNode, false);
            migrator.importConnections(connectionReader, false);
            String[] stringArray = connectionsNode.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeName = stringArray[n2];
                if (!"CONNECTION_SOURCES".equals(nodeName)) {
                    connectionsNode.node(nodeName).removeNode();
                }
                ++n2;
            }
        }
        if (this.isConnectAutomatically()) {
            this.connectionService.connectToDefaultConnections();
        }
    }

    public boolean isConnectAutomatically() {
        return this.getPluginInstancePreferences().getBoolean(CONNECT_AUTOMATICALLY_KEY, false);
    }

    public void setConnectAutomatically(boolean connectAutomatically) {
        this.getPluginInstancePreferences().putBoolean(CONNECT_AUTOMATICALLY_KEY, connectAutomatically);
    }

    private Map<String, String> getLastUsedConfigs() {
        Preferences prefs = InstanceScope.INSTANCE.getNode("com.ibm.cics.core.connections").node(LAST_CONNECTIONS_PREF_NODE);
        HashMap<String, String> lastUsedConfigs = new HashMap<String, String>();
        IConnectionCategory[] iConnectionCategoryArray = this.connectionRegistry.getConnectionCategories();
        int n = iConnectionCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionCategory category = iConnectionCategoryArray[n2];
            lastUsedConfigs.put(category.getId(), prefs.get(category.getId(), null));
            ++n2;
        }
        return lastUsedConfigs;
    }

    private void saveLastUsedConfigs(Map<String, String> lastUsedConfigs) {
        Preferences prefs = InstanceScope.INSTANCE.getNode("com.ibm.cics.core.connections").node(LAST_CONNECTIONS_PREF_NODE);
        try {
            prefs.clear();
            for (Map.Entry<String, String> lastUsedConfig : lastUsedConfigs.entrySet()) {
                prefs.put(lastUsedConfig.getKey(), lastUsedConfig.getValue());
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            debug.error("saveLastUsedConfigs", (Throwable)e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.saveLastUsedConfigs(this.connectionService.getLastUsedConfigs());
        this.connectionWidgetManager.dispose();
        plugin = null;
        super.stop(context);
    }

    public static InternalConnectionsPlugin getDefault() {
        return plugin;
    }

    public static void logInfo(String message) {
        InternalConnectionsPlugin.log(1, message, null);
    }

    public static void logWarning(String message) {
        InternalConnectionsPlugin.logWarning(message, null);
    }

    public static void logWarning(String message, Throwable t) {
        InternalConnectionsPlugin.log(2, message, t);
    }

    public static void logError(String message) {
        InternalConnectionsPlugin.logError(message, null);
    }

    public static void logError(Throwable t) {
        InternalConnectionsPlugin.logError(t.getLocalizedMessage(), t);
    }

    public static void logError(String message, Throwable t) {
        InternalConnectionsPlugin.log(4, message, t);
    }

    public static void log(IStatus status) {
        InternalConnectionsPlugin.getDefault().getLog().log(status);
    }

    private static void log(int severity, String message, Throwable t) {
        Status status = new Status(severity, "com.ibm.cics.core.connections", severity, message, t);
        InternalConnectionsPlugin.getDefault().getLog().log((IStatus)status);
    }

    public ConnectionCustomizerRegistry getConnectionCustomizerRegistry() {
        if (this.connectionCustomizerRegistry == null) {
            this.connectionCustomizerRegistry = new ConnectionCustomizerRegistry();
        }
        return this.connectionCustomizerRegistry;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public CredentialsManager getCredentialsManager() {
        return this.credentialsManager;
    }

    @Override
    public ConnectionService getConnectionService() {
        return this.connectionService;
    }

    public IPassphraseManager getPassphraseManager() {
        return this.passphraseManager;
    }

    @Override
    public IConnectionUserInterfaceService getConnectionUserInterfaceService() {
        return this.connectionUserInterfaceService;
    }

    @Override
    public ConnectionWidgetManager getActiveConnectionCategoryService() {
        return this.connectionWidgetManager;
    }

    public IEclipsePreferences getPluginInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    public IEclipsePreferences getPluginDefaultPreferences() {
        return DefaultScope.INSTANCE.getNode(this.getBundle().getSymbolicName());
    }

    private void initialiseTrust(boolean canSavePasswords) {
        IConnectionPasswordStorage passwordStorage2 = IConnectionPasswordStorage.Factory.create((String)"com.ibm.cics.core.passphrase");
        IEclipsePreferences prefs2 = InstanceScope.INSTANCE.getNode("com.ibm.cics.core.connections.keystore");
        CredentialsManager credentialsManager2 = new CredentialsManager((Preferences)prefs2, passwordStorage2, canSavePasswords);
        this.passphraseManager = new PassphraseManager(credentialsManager2);
        ExplorerSecurityHelper.setPassphraseManager((IPassphraseManager)this.passphraseManager);
        if (Activator.getDefault().initialiseTrust()) {
            this.passphraseManager.setTrustStorePassphrase("changeit");
            this.passphraseManager.setKeyStorePassphrase("changeit");
        } else {
            String ksp = this.passphraseManager.getKeyStorePassphrase();
            String tsp = this.passphraseManager.getTrustStorePassphrase();
            if (StringUtil.hasContent((String)ExplorerSecurityHelper.validateTrustStoreDetail()) && !StringUtil.hasContent((String)ksp) && !StringUtil.hasContent((String)tsp) && ExplorerSecurityHelper.getCurrentTrustStore().endsWith("explorer_keystore.jks") && ExplorerSecurityHelper.getCurrentKeyStore().endsWith("explorer_keystore.jks")) {
                this.passphraseManager.setTrustStorePassphrase("changeit");
                this.passphraseManager.setKeyStorePassphrase("changeit");
            }
        }
    }

    @Override
    public ConnectionProviderRegistry getConnectionProviderRegistry() {
        return this.connectionProviderRegistry;
    }

    @Override
    public IConnectionCredentialsManager getConnectionCredentialsManager() {
        return this.connectionCredentialsManager;
    }

    public static /* bridge */ /* synthetic */ ConnectionsPlugin getDefault() {
        return InternalConnectionsPlugin.getDefault();
    }
}

