/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.common.util.LabelUtil;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConfigurationUtils;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.PasswordComposite;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PasswordDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PasswordComposite passwordComposite;
    private final ICredentialsManager credentialsManager;
    private ConnectionProfile config;
    private CredentialsConfiguration credentialsConfiguration;
    private CredentialsMode mode = CredentialsMode.AUTHENTICATE_CREDENTIAL;
    private ConnectionManager connectionManager;

    public PasswordDialog(Shell parentShell, String configurationId, ICredentialsManager credentialsManager, ConnectionManager connectionManager) {
        super(parentShell);
        this.credentialsManager = credentialsManager;
        this.config = connectionManager.getConnectionProfile(configurationId);
        this.connectionManager = connectionManager;
        this.credentialsConfiguration = this.config.getCredentials();
        this.mode = credentialsManager.getAllCredentials().isEmpty() ? CredentialsMode.CREATE_FIRST_CREDENTIAL : (this.credentialsConfiguration == null ? CredentialsMode.CREATE_CREDENTIAL : CredentialsMode.AUTHENTICATE_CREDENTIAL);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        String userID;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.password_dialog");
        this.getShell().setText(Messages.PasswordDialog_signon);
        this.setTitleImage(ConnectionsImages.getImage("PASSWORD_WIZ_BAN"));
        String descriptorName = this.config.getConnectionDescriptor() != null ? this.config.getConnectionDescriptor().getName() : "";
        String configurationName = this.credentialsConfiguration != null ? this.credentialsConfiguration.getName() : "";
        this.setTitle(String.valueOf(LabelUtil.appendColon((String)descriptorName)) + " " + configurationName);
        this.setMessage(this.config.getName());
        boolean passwordSaveable = this.credentialsManager.isPasswordSaveable();
        this.passwordComposite = new PasswordComposite(parent, 0, true, passwordSaveable, this.mode, this.credentialsManager);
        GridData data = new GridData(4, 4, true, true);
        this.passwordComposite.setLayoutData(data);
        if (this.mode == CredentialsMode.AUTHENTICATE_CREDENTIAL && this.config.getCredentials() != null) {
            this.passwordComposite.setCredentialsIsDefaultValue(ConnectionUtils.generateName(this.config.getName(), IDFactory.getUserid8()).equals(this.credentialsConfiguration.getName()));
        }
        this.passwordComposite.setHostName(ConfigurationUtils.getHost(this.config));
        this.passwordComposite.setConnectionDescription(this.config.getName());
        this.passwordComposite.setSavePassword(this.credentialsConfiguration != null ? this.credentialsConfiguration.isSavePassword() : false);
        String string = userID = this.credentialsConfiguration != null ? this.credentialsConfiguration.getUserID() : null;
        if (StringUtil.hasContent((String)userID)) {
            this.passwordComposite.setUserID(userID);
        }
        this.passwordComposite.setCredentials(this.config.getCredentials());
        if (this.credentialsConfiguration != null && this.credentialsConfiguration.getPassword() != null) {
            this.passwordComposite.setPassword(this.credentialsConfiguration.getPassword());
        }
        GridLayout layout = (GridLayout)this.passwordComposite.getLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginLeft = 10;
        switch (this.mode) {
            case CREATE_FIRST_CREDENTIAL: {
                this.passwordComposite.userIDText.setFocus();
                this.passwordComposite.userIDText.selectAll();
                break;
            }
            case AUTHENTICATE_CREDENTIAL: {
                this.passwordComposite.passwordText.setFocus();
            }
        }
        this.passwordComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordDialog.this.validate();
            }
        });
        return this.passwordComposite;
    }

    public ConnectionProfile getConfig() {
        return this.config;
    }

    protected Control createButtonBar(Composite parent) {
        Control c = super.createButtonBar(parent);
        this.validate();
        return c;
    }

    private void validate() {
        this.setMessage(this.config.getName());
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
        if (this.mode == CredentialsMode.AUTHENTICATE_CREDENTIAL || this.mode == CredentialsMode.CREATE_FIRST_CREDENTIAL || this.passwordComposite.shouldCreateNewCredentials()) {
            boolean error = false;
            if (this.mode != CredentialsMode.AUTHENTICATE_CREDENTIAL) {
                if (StringUtil.isEmpty((String)this.passwordComposite.getCredentialsName())) {
                    this.setErrorMessage(Messages.CredentialsPreferencePage_invalidName);
                    error = true;
                } else if (this.isDuplicateInList(this.passwordComposite.getCredentialsName())) {
                    this.setErrorMessage(Messages.CredentialsPreferencePage_duplicateName);
                    error = true;
                }
            }
            if (StringUtil.isEmpty((String)this.passwordComposite.getUserID())) {
                this.setErrorMessage(Messages.CredentialsDialog_mandatoryUserID);
                error = true;
            }
            this.getButton(0).setEnabled(!error);
        }
    }

    private boolean isDuplicateInList(String newName) {
        for (CredentialsConfiguration credential : this.credentialsManager.getAllCredentials()) {
            if (!newName.equals(credential.getName())) continue;
            if (this.credentialsConfiguration != null) {
                if (this.credentialsConfiguration.getID().equals(credential.getID())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    PasswordComposite getPasswordComposite() {
        return this.passwordComposite;
    }

    protected void okPressed() {
        if (this.mode == CredentialsMode.CREATE_FIRST_CREDENTIAL) {
            this.credentialsConfiguration = CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.passwordComposite.getCredentialsName(), (String)this.passwordComposite.getUserID(), (String)this.passwordComposite.getPassword(), (boolean)this.passwordComposite.isSavePassword());
            this.confirmCredentials(this.credentialsConfiguration, true);
        } else if (this.mode == CredentialsMode.AUTHENTICATE_CREDENTIAL) {
            this.credentialsConfiguration.setUserID(this.passwordComposite.getUserID());
            this.credentialsConfiguration.setPassword(this.passwordComposite.getPassword());
            this.credentialsConfiguration.setSavePassword(this.passwordComposite.isSavePassword());
            this.confirmCredentials(this.credentialsConfiguration, true);
        } else if (this.mode == CredentialsMode.CREATE_CREDENTIAL) {
            if (this.passwordComposite.shouldCreateNewCredentials()) {
                this.credentialsConfiguration = CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.passwordComposite.getCredentialsName(), (String)this.passwordComposite.getUserID(), (String)this.passwordComposite.getPassword(), (boolean)this.passwordComposite.isSavePassword());
                this.confirmCredentials(this.credentialsConfiguration, true);
            } else {
                this.credentialsConfiguration = this.passwordComposite.getCredentialsConfiguration();
                this.confirmCredentials(this.credentialsConfiguration, false);
            }
        }
        super.okPressed();
    }

    private void confirmCredentials(CredentialsConfiguration aCredentialsConfiguration, boolean auth) {
        if (auth) {
            this.credentialsManager.update(this.credentialsConfiguration, true);
        }
        if (this.config.getCredentials() == null) {
            this.connectionManager.getConnectionCredentialsManager().associate(this.config.getId(), aCredentialsConfiguration.getID());
        }
    }
}

