/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.comm.internal.ConnectionCategory;
import com.ibm.cics.core.connections.ConnectionManagerListener;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.CredentialsManagerListener;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IConnectionProviderRegistry;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.IConnectionUserInterfaceService;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.connections.internal.ConnectingState;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.ConnectionService;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.DefaultConnectionService;
import com.ibm.cics.core.connections.internal.DisconnectedState;
import com.ibm.cics.core.connections.internal.ExceptionState;
import com.ibm.cics.core.connections.internal.ExplorerConnectionProvider;
import com.ibm.cics.core.connections.internal.FilteredConnectionRegistry;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.ILocationConnectionProvider;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.RefreshConnectionProviderJob;
import com.ibm.cics.core.connections.internal.views.AddProviderDialog;
import com.ibm.cics.core.connections.internal.views.ConnectionConfigurationElementComparer;
import com.ibm.cics.core.connections.internal.views.ConnectionsContentProvider;
import com.ibm.cics.core.connections.internal.views.ConnectionsLabelDecorator;
import com.ibm.cics.core.connections.internal.views.ConnectionsLabelProvider;
import com.ibm.cics.core.connections.internal.views.ConnectionsViewFilter;
import com.ibm.cics.core.connections.internal.views.CreateConnectionAction;
import com.ibm.cics.core.connections.internal.views.CredentialsContentProvider;
import com.ibm.cics.core.connections.internal.views.CredentialsLabelDecorator;
import com.ibm.cics.core.connections.internal.views.CredentialsLabelProvider;
import com.ibm.cics.core.connections.internal.views.ExportConnectionsDialog;
import com.ibm.cics.core.connections.internal.views.Messages;
import com.ibm.cics.core.connections.internal.views.ShowProvidersAction;
import com.ibm.cics.core.connections.internal.views.UpdateCredentialsOperation;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import com.ibm.cics.eclipse.common.ui.LightweightSashForm;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.ViewPart;

public class HostConnectionsView
extends ViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String ID = "com.ibm.cics.explorer.connections_view";
    private FilteredConnectionRegistry filteredRegistry = new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry());
    private PatternFilter patternFilter;
    private TreeViewer treeViewer;
    private static int BUTTON_WIDTH = 80;
    private final ConnectionsContentProvider connectionsContentProvider = new ConnectionsContentProvider(Arrays.asList(this.filteredRegistry.getConnections()), ConnectionProviderRegistry.getDefault());
    private Action openConnectionAction;
    private Action deleteConnectionAction;
    private Action refreshProviderAction;
    private CredentialsLabelProvider credentialsLabelProvider;
    private ConnectionService connectionService = InternalConnectionsPlugin.getDefault().getConnectionService();
    private ConnectionManager connectionManager = this.connectionService.getConnectionManager();
    private DefaultConnectionService defaultConnectionService = this.connectionService.getDefaultConnectionService();
    private IConnectionUserInterfaceService connectionUserInterfaceService = ConnectionsPlugin.getDefault().getConnectionUserInterfaceService();
    private ConnectionProviderRegistry connectionProviderRegistry = ConnectionProviderRegistry.getDefault();
    private FilteredConnectionRegistry connectionRegistry = new FilteredConnectionRegistry(ConnectionRegistry.getConnectionRegistry());
    private WritableValue selectedState = new WritableValue();
    private ConnectionManagerListener connectionManagerListener;
    private MenuManager setCredentialsMenuManager;
    private UndoActionHandler undoActionHandler;
    private Action showProvidersAction;
    private Action addProvidersAction;
    private Color decorationColor = new Color((Device)Display.getDefault(), 149, 125, 71);
    private Action exportConnectionsActions;
    private Action editProviderAction;
    private Action removeProviderAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action createConnectionToolbarAction;
    private Action autoConnectToDefaultsAction;
    private SelectionAdapter connectionMenuItemSelectionListener;
    private IObservableMap categoryActiveConnectionState = new WritableMap();
    private ConnectionServiceListener connectionServiceListener;
    private FormToolkit formToolkit;
    private Section connectionsSection;
    private Section credentialsSection;
    private Button createConnectionButton;
    private Button openConnectionButton;
    private Button deleteConnectionButton;
    private Button connectButton;
    private Button disconnectButton;
    private TableViewer credentialsTableViewer;
    private Button createCredentialsButton;
    private Button deleteCredentialsButton;
    private Button openCredentialsButton;
    private CredentialsManagerListener credentialsManagerListener;
    private IConnectionProviderRegistry.ConnectionProviderRegistryListener connectionProviderRegistryListener;
    private CredentialsContentProvider credentialsContentManager;
    private Action openCredentialsAction;
    private Action removeCredentialsAction;
    private DataBindingContext dbc;
    private ComputedValue deleteEnablement;
    private DefaultConnectionService.DefaultConnectionServiceListener defaultConnectionServiceListener = new DefaultConnectionService.DefaultConnectionServiceListener(){

        public void event(DefaultConnectionService.DefaultConnectionChangedEvent event) {
            HostConnectionsView.this.updateActiveConnectionState(event.getCategory());
        }
    };
    private ConnectionServiceListener connectionServiceListenerForActive = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            HostConnectionsView.this.updateActiveConnectionState(HostConnectionsView.this.connectionRegistry.findCategory(event.getConnectionCategoryId()));
        }
    };
    private static final Logger logger = Logger.getLogger(HostConnectionsView.class.getPackage().getName());

    public HostConnectionsView() {
        IConnectionCategory[] iConnectionCategoryArray = this.connectionRegistry.getConnectionCategories();
        int n = iConnectionCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionCategory category = iConnectionCategoryArray[n2];
            this.updateActiveConnectionState(category);
            ++n2;
        }
        this.defaultConnectionService.addDefaultConnectionServiceListener(this.defaultConnectionServiceListener);
        this.connectionService.addConnectionServiceListener(this.connectionServiceListenerForActive);
    }

    private void updateActiveConnectionState(final IConnectionCategory category) {
        ConnectionProfile connectionProfile;
        IConnectionState currentConnectionState = this.connectionService.getConnectionState(category.getId());
        final IConnectionState activeConnectionState = !(currentConnectionState instanceof DisconnectedState) ? currentConnectionState : ((connectionProfile = this.defaultConnectionService.getDefaultConnectionProfile(category)) != null ? this.connectionService.getConnectionState(connectionProfile) : null);
        this.categoryActiveConnectionState.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                HostConnectionsView.this.categoryActiveConnectionState.put((Object)category, (Object)activeConnectionState);
            }
        });
    }

    public void createPartControl(Composite parent) {
        logger.log(Level.INFO, "createPartControl");
        this.formToolkit = new FormToolkit(parent.getDisplay());
        this.createSashForm(parent);
    }

    private void createSashForm(final Composite parent) {
        this.createActions();
        LightweightSashForm sashForm = new LightweightSashForm(parent, this.formToolkit, 256);
        this.connectionsSection = this.formToolkit.createSection((Composite)sashForm, 256);
        this.connectionsSection.setText(Messages.ConnectionsViewPart_Connections_lbl);
        this.createConnectionsTree((Composite)this.connectionsSection);
        this.credentialsSection = this.formToolkit.createSection((Composite)sashForm, 256);
        this.credentialsSection.setText(Messages.ConnectionsViewPart_LoginDetails_lbl);
        this.createCredentialsTable((Composite)this.credentialsSection);
        sashForm.setWeights(new int[]{12, 7});
        this.createPopupMenu();
        this.createListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.connections_view");
        parent.addControlListener((ControlListener)new ControlAdapter((SashForm)sashForm){
            private final /* synthetic */ SashForm val$sashForm;
            {
                this.val$sashForm = sashForm;
            }

            public void controlResized(ControlEvent e) {
                int currentOrientation;
                int desiredOrientation = parent.getSize().y > parent.getSize().x ? 512 : 256;
                if (desiredOrientation != (currentOrientation = this.val$sashForm.getOrientation())) {
                    this.val$sashForm.setOrientation(desiredOrientation);
                    this.val$sashForm.getParent().layout(true, true);
                }
            }
        });
    }

    private void createCredentialsTable(Composite parent) {
        Composite sectionClient = this.formToolkit.createComposite(parent);
        ((Section)parent).setClient((Control)sectionClient);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        sectionClient.setLayout((Layout)gridLayout);
        Composite tableComposite = this.formToolkit.createComposite(sectionClient);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        tableComposite.setLayoutData((Object)data);
        Composite buttonsComposite = this.formToolkit.createComposite(sectionClient);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)gridLayout);
        buttonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        Table table = this.formToolkit.createTable(tableComposite, 2816);
        data = new GridData(1808);
        table.setLayoutData((Object)data);
        this.credentialsTableViewer = new TableViewer(table);
        this.credentialsContentManager = new CredentialsContentProvider();
        this.credentialsTableViewer.setContentProvider((IContentProvider)this.credentialsContentManager);
        this.credentialsLabelProvider = new CredentialsLabelProvider();
        this.credentialsTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)this.credentialsLabelProvider), (ILabelDecorator)new CredentialsLabelDecorator(), null));
        this.credentialsTableViewer.setInput((Object)this.connectionManager.getCredentialsManager());
        this.credentialsTableViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                if (element instanceof CredentialsConfiguration) {
                    return ((CredentialsConfiguration)element).getID().hashCode();
                }
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof CredentialsConfiguration && b instanceof CredentialsConfiguration) {
                    return ((CredentialsConfiguration)a).getID().equals(((CredentialsConfiguration)b).getID());
                }
                return a.equals(b);
            }
        });
        this.createCredentialsButtons(buttonsComposite);
    }

    private void createConnectionsTree(Composite parent) {
        Composite sectionClient = this.formToolkit.createComposite(parent);
        ((Section)parent).setClient((Control)sectionClient);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        sectionClient.setLayout((Layout)gridLayout);
        Composite treeComposite = this.formToolkit.createComposite(sectionClient);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginTop = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        treeComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, true, true);
        treeComposite.setLayoutData((Object)data);
        Composite buttonsComposite = this.formToolkit.createComposite(sectionClient);
        gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)gridLayout);
        buttonsComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.patternFilter = new ConnectionsViewFilter();
        this.patternFilter.setIncludeLeadingWildcard(true);
        FilteredTree filter = new FilteredTree(treeComposite, 68354, this.patternFilter, true);
        this.treeViewer = filter.getViewer();
        this.treeViewer.setComparer((IElementComparer)new ConnectionConfigurationElementComparer());
        Tree tree = this.treeViewer.getTree();
        data = new GridData(1808);
        tree.setLayoutData((Object)data);
        this.treeViewer.setContentProvider((IContentProvider)this.connectionsContentProvider);
        ConnectionsLabelProvider labelProvider = new ConnectionsLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionsDecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)labelProvider), new ConnectionsLabelDecorator(this.categoryActiveConnectionState, this.defaultConnectionService), null));
        this.treeViewer.setInput((Object)this.connectionManager);
        this.treeViewer.expandToLevel(2);
        this.treeViewer.setComparator(new ViewerComparator());
        this.createConnectionsButtons(buttonsComposite);
    }

    private void createCredentialsButtons(Composite aComposite) {
        GridData buttonData = GridDataFactory.fillDefaults().minSize(BUTTON_WIDTH, -1).grab(true, false).create();
        this.createCredentialsButton = new Button(aComposite, 8);
        this.createCredentialsButton.setText(Messages.ConnectionsViewPart_Add);
        this.createCredentialsButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        this.openCredentialsButton = new Button(aComposite, 8);
        this.openCredentialsButton.setText(Messages.ConnectionsViewPart_Edit_prompt);
        this.openCredentialsButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        this.deleteCredentialsButton = new Button(aComposite, 8);
        this.deleteCredentialsButton.setText(Messages.ConnectionsViewPart_Remove);
        this.deleteCredentialsButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        this.openCredentialsButton.setEnabled(false);
        this.deleteCredentialsButton.setEnabled(false);
        this.createCredentialsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().createCredentialsConfiguration();
            }
        });
        this.openCredentialsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostConnectionsView.this.openCredentialsAction.run();
            }
        });
        this.deleteCredentialsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HostConnectionsView.this.credentialsTableViewer.getSelection() instanceof StructuredSelection) {
                    CredentialsConfiguration credentialsConfiguration = (CredentialsConfiguration)((StructuredSelection)HostConnectionsView.this.credentialsTableViewer.getSelection()).getFirstElement();
                    HostConnectionsView.this.connectionManager.getCredentialsManager().remove(credentialsConfiguration.getID());
                }
            }
        });
    }

    private void createConnectionsButtons(Composite aComposite) {
        GridData buttonData = GridDataFactory.fillDefaults().minSize(BUTTON_WIDTH, -1).grab(true, false).create();
        this.createConnectionButton = this.createCreateConnectionButton(aComposite);
        this.createConnectionButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        this.openConnectionButton = new Button(aComposite, 8);
        this.openConnectionButton.setText(Messages.ConnectionsViewPart_Edit_prompt);
        this.openConnectionButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        this.deleteConnectionButton = new Button(aComposite, 8);
        this.deleteConnectionButton.setText(Messages.ConnectionsViewPart_Remove);
        this.deleteConnectionButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        Label separator = this.formToolkit.createSeparator(aComposite, 256);
        GridData separatorData = new GridData(4, 0, false, false);
        separator.setLayoutData((Object)separatorData);
        this.connectButton = new Button(aComposite, 8);
        this.connectButton.setText(Messages.ConnectionsViewPart_Connect);
        this.connectButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        this.disconnectButton = new Button(aComposite, 8);
        this.disconnectButton.setText(Messages.ConnectionsViewPart_Disconnect);
        this.disconnectButton.setLayoutData((Object)GridDataFactory.createFrom((GridData)buttonData).create());
        this.deleteConnectionButton.setEnabled(false);
        this.openConnectionButton.setEnabled(false);
        this.connectButton.setEnabled(false);
        this.disconnectButton.setEnabled(false);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostConnectionsView.this.doConnect();
            }
        });
        this.disconnectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HostConnectionsView.this.doDisconnect();
            }
        });
        this.openConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedObject = ((StructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).getFirstElement();
                if (selectedObject instanceof ConnectionProfile) {
                    ConnectionProfile aConnectionConfiguration = (ConnectionProfile)selectedObject;
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().editConnectionParameters(aConnectionConfiguration.getId());
                } else if (selectedObject instanceof ILocationConnectionProvider) {
                    HostConnectionsView.this.editProviderAction.run();
                }
            }
        });
        this.deleteConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                for (Object selectedObject : ((IStructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).toList()) {
                    if (selectedObject instanceof ConnectionProfile) {
                        ConnectionProfile aConnectionConfiguration = (ConnectionProfile)selectedObject;
                        String message = MessageFormat.format(Messages.ConnectionsViewPart_Removed_Connection_Success_Message, aConnectionConfiguration.getName());
                        IWritableConnectionProvider connectionProvider = (IWritableConnectionProvider)aConnectionConfiguration.getConnectionProvider();
                        connectionProvider.removeConfiguration(aConnectionConfiguration.getId());
                        ViewHelper.setDeferredStatusInformationMessage((String)message);
                        continue;
                    }
                    if (!(selectedObject instanceof IConnectionProvider)) continue;
                    IConnectionProvider connectionProvider = (IConnectionProvider)selectedObject;
                    HostConnectionsView.this.connectionProviderRegistry.removeConnectionProvider(connectionProvider);
                }
            }
        });
    }

    private void doConnect() {
        ConnectionProfile connectionProfile = this.getSelectedConnectionProfile();
        if (connectionProfile != null) {
            this.connectionService.connectAsync(connectionProfile.getId());
        }
    }

    private void doDisconnect() {
        ConnectionProfile connectionProfile = this.getSelectedConnectionProfile();
        if (connectionProfile != null) {
            if (ConnectionUtils.supportsMultipleConnections(connectionProfile.getConnectionDescriptor())) {
                this.multiConnectionPreDisconnect(connectionProfile);
            }
            this.connectionService.disconnectAsync(connectionProfile.getConnectionDescriptor().getCategory().getId());
        }
    }

    private void multiConnectionPreDisconnect(ConnectionProfile connectionProfile) {
        IConnectionState desirableState;
        String connectionCategoryId = connectionProfile.getConnectionDescriptor().getCategory().getId();
        IConnectionState state = this.connectionService.getConnectionState(connectionCategoryId);
        if (!state.getID().equals(connectionProfile.getId()) && (desirableState = this.connectionService.getConnectionState(connectionProfile)) instanceof ConnectedState) {
            IConnection connection = ((ConnectedState)desirableState).getConnection();
            this.connectionService.switchToAlreadyConnected(connection, connectionProfile);
        }
    }

    private ConnectionProfile getSelectedConnectionProfile() {
        if (this.selectedState.getValue() != null) {
            return ((IConnectionState)this.selectedState.getValue()).getConnectionProfile();
        }
        return null;
    }

    private boolean isFilteredConnectionType(IConnectionDescriptor descriptor) {
        return this.filteredRegistry.find(descriptor.getId()) == null;
    }

    private Button createCreateConnectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(Messages.ConnectionsViewPart_Add);
        final SelectionChangedListener listener = new SelectionChangedListener(button);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)listener);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<String> availableDescriptorIds = CollectionUtils.transform(listener.availableDescriptors, new Function<IConnectionDescriptor, String>(){

                    @Override
                    public String evaluate(IConnectionDescriptor v) {
                        return v.getId();
                    }
                });
                ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().createConnectionConfiguration(availableDescriptorIds.toArray(new String[0]));
            }
        });
        return button;
    }

    private void createListeners() {
        this.dbc = new DataBindingContext();
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.connectButton), (IObservableValue)this.selectedState, null, new UpdateValueStrategy().setConverter((IConverter)new Converter(IConnectionState.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && !(fromObject instanceof ConnectedState)) {
                    return true;
                }
                return false;
            }
        }));
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.disconnectButton), (IObservableValue)this.selectedState, null, new UpdateValueStrategy().setConverter((IConverter)new Converter(IConnectionState.class, Boolean.class){

            public Object convert(Object fromObject) {
                return fromObject instanceof ConnectedState;
            }
        }));
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.openConnectionButton), (IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.treeViewer), null, new UpdateValueStrategy().setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof ConnectionProfile) {
                    return true;
                }
                if (fromObject instanceof ILocationConnectionProvider && !(fromObject instanceof ExplorerConnectionProvider) && fromObject != HostConnectionsView.this.connectionProviderRegistry.getLocalConnectionProvider()) {
                    return true;
                }
                return false;
            }
        }));
        final IViewerObservableList observeMultiSelection = ViewersObservables.observeMultiSelection((Viewer)this.treeViewer);
        this.deleteEnablement = new ComputedValue(){

            protected Object calculate() {
                if (observeMultiSelection.isEmpty()) {
                    return false;
                }
                for (Object selectedObject : observeMultiSelection) {
                    if (HostConnectionsView.this.isDeletable(selectedObject)) continue;
                    return false;
                }
                return true;
            }
        };
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.deleteConnectionButton), (IObservableValue)this.deleteEnablement, null, new UpdateValueStrategy());
        this.connectionServiceListener = new ConnectionServiceListener(){

            public void event(final ConnectionServiceListener.ConnectionServiceEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionProfile connectionConfiguration = event.getConnectionProfile();
                        HostConnectionsView.this.treeViewer.refresh(HostConnectionsView.this.connectionsContentProvider.getParent(event.getConnectionProfile()));
                        HostConnectionsView.this.selectedState.setValue((Object)HostConnectionsView.this.connectionService.getConnectionState(connectionConfiguration));
                        HostConnectionsView.this.credentialsLabelProvider.refreshLabels();
                    }
                });
            }
        };
        this.connectionService.addConnectionServiceListener(this.connectionServiceListener);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                HostConnectionsView.this.selectedState.setValue((Object)this.getActiveConnectionState(selection));
            }

            private IConnectionState getActiveConnectionState(IStructuredSelection selection) {
                if (selection.size() == 1) {
                    Object firstElement = selection.getFirstElement();
                    if (firstElement instanceof ConnectionProfile) {
                        return HostConnectionsView.this.connectionService.getConnectionState((ConnectionProfile)firstElement);
                    }
                    if (firstElement instanceof ConnectionCategory) {
                        ConnectionCategory category = (ConnectionCategory)firstElement;
                        return (IConnectionState)HostConnectionsView.this.categoryActiveConnectionState.get((Object)category);
                    }
                }
                return null;
            }
        });
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.item.getData() instanceof ConnectionProfile) {
                    HostConnectionsView.this.openConnectionAction.run();
                }
            }
        });
        this.treeViewer.getTree().addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point point = new Point(e.x, e.y);
                TreeItem item = HostConnectionsView.this.treeViewer.getTree().getItem(point);
                if (item != null) {
                    Object itemUnderMouse = item.getData();
                    if (itemUnderMouse instanceof ConnectionProfile) {
                        ConnectionProfile connectionConfiguration = (ConnectionProfile)itemUnderMouse;
                        IConnectionState connectionState = HostConnectionsView.this.connectionService.getConnectionState(connectionConfiguration);
                        if (connectionState instanceof ExceptionState) {
                            String oldToolTipText = HostConnectionsView.this.treeViewer.getTree().getToolTipText();
                            String newToolTipText = ((ExceptionState)connectionState).getMessage();
                            if (!newToolTipText.equals(oldToolTipText)) {
                                HostConnectionsView.this.treeViewer.getTree().setToolTipText(newToolTipText);
                            }
                            return;
                        }
                        String oldToolTipText = HostConnectionsView.this.treeViewer.getTree().getToolTipText();
                        String newToolTipText = connectionConfiguration.getDescription();
                        if (!newToolTipText.equals(oldToolTipText)) {
                            HostConnectionsView.this.treeViewer.getTree().setToolTipText(newToolTipText);
                        }
                        return;
                    }
                    if (itemUnderMouse instanceof IConnectionProvider) {
                        IConnectionProvider connectionProvider = (IConnectionProvider)itemUnderMouse;
                        IStatus status = HostConnectionsView.this.connectionProviderRegistry.getConnectionProviderStatus(connectionProvider);
                        if (status.getSeverity() == 0) {
                            HostConnectionsView.this.treeViewer.getTree().setToolTipText("");
                        } else {
                            HostConnectionsView.this.treeViewer.getTree().setToolTipText(status.getMessage());
                        }
                        return;
                    }
                    HostConnectionsView.this.treeViewer.getTree().setToolTipText("");
                }
            }
        });
        this.credentialsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HostConnectionsView.this.refreshCredentialsButtonEnablement();
            }
        });
        this.credentialsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                HostConnectionsView.this.openCredentialsAction.run();
            }
        });
        this.connectionService.addConnectionServiceListener(this.connectionServiceListener);
        this.connectionManager.addListener(this.getConnectionManagerListener());
        this.connectionManager.getCredentialsManager().addCredentialsManagerListener(this.getCredentialsManagerListener());
        this.connectionProviderRegistry.addListener(this.getConnectionProviderRegistyListener());
    }

    private void refreshCredentialsButtonEnablement() {
        IStructuredSelection selection = (IStructuredSelection)this.credentialsTableViewer.getSelection();
        Object firstElement = selection.getFirstElement();
        this.openCredentialsButton.setEnabled(firstElement != null);
        this.deleteCredentialsButton.setEnabled(firstElement != null);
    }

    private CredentialsManagerListener getCredentialsManagerListener() {
        if (this.credentialsManagerListener == null) {
            this.credentialsManagerListener = new CredentialsManagerListener(){

                public void event(final CredentialsManagerListener.CredentialsManagerEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (event instanceof CredentialsManagerListener.CredentialAddedEvent) {
                                if (!HostConnectionsView.this.credentialsTableViewer.getTable().isDisposed()) {
                                    HostConnectionsView.this.credentialsTableViewer.add((Object)((CredentialsManagerListener.CredentialAddedEvent)event).getCredentialsConfiguration());
                                }
                            } else if (event instanceof CredentialsManagerListener.CredentialModifiedEvent) {
                                if (!HostConnectionsView.this.credentialsTableViewer.getTable().isDisposed()) {
                                    HostConnectionsView.this.credentialsTableViewer.refresh((Object)((CredentialsManagerListener.CredentialModifiedEvent)event).getReplacement());
                                }
                                if (!HostConnectionsView.this.treeViewer.getTree().isDisposed()) {
                                    HostConnectionsView.this.treeViewer.refresh(true);
                                }
                            } else if (event instanceof CredentialsManagerListener.CredentialRemovedEvent && !HostConnectionsView.this.credentialsTableViewer.getTable().isDisposed()) {
                                HostConnectionsView.this.credentialsTableViewer.remove((Object)((CredentialsManagerListener.CredentialRemovedEvent)event).getRemoved());
                            }
                        }
                    });
                }
            };
        }
        return this.credentialsManagerListener;
    }

    public void dispose() {
        super.dispose();
        this.connectionServiceListener.makeStale();
        this.connectionManagerListener.makeStale();
        if (this.decorationColor != null && !this.decorationColor.isDisposed()) {
            this.decorationColor.dispose();
        }
        this.defaultConnectionServiceListener.makeStale();
        this.connectionServiceListenerForActive.makeStale();
        this.dbc.dispose();
        this.deleteEnablement.dispose();
    }

    private IConnectionProviderRegistry.ConnectionProviderRegistryListener getConnectionProviderRegistyListener() {
        if (this.connectionProviderRegistryListener == null) {
            this.connectionProviderRegistryListener = new IConnectionProviderRegistry.ConnectionProviderRegistryListener(){

                public void event(final IConnectionProviderRegistry.ConnectionProviderRegistryEvent event) {
                    (Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!HostConnectionsView.this.treeViewer.getTree().isDisposed()) {
                                HostConnectionsView.this.treeViewer.getContentProvider().inputChanged((Viewer)HostConnectionsView.this.treeViewer, null, (Object)HostConnectionsView.this.connectionManager);
                                if (event instanceof IConnectionProviderRegistry.ConnectionProviderAddedEvent) {
                                    if (HostConnectionsView.this.showProvidersAction.isChecked()) {
                                        HostConnectionsView.this.treeViewer.refresh();
                                        HostConnectionsView.this.treeViewer.setExpandedState((Object)((IConnectionProviderRegistry.ConnectionProviderAddedEvent)event).getConnectionProvider(), true);
                                    }
                                } else if (event instanceof IConnectionProviderRegistry.ConnectionProviderRemovedEvent) {
                                    if (HostConnectionsView.this.showProvidersAction.isChecked()) {
                                        HostConnectionsView.this.treeViewer.refresh();
                                    }
                                } else if (event instanceof IConnectionProviderRegistry.ConnectionProviderUpdatedEvent && HostConnectionsView.this.showProvidersAction.isChecked()) {
                                    HostConnectionsView.this.treeViewer.refresh((Object)((IConnectionProviderRegistry.ConnectionProviderUpdatedEvent)event).getConnectionProvider());
                                }
                            }
                        }
                    });
                }
            };
        }
        return this.connectionProviderRegistryListener;
    }

    private ConnectionManagerListener getConnectionManagerListener() {
        if (this.connectionManagerListener == null) {
            this.connectionManagerListener = new ConnectionManagerListener(){

                public void event(ConnectionManagerListener.ConnectionManagerEvent event) {
                    (Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault()).asyncExec((Runnable)new UpdateRunnable(event));
                }
            };
        }
        return this.connectionManagerListener;
    }

    private boolean isDeletableConnectionConfiguration(Object element) {
        return element instanceof ConnectionProfile && ((ConnectionProfile)element).getConnectionProvider() instanceof IWritableConnectionProvider;
    }

    private boolean isDeletableProvider(Object element) {
        return element instanceof ILocationConnectionProvider && !(element instanceof ExplorerConnectionProvider) && element != this.connectionProviderRegistry.getLocalConnectionProvider();
    }

    private boolean isDeletable(Object element) {
        return this.isDeletableConnectionConfiguration(element) || this.isDeletableProvider(element);
    }

    private Action createExpandAllAction() {
        return new Action(Messages.ConnectionsViewPart_Expand_All){

            public ImageDescriptor getImageDescriptor() {
                return Activator.IMGD_EXPAND_ALL;
            }

            public void run() {
                HostConnectionsView.this.treeViewer.expandAll();
            }
        };
    }

    private Action createCollapseAllAction() {
        return new Action(Messages.ConnectionsViewPart_Collapse_All){

            public ImageDescriptor getImageDescriptor() {
                return Activator.IMGD_COLLAPSE_ALL;
            }

            public void run() {
                HostConnectionsView.this.treeViewer.collapseAll();
            }
        };
    }

    private Action autoConnectToDefaultsAction() {
        Action autoConnectAction = new Action(Messages.HostConnectionsView_autoConnect){

            public ImageDescriptor getImageDescriptor() {
                return ConnectionsImages.getImageDescriptor("IMGD_AUTO_CONNECT");
            }

            public void run() {
                InternalConnectionsPlugin.getDefault().setConnectAutomatically(this.isChecked());
            }
        };
        autoConnectAction.setChecked(InternalConnectionsPlugin.getDefault().isConnectAutomatically());
        return autoConnectAction;
    }

    private Action createLoadConnectionsAction() {
        return new Action(Messages.ConnectionsViewPart_Add_Connection_Source){

            public void run() {
                AddProviderDialog addProviderDialog = new AddProviderDialog(HostConnectionsView.this.treeViewer.getTree().getShell());
                addProviderDialog.open();
            }

            public ImageDescriptor getImageDescriptor() {
                return ConnectionsImages.getImageDescriptor("CONNECTION_PROVIDER_ADD");
            }

            public String getToolTipText() {
                return Messages.ConnectionsViewPart_Add_Connection_Tooltip;
            }
        };
    }

    private Action createShowProvidersAction() {
        return new ShowProvidersAction(this.connectionsContentProvider){

            @Override
            public void run() {
                super.run();
                HostConnectionsView.this.treeViewer.expandToLevel(2);
            }
        };
    }

    private Action createExportConnectionsAction() {
        return new Action(Messages.ConnectionsViewPart_Export_Connections){

            public void run() {
                ExportConnectionsDialog exportDialog = new ExportConnectionsDialog(HostConnectionsView.this.treeViewer.getTree().getShell(), HostConnectionsView.this.connectionManager);
                exportDialog.open();
            }

            public ImageDescriptor getImageDescriptor() {
                return ConnectionsImages.getImageDescriptor("CONNECTIONS_EXPORT");
            }

            public String getToolTipText() {
                return Messages.ConnectionsViewPart_Export_Connections;
            }
        };
    }

    private Action createEditProviderAction() {
        return new Action(Messages.ConnectionsViewPart_Edit_prompt){

            public void run() {
                AddProviderDialog addProviderDialog = new AddProviderDialog(HostConnectionsView.this.treeViewer.getTree().getShell());
                addProviderDialog.setConnectionProvider((ILocationConnectionProvider)((StructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).getFirstElement());
                addProviderDialog.open();
            }

            public String getToolTipText() {
                return Messages.ConnectionsViewPart_Open_Tooltip;
            }
        };
    }

    private Action createDeleteConnectionAction() {
        return new Action(Messages.ConnectionsViewPart_Remove){

            public void run() {
                ConnectionProfile aConnectionConfiguration = (ConnectionProfile)((StructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).getFirstElement();
                String message = MessageFormat.format(Messages.ConnectionsViewPart_Removed_Connection_Success_Message, aConnectionConfiguration.getName());
                IWritableConnectionProvider connectionProvider = (IWritableConnectionProvider)aConnectionConfiguration.getConnectionProvider();
                connectionProvider.removeConfiguration(aConnectionConfiguration.getId());
                ViewHelper.setDeferredStatusInformationMessage((String)message);
            }
        };
    }

    private Action createRemoveCredentialsAction() {
        return new Action(Messages.ConnectionsviewPart_Remove_credentials){

            public void run() {
                for (Object nextItem : ((IStructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).toList()) {
                    if (!(nextItem instanceof ConnectionProfile)) continue;
                    ConnectionProfile connectionConfiguration = (ConnectionProfile)nextItem;
                    HostConnectionsView.this.connectionManager.getConnectionCredentialsManager().associate(connectionConfiguration.getId(), null);
                }
            }
        };
    }

    private Action createOpenConnectionAction() {
        return new Action(Messages.ConnectionsViewPart_Edit_prompt){

            public void run() {
                Object firstElement = ((StructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).getFirstElement();
                if (firstElement instanceof ConnectionProfile) {
                    ConnectionProfile aConnectionConfiguration = (ConnectionProfile)firstElement;
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().editConnectionParameters(aConnectionConfiguration.getId());
                }
            }
        };
    }

    private Action createOpenCredentialsAction() {
        return new Action(Messages.ConnectionsViewPart_Edit_prompt){

            public void run() {
                Object firstElement = ((StructuredSelection)HostConnectionsView.this.credentialsTableViewer.getSelection()).getFirstElement();
                if (firstElement instanceof CredentialsConfiguration) {
                    CredentialsConfiguration credentialsConfiguration = (CredentialsConfiguration)firstElement;
                    ConnectionsPlugin.getDefault().getConnectionUserInterfaceService().editCredentialsConfiguration(credentialsConfiguration);
                }
            }
        };
    }

    private void createActions() {
        this.expandAllAction = this.createExpandAllAction();
        this.collapseAllAction = this.createCollapseAllAction();
        this.createConnectionToolbarAction = new AddConnectionAction();
        this.autoConnectToDefaultsAction = this.autoConnectToDefaultsAction();
        this.showProvidersAction = this.createShowProvidersAction();
        this.showProvidersAction.setChecked(false);
        this.addProvidersAction = this.createLoadConnectionsAction();
        this.exportConnectionsActions = this.createExportConnectionsAction();
        this.editProviderAction = this.createEditProviderAction();
        this.removeProviderAction = new RemoveProviderAction();
        this.refreshProviderAction = new RefreshProvidersAction();
        this.openConnectionAction = this.createOpenConnectionAction();
        this.deleteConnectionAction = this.createDeleteConnectionAction();
        this.openCredentialsAction = this.createOpenCredentialsAction();
        this.removeCredentialsAction = this.createRemoveCredentialsAction();
        this.setCredentialsMenuManager = new MenuManager(Messages.ConnectionsViewPart_Set_Logon_Details);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add((IAction)this.expandAllAction);
        actionBars.getToolBarManager().add((IAction)this.collapseAllAction);
        actionBars.getToolBarManager().add((IContributionItem)new Separator());
        actionBars.getToolBarManager().add((IAction)this.createConnectionToolbarAction);
        actionBars.getToolBarManager().add((IContributionItem)new Separator());
        actionBars.getToolBarManager().add((IAction)this.autoConnectToDefaultsAction);
        actionBars.getToolBarManager().add((IContributionItem)new Separator());
        actionBars.getToolBarManager().add((IAction)this.showProvidersAction);
        actionBars.getToolBarManager().add((IAction)this.addProvidersAction);
        actionBars.getToolBarManager().add((IAction)this.exportConnectionsActions);
    }

    private SelectionAdapter getCreateConnectionMenuItemSelectionListener() {
        if (this.connectionMenuItemSelectionListener == null) {
            this.connectionMenuItemSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menuItem = (MenuItem)e.getSource();
                    IConnectionDescriptor connectionDescriptor = (IConnectionDescriptor)menuItem.getData();
                    HostConnectionsView.this.connectionUserInterfaceService.createConnectionConfiguration(connectionDescriptor.getId());
                }
            };
        }
        return this.connectionMenuItemSelectionListener;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = HostConnectionsView.this.treeViewer.getSelection();
                if (selection instanceof StructuredSelection && ((StructuredSelection)selection).size() == 1) {
                    Object selectedObject = ((StructuredSelection)selection).getFirstElement();
                    if (selectedObject instanceof ConnectionProfile) {
                        ConnectionProfile selectedConfiguration = (ConnectionProfile)selectedObject;
                        manager.add((IAction)new ToggleConnectAction());
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)HostConnectionsView.this.openConnectionAction);
                        HostConnectionsView.this.deleteConnectionAction.setEnabled(HostConnectionsView.this.isDeletable(selectedObject));
                        manager.add((IAction)HostConnectionsView.this.deleteConnectionAction);
                        manager.add((IContributionItem)new Separator());
                        manager.add((IAction)new ToggleDefaultAction(selectedConfiguration));
                    } else if (selectedObject instanceof IConnectionDescriptor) {
                        IConnectionDescriptor connDesc = (IConnectionDescriptor)selectedObject;
                        if (!connDesc.isTransient()) {
                            CreateConnectionAction createConnectionAction = new CreateConnectionAction(connDesc);
                            manager.add((IAction)createConnectionAction);
                        }
                    } else if (selectedObject instanceof IConnectionCategory) {
                        manager.add((IAction)new ToggleConnectAction());
                        manager.add((IContributionItem)new Separator());
                        IConnectionCategory connectionCategory = (IConnectionCategory)selectedObject;
                        IConnectionDescriptor[] iConnectionDescriptorArray = connectionCategory.getConnections();
                        int n = iConnectionDescriptorArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConnectionDescriptor connectionDescriptor = iConnectionDescriptorArray[n2];
                            if (!connectionDescriptor.isTransient() && !HostConnectionsView.this.isFilteredConnectionType(connectionDescriptor)) {
                                manager.add((IAction)new CreateConnectionAction(connectionDescriptor));
                            }
                            ++n2;
                        }
                    } else if (selectedObject instanceof IConnectionProvider && selectedObject != HostConnectionsView.this.connectionProviderRegistry.getLocalConnectionProvider()) {
                        if (selectedObject instanceof ILocationConnectionProvider) {
                            if (!(selectedObject instanceof ExplorerConnectionProvider)) {
                                manager.add((IAction)HostConnectionsView.this.editProviderAction);
                            }
                            HostConnectionsView.this.removeProviderAction.setEnabled(HostConnectionsView.this.isDeletable(selectedObject));
                            manager.add((IAction)HostConnectionsView.this.removeProviderAction);
                            manager.add((IContributionItem)new Separator());
                        }
                        manager.add((IAction)HostConnectionsView.this.refreshProviderAction);
                    }
                }
                if (selection instanceof StructuredSelection) {
                    ArrayList<ConnectionProfile> configurations = new ArrayList<ConnectionProfile>();
                    boolean haveCredentialsToRemove = false;
                    boolean isAbleToAlterCredentials = true;
                    for (Object selectedObject : ((StructuredSelection)selection).toList()) {
                        if (selectedObject instanceof ConnectionProfile) {
                            ConnectionProfile connectionConfiguration = (ConnectionProfile)selectedObject;
                            IConnectionState connectionState = HostConnectionsView.this.connectionService.getConnectionState(connectionConfiguration);
                            if (connectionState instanceof ConnectedState || connectionState instanceof ConnectingState) {
                                isAbleToAlterCredentials = false;
                            }
                            haveCredentialsToRemove = haveCredentialsToRemove || connectionConfiguration.getCredentials() != null;
                            configurations.add(connectionConfiguration);
                            continue;
                        }
                        return;
                    }
                    if (configurations.size() > 0) {
                        manager.add((IContributionItem)new Separator());
                        manager.add((IContributionItem)HostConnectionsView.this.setCredentialsMenuManager);
                        HostConnectionsView.this.buildCredentialsPopup((IMenuManager)HostConnectionsView.this.setCredentialsMenuManager, isAbleToAlterCredentials);
                        if (haveCredentialsToRemove) {
                            manager.add((IAction)HostConnectionsView.this.removeCredentialsAction);
                            HostConnectionsView.this.removeCredentialsAction.setEnabled(isAbleToAlterCredentials);
                        }
                    }
                }
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(popupMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void buildCredentialsPopup(IMenuManager aMenuManager, final boolean enabled) {
        aMenuManager.removeAll();
        Collection<CredentialsConfiguration> allCredentials = this.connectionManager.getCredentialsManager().getAllCredentials();
        if (allCredentials.size() > 0) {
            Iterator<CredentialsConfiguration> iterator = allCredentials.iterator();
            while (iterator.hasNext()) {
                CredentialsConfiguration credentials;
                final CredentialsConfiguration finalCredentials = credentials = iterator.next();
                aMenuManager.add((IAction)new Action(credentials.getName()){

                    public void run() {
                        ArrayList<ConnectionProfile> configurations = new ArrayList<ConnectionProfile>();
                        for (Object next : ((IStructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).toList()) {
                            if (!(next instanceof ConnectionProfile)) continue;
                            configurations.add((ConnectionProfile)next);
                        }
                        if (configurations.size() > 0) {
                            UpdateCredentialsOperation updateCredentialsOperation = new UpdateCredentialsOperation(configurations, finalCredentials, HostConnectionsView.this.connectionManager.getConnectionCredentialsManager());
                            try {
                                OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)updateCredentialsOperation, (IProgressMonitor)new NullProgressMonitor(), null);
                            }
                            catch (ExecutionException e) {
                                logger.log(Level.SEVERE, "buildCredentialsPopup", e);
                            }
                        }
                    }

                    public boolean isEnabled() {
                        return enabled;
                    }
                });
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.undoActionHandler = new UndoActionHandler((IWorkbenchPartSite)site, (IUndoContext)new UndoContext());
        this.undoActionHandler.setId(ActionFactory.UNDO.getId());
        this.undoActionHandler.setActionDefinitionId("org.eclipse.ui.edit.undo");
        site.getActionBars().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoActionHandler);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    private class AddConnectionAction
    extends Action {
        private AddConnectionMenuCreator menuCreator;

        public AddConnectionAction() {
            super(Messages.ConnectionsViewPart_CreateConnection, 4);
            this.menuCreator = new AddConnectionMenuCreator();
            this.setMenuCreator(this.menuCreator);
        }

        public ImageDescriptor getImageDescriptor() {
            return ConnectionsImages.getImageDescriptor("NEW_CON");
        }

        public void runWithEvent(Event e) {
            ToolBar control = ((ToolItem)e.widget).getParent();
            Menu menu = this.menuCreator.getMenu((Control)control);
            control.setMenu(menu);
            menu.setVisible(true);
            while (!menu.isDisposed() && menu.isVisible()) {
                if (control.getDisplay().readAndDispatch()) continue;
                control.getDisplay().sleep();
            }
            menu.dispose();
        }

        private final class AddConnectionMenuCreator
        implements IMenuCreator {
            private Menu menu;

            private AddConnectionMenuCreator() {
            }

            public void dispose() {
                if (this.menu != null && !this.menu.isDisposed()) {
                    this.menu.dispose();
                }
            }

            public Menu getMenu(Control parent) {
                this.dispose();
                this.menu = new Menu(parent);
                TreeSet<IConnectionDescriptor> descriptors = new TreeSet<IConnectionDescriptor>(new Comparator<IConnectionDescriptor>(){

                    @Override
                    public int compare(IConnectionDescriptor object1, IConnectionDescriptor object2) {
                        return object1.getName().compareTo(object2.getName());
                    }
                });
                descriptors.addAll(Arrays.asList(HostConnectionsView.this.connectionRegistry.getConnections()));
                for (IConnectionDescriptor aConnectionDescriptor : descriptors) {
                    if (aConnectionDescriptor.isTransient() || HostConnectionsView.this.isFilteredConnectionType(aConnectionDescriptor)) continue;
                    MenuItem menuItem = new MenuItem(this.menu, 0);
                    menuItem.setText(MessageFormat.format(Messages.ConnectionsViewPart_New_prompt_with_short_name, aConnectionDescriptor.getName()));
                    menuItem.setData((Object)aConnectionDescriptor);
                    menuItem.addSelectionListener((SelectionListener)HostConnectionsView.this.getCreateConnectionMenuItemSelectionListener());
                    menuItem.setImage(ConnectionsImages.getCreateConnectionImage(aConnectionDescriptor.getCategory()));
                }
                return this.menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        }
    }

    private class ConnectionsDecoratingStyledCellLabelProvider
    extends DecoratingStyledCellLabelProvider
    implements ILabelProvider {
        public ConnectionsDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
            super(labelProvider, decorator, decorationContext);
        }

        public String getText(Object element) {
            return this.getStyledText(element).getString();
        }
    }

    private class RefreshProvidersAction
    extends Action {
        public RefreshProvidersAction() {
            super(Messages.ConnectionsViewPart_Refresh);
        }

        public String getText() {
            return Messages.ConnectionsViewPart_Refresh;
        }

        public void run() {
            final IConnectionProvider connectionProvider = (IConnectionProvider)((StructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).getFirstElement();
            RefreshConnectionProviderJob refreshJob = new RefreshConnectionProviderJob(connectionProvider){

                @Override
                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = super.run(monitor);
                    HostConnectionsView.this.treeViewer.getTree().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            HostConnectionsView.this.treeViewer.getContentProvider().inputChanged((Viewer)HostConnectionsView.this.treeViewer, null, (Object)HostConnectionsView.this.connectionManager);
                            HostConnectionsView.this.treeViewer.refresh((Object)connectionProvider);
                            HostConnectionsView.this.treeViewer.expandToLevel((Object)connectionProvider, 1);
                        }
                    });
                    return status;
                }
            };
            refreshJob.schedule();
        }

        public ImageDescriptor getImageDescriptor() {
            return Activator.IMGD_REFRESH;
        }

        public int getAccelerator() {
            return 0x100000E;
        }
    }

    private class RemoveProviderAction
    extends Action {
        public RemoveProviderAction() {
            super(Messages.ConnectionsViewPart_Remove);
        }

        public void run() {
            HostConnectionsView.this.connectionProviderRegistry.removeConnectionProvider((ILocationConnectionProvider)((StructuredSelection)HostConnectionsView.this.treeViewer.getSelection()).getFirstElement());
        }

        public String getToolTipText() {
            return Messages.ConnectionsViewPart_Remove_Tooltip;
        }
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private final Button button;
        private IConnectionProvider provider = this.getConnectionProvider((ITreeSelection)TreeSelection.EMPTY);
        private IConnectionDescriptor descriptor;
        private IConnectionCategory category;
        private List<IConnectionDescriptor> availableDescriptors = new ArrayList<IConnectionDescriptor>();

        public SelectionChangedListener(Button button) {
            this.button = button;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelection() instanceof ITreeSelection) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                if (selection.size() == 1) {
                    Object selected = selection.getFirstElement();
                    if (selected instanceof ConnectionProfile) {
                        this.descriptor = ((ConnectionProfile)selected).getConnectionDescriptor();
                        this.category = this.descriptor.getCategory();
                        this.provider = this.getConnectionProvider(selection);
                    } else if (selected instanceof IConnectionDescriptor) {
                        this.descriptor = (IConnectionDescriptor)selected;
                        this.category = this.descriptor.getCategory();
                        this.provider = this.getConnectionProvider(selection);
                    } else if (selected instanceof ConnectionsContentProvider.ConnectionProviderDescriptorNode) {
                        this.descriptor = ((ConnectionsContentProvider.ConnectionProviderDescriptorNode)selected).getConnectionDescriptor();
                        this.category = this.descriptor.getCategory();
                        this.provider = this.getConnectionProvider(selection);
                    } else if (selection instanceof IConnectionCategory) {
                        this.category = (IConnectionCategory)selection;
                        this.descriptor = null;
                        this.provider = this.getConnectionProvider(selection);
                    } else {
                        this.provider = this.getConnectionProvider(selection);
                        this.descriptor = null;
                        this.category = null;
                    }
                } else {
                    this.provider = this.getConnectionProvider((ITreeSelection)TreeSelection.EMPTY);
                    this.descriptor = null;
                    this.category = null;
                }
            }
            this.updateDescriptors();
            this.button.setEnabled(!this.availableDescriptors.isEmpty());
        }

        private IConnectionProvider getConnectionProvider(ITreeSelection selection) {
            if (HostConnectionsView.this.showProvidersAction.isChecked()) {
                if (selection.isEmpty()) {
                    return null;
                }
                return (IConnectionProvider)selection.getPaths()[0].getFirstSegment();
            }
            return HostConnectionsView.this.connectionProviderRegistry.getLocalConnectionProvider();
        }

        private void updateDescriptors() {
            this.availableDescriptors.clear();
            if (this.provider instanceof IWritableConnectionProvider) {
                if (this.descriptor != null) {
                    if (!this.filterDescriptor(this.descriptor)) {
                        this.availableDescriptors.add(this.descriptor);
                    }
                } else {
                    IConnectionDescriptor[] iConnectionDescriptorArray = HostConnectionsView.this.connectionRegistry.getConnections();
                    int n = iConnectionDescriptorArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConnectionDescriptor descriptor = iConnectionDescriptorArray[n2];
                        if (!this.filterDescriptor(descriptor)) {
                            this.availableDescriptors.add(descriptor);
                        }
                        ++n2;
                    }
                }
            }
        }

        private boolean filterDescriptor(IConnectionDescriptor descriptor) {
            return descriptor.isTransient() || this.category != null && this.category != descriptor.getCategory() || HostConnectionsView.this.isFilteredConnectionType(descriptor);
        }
    }

    private class ToggleConnectAction
    extends Action {
        private IConnectionState connectionState;
        private boolean isConnected;

        public ToggleConnectAction() {
            this.connectionState = (IConnectionState)HostConnectionsView.this.selectedState.getValue();
            this.isConnected = this.connectionState instanceof ConnectedState;
            this.setText(this.isConnected ? Messages.ConnectionsViewPart_Disconnect : Messages.ConnectionsViewPart_Connect);
            this.setImageDescriptor(this.isConnected ? ConnectionsImages.getImageDescriptor("STOP_CONNECTION") : ConnectionsImages.getImageDescriptor("ACTIVE_CONNECTION"));
        }

        public boolean isEnabled() {
            return this.connectionState != null;
        }

        public void run() {
            if (this.isConnected) {
                HostConnectionsView.this.doDisconnect();
            } else {
                HostConnectionsView.this.doConnect();
            }
        }
    }

    private class ToggleDefaultAction
    extends Action {
        private ConnectionProfile connectionProfile;
        private boolean isDefault;

        public ToggleDefaultAction(ConnectionProfile connectionProfile) {
            this.connectionProfile = connectionProfile;
            this.isDefault = HostConnectionsView.this.defaultConnectionService.isDefault(connectionProfile);
            this.setText(this.isDefault ? Messages.HostConnectionsView_RemoveDefaultConnection : Messages.HostConnectionsView_SetDefaultConnection);
        }

        public void run() {
            IConnectionCategory category = this.connectionProfile.getConnectionDescriptor().getCategory();
            if (this.isDefault) {
                HostConnectionsView.this.defaultConnectionService.setDefaultConnectionProfile(category, null);
            } else {
                HostConnectionsView.this.defaultConnectionService.setDefaultConnectionProfile(category, this.connectionProfile);
            }
        }
    }

    private class UpdateRunnable
    implements Runnable {
        private final ConnectionManagerListener.ConnectionManagerEvent event;

        public UpdateRunnable(ConnectionManagerListener.ConnectionManagerEvent event) {
            this.event = event;
        }

        @Override
        public void run() {
            if (this.event instanceof ConnectionManagerListener.ConnectionProfileUpdatedEvent) {
                HostConnectionsView.this.treeViewer.getContentProvider().inputChanged((Viewer)HostConnectionsView.this.treeViewer, null, (Object)HostConnectionsView.this.connectionManager);
                HostConnectionsView.this.treeViewer.refresh((Object)((ConnectionManagerListener.ConnectionProfileUpdatedEvent)this.event).getConnectionProfile(), true);
            } else if (this.event instanceof ConnectionManagerListener.ConnectionProfileAddedEvent) {
                HostConnectionsView.this.treeViewer.getContentProvider().inputChanged((Viewer)HostConnectionsView.this.treeViewer, null, (Object)HostConnectionsView.this.connectionManager);
                ConnectionProfile addedConfiguration = ((ConnectionManagerListener.ConnectionProfileAddedEvent)this.event).getConnectionProfile();
                IConnectionDescriptor connectionDescriptor = addedConfiguration.getConnectionDescriptor();
                IConnectionCategory connectionCategory = ConnectionRegistry.getConnectionRegistry().getConnectionCategory(connectionDescriptor.getCategory().getId());
                if (HostConnectionsView.this.showProvidersAction.isChecked()) {
                    HostConnectionsView.this.treeViewer.refresh((Object)addedConfiguration.getConnectionProvider(), true);
                    HostConnectionsView.this.treeViewer.expandToLevel((Object)addedConfiguration.getConnectionProvider(), 1);
                    HostConnectionsView.this.treeViewer.expandToLevel((Object)HostConnectionsView.this.connectionsContentProvider.getConnectionProviderDescriptorNode(addedConfiguration.getConnectionProvider(), connectionDescriptor), 1);
                } else if (connectionCategory.getConnections().length == 1) {
                    HostConnectionsView.this.treeViewer.refresh((Object)connectionCategory, true);
                    HostConnectionsView.this.treeViewer.expandToLevel((Object)connectionCategory, 1);
                } else {
                    HostConnectionsView.this.treeViewer.refresh((Object)connectionDescriptor, true);
                    HostConnectionsView.this.treeViewer.expandToLevel((Object)connectionDescriptor, 1);
                    HostConnectionsView.this.treeViewer.refresh((Object)connectionCategory, true);
                }
                HostConnectionsView.this.treeViewer.reveal((Object)addedConfiguration);
                HostConnectionsView.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)addedConfiguration));
            } else if (this.event instanceof ConnectionManagerListener.ConnectionProfileRemovedEvent) {
                HostConnectionsView.this.treeViewer.getContentProvider().inputChanged((Viewer)HostConnectionsView.this.treeViewer, null, (Object)HostConnectionsView.this.connectionManager);
                ConnectionManagerListener.ConnectionProfileRemovedEvent configurationRemovedEvent = (ConnectionManagerListener.ConnectionProfileRemovedEvent)this.event;
                ConnectionProfile removedConfiguration = configurationRemovedEvent.getConnectionProfile();
                HostConnectionsView.this.treeViewer.remove((Object)removedConfiguration);
                IConnectionDescriptor connectionDescriptor = removedConfiguration.getConnectionDescriptor();
                IConnectionCategory connectionCategory = ConnectionRegistry.getConnectionRegistry().getConnectionCategory(connectionDescriptor.getCategory().getId());
                if (HostConnectionsView.this.showProvidersAction.isChecked()) {
                    HostConnectionsView.this.treeViewer.refresh((Object)removedConfiguration.getConnectionProvider(), true);
                } else if (connectionCategory.getConnections().length == 1) {
                    HostConnectionsView.this.treeViewer.refresh((Object)connectionCategory, true);
                } else {
                    HostConnectionsView.this.treeViewer.refresh((Object)connectionDescriptor, true);
                    HostConnectionsView.this.treeViewer.refresh((Object)connectionCategory, true);
                }
            }
        }
    }
}

