/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.Messages;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;

public class FilterExpression {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String SPACE = " ";
    private Object value;
    private Operator operator = Operator.EQ;
    private FilterAttribute attribute;
    private String displayName;

    public String getDisplayString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.displayName);
        if (this.operator != null && this.value != null) {
            buffer.append(SPACE);
            buffer.append(this.getOperatorDisplayName());
            buffer.append(SPACE);
            buffer.append(this.getValueDisplayName());
        }
        return buffer.toString();
    }

    protected String getValueDisplayName() {
        return this.value.toString();
    }

    public void setValue(Object aValue) {
        this.value = aValue;
    }

    public Object getValue() {
        return this.value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator anOperator) {
        this.operator = anOperator;
    }

    public String getOperatorDisplayName() {
        return this.operator.getDisplayName();
    }

    public IRestrictionCriteria getRestrictionCriteria() {
        return new RestrictionCriteria(this.attribute.getAPIName(), this.operator, this.getValueXMLString());
    }

    protected String getValueXMLString() {
        return this.value.toString();
    }

    public void setAttribute(FilterAttribute anAttribute) {
        this.attribute = anAttribute;
    }

    public void setPropertyName(String aDisplayName) {
        this.displayName = aDisplayName;
    }

    public static enum Operator {
        EQ,
        NE,
        LT,
        GT,
        GE,
        LE;


        public String getDisplayName() {
            switch (this) {
                case EQ: {
                    return Messages.getString("FilterExpression.FilterDisplayNameIs");
                }
                case NE: {
                    return Messages.getString("FilterExpression.FilterDisplayNameIsNot");
                }
                case LT: {
                    return Messages.getString("FilterExpression.FilterDisplayNameIsLessThan");
                }
                case GT: {
                    return Messages.getString("FilterExpression.FilterDisplayNameIsGreaterThan");
                }
                case LE: {
                    return Messages.getString("FilterExpression.FilterDisplayNameIsLessThanOrEqualTo");
                }
                case GE: {
                    return Messages.getString("FilterExpression.FilterDisplayNameIsGreaterThanOrEqualTo");
                }
            }
            return null;
        }

        public String getTimeDisplayName() {
            switch (this) {
                case EQ: {
                    return Messages.getString("FilterExpression.FilterTimeDisplayNameIs");
                }
                case NE: {
                    return Messages.getString("FilterExpression.FilterTimeDisplayNameIsNot");
                }
                case LT: {
                    return Messages.getString("FilterExpression.FilterTimeDisplayNameIsBefore");
                }
                case GT: {
                    return Messages.getString("FilterExpression.FilterTimeDisplayNameIsAfter");
                }
                case LE: {
                    return Messages.getString("FilterExpression.FilterTimeDisplayNameIsAtOrBefore");
                }
                case GE: {
                    return Messages.getString("FilterExpression.FilterTimeDisplayNameIsAtOrAfter");
                }
            }
            return null;
        }

        public String getIconImageName() {
            switch (this) {
                case EQ: {
                    return "equal.gif";
                }
                case NE: {
                    return "notequal.gif";
                }
                case LT: {
                    return "lessThan_pal.gif";
                }
                case GT: {
                    return "greaterThan_pal.gif";
                }
                case LE: {
                    return "lessEqual_pal.gif";
                }
                case GE: {
                    return "greaterEqual_pal.gif";
                }
            }
            return null;
        }
    }
}

