/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.runtime.ICMListFactory;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.RestrictionElementList;

public abstract class CMListFactory
implements ICMListFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ObjectCriteria objectCriteria;
    protected LocationCriteria locationCriteria;
    protected RestrictionCriteriaList restrictionCriteriaList;
    protected JournalCriteria journalCriteria;

    public CMListFactory(ObjectCriteria anObjectCriteria) {
        this.objectCriteria = anObjectCriteria;
        this.locationCriteria = LocationCriteria.newRepositoryLocationCriteria();
    }

    public CMListFactory(LocationCriteria aLocationCriteria, ObjectCriteria anObjectCriteria) {
        this.locationCriteria = aLocationCriteria;
        this.objectCriteria = anObjectCriteria;
    }

    public CMListFactory(LocationCriteria aLocationCriteria, JournalCriteria aJournalCriteria) {
        this.locationCriteria = aLocationCriteria;
        this.journalCriteria = aJournalCriteria;
    }

    @Override
    public void addUniqueRestrictionField(String fieldName, FilterExpression.Operator operator, String value) {
        RestrictionElementList restrictionElementList;
        if (this.restrictionCriteriaList == null) {
            this.restrictionCriteriaList = new RestrictionCriteriaList();
        }
        if ((restrictionElementList = this.restrictionCriteriaList.getFirstElementList()) == null) {
            restrictionElementList = new RestrictionElementList();
        }
        restrictionElementList.addUnique(new RestrictionCriteria(fieldName, operator, value));
    }

    @Override
    public void addRestrictionField(String fieldName, FilterExpression.Operator operator, String value) {
        RestrictionElementList restrictionElementList;
        if (this.restrictionCriteriaList == null) {
            this.restrictionCriteriaList = new RestrictionCriteriaList();
        }
        if ((restrictionElementList = this.restrictionCriteriaList.getFirstElementList()) == null) {
            restrictionElementList = new RestrictionElementList();
        }
        restrictionElementList.add(new RestrictionCriteria(fieldName, operator, value));
    }

    @Override
    public void addRestrictionCriteria(IRestrictionCriteria restrictionCriteria) {
        RestrictionElementList restrictionElementList;
        if (this.restrictionCriteriaList == null) {
            this.restrictionCriteriaList = new RestrictionCriteriaList();
        }
        if ((restrictionElementList = this.restrictionCriteriaList.getFirstElementList()) == null) {
            restrictionElementList = new RestrictionElementList();
        }
        restrictionElementList.addUnique(restrictionCriteria);
    }

    @Override
    public ObjectCriteria getObjectCriteria() {
        return this.objectCriteria;
    }

    @Override
    public LocationCriteria getLocationCriteria() {
        return this.locationCriteria;
    }

    @Override
    public void setObjectName(String objectName) {
        this.objectCriteria.setObjectName(objectName);
    }

    @Override
    public void setObjectType(String objectType) {
        this.objectCriteria.setObjectType(objectType);
    }

    @Override
    public void setObjectGroup(String objectGroup) {
        this.objectCriteria.setObjectGroup(objectGroup);
    }

    @Override
    public void setJournalObjectName(String objectName) {
        this.journalCriteria.setObjectName(objectName);
    }

    @Override
    public void setJournalObjectType(String objectType) {
        this.journalCriteria.setObjectType(objectType);
    }

    @Override
    public void setJournalObjectGroup(String objectGroup) {
        this.journalCriteria.setObjectGroup(objectGroup);
    }

    public JournalCriteria getJournalCriteria() {
        return this.journalCriteria;
    }

    @Override
    public void setRestrictionCriteriaList(RestrictionCriteriaList aRestrictionCriteriaList) {
        this.restrictionCriteriaList = aRestrictionCriteriaList;
    }

    public RestrictionCriteriaList getRestrictionCriteriaList() {
        return this.restrictionCriteriaList;
    }
}

