/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.MessageResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JournalMessageResponse
extends MessageResponse {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public Map<String, String> beforeImage;
    public Map<String, String> afterImage;

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (this.status == 1) {
            if ("BEFOREIMAGE".equals(name) && this.beforeImage == null) {
                this.beforeImage = new HashMap<String, String>();
            } else if ("AFTERIMAGE".equals(name) && this.afterImage == null) {
                this.afterImage = new HashMap<String, String>();
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (this.status == 1) {
            try {
                this.tempVal = URLDecoder.decode(this.tempVal, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.setException("Error decoding " + this.tempVal + " for " + name, e);
            }
            if (this.beforeImage != null && this.afterImage == null) {
                this.beforeImage.put(name, this.tempVal.trim());
            } else if (this.afterImage != null) {
                this.afterImage.put(name, this.tempVal.trim());
            }
        }
    }
}

