/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.runtime.Messages;
import com.ibm.cics.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MessageResponse
extends DefaultHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static List<String> SCAFFOLD_TAGS = new ArrayList<String>();
    public StringBuffer rawMessageBuffer = new StringBuffer();
    private int depth = 0;
    public String integrityToken;
    public int returnCode;
    public String reasonCode;
    public int taskNumber;
    private boolean returnCodeAlreadyProcessed = false;
    private boolean reasonCodeAlreadyProcessed = false;
    private Object changeTime;
    private Object createTime;
    protected String tempVal;
    protected StringBuffer buffer = new StringBuffer();
    protected int status = 0;
    protected Exception exception;
    protected String errorDescription;
    private boolean type;
    private List<ErrorObject> fErrorObjects = new ArrayList<ErrorObject>();
    public static final String limitExceededCode = "00B9";
    public static final int INITIAL = 0;
    public static final int STARTED = 1;
    public static final int COMPLETE = 2;
    public static final int ERROR = 3;
    public static final int ERROR_OBJECT = 4;
    public static final int ERROR_MESSAGE = 5;
    private static final int RETURN_CODE_OK = 0;
    protected static final String OUTPUTDATA = "OUTPUTDATA";
    protected static final String TYPE = "TYPE";
    protected static final String ERRORELEMENT = "ERRORELEMENT";
    protected static final String TARGET = "TARGET";
    protected static final String MSGELEMENT = "MSGELEMENT";
    protected static final String MESSAGES = "MESSAGES";

    static {
        SCAFFOLD_TAGS.add("SOAP-ENV:Envelope");
        SCAFFOLD_TAGS.add("SOAP-ENV:Body");
        SCAFFOLD_TAGS.add("CCV120.1");
        SCAFFOLD_TAGS.add("CCV210");
        SCAFFOLD_TAGS.add("INQUIRE");
    }

    public List<ErrorObject> getErrorObjects() {
        return this.fErrorObjects;
    }

    protected void setException(String errorMessage, Exception e) {
        this.exception = e;
        this.errorDescription = errorMessage;
        this.status = 3;
    }

    private void appendSpaces() {
        int i = 1;
        while (i <= this.depth) {
            this.rawMessageBuffer.append("  ");
            ++i;
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (!SCAFFOLD_TAGS.contains(name)) {
            ++this.depth;
        }
        this.rawMessageBuffer.append(CMUtilities.LINE_SEPARATOR);
        this.appendSpaces();
        this.rawMessageBuffer.append("<" + name + ">");
        if (OUTPUTDATA.equalsIgnoreCase(name)) {
            this.status = 1;
        }
        this.type = TYPE.equals(name);
        if (ERRORELEMENT.equals(name)) {
            this.status = 4;
        } else if (this.status == 4 && TARGET.equals(name)) {
            this.fErrorObjects.add(new ErrorObject());
        } else if (this.status == 4 && MSGELEMENT.equals(name)) {
            this.status = 5;
            this.getCurrentErrorObject().addErrorMessage(new ErrorMessage());
        } else if (this.status == 5 && MSGELEMENT.equals(name)) {
            this.getCurrentErrorObject().addErrorMessage(new ErrorMessage());
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.status != 0) {
            this.tempVal = this.buffer.toString();
            this.buffer = new StringBuffer();
            if (this.status == 1) {
                if ("INTEGRITYTOKEN".equals(name)) {
                    this.integrityToken = this.tempVal;
                } else if ("RETURNCODE".equals(name)) {
                    if (!this.returnCodeAlreadyProcessed) {
                        this.returnCode = Integer.parseInt(this.tempVal);
                        this.returnCodeAlreadyProcessed = true;
                    }
                } else if ("REASONCODE".equals(name)) {
                    if (!this.reasonCodeAlreadyProcessed) {
                        this.reasonCode = this.tempVal;
                        this.reasonCodeAlreadyProcessed = true;
                    }
                } else if ("TASKNO".equals(name)) {
                    this.taskNumber = Integer.parseInt(this.tempVal);
                } else if ("CHANGETIME".equals(name)) {
                    this.changeTime = this.tempVal;
                } else if ("CREATETIME".equals(name)) {
                    this.createTime = this.tempVal;
                }
            }
            this.rawMessageBuffer.append(this.tempVal);
        }
        if (this.status == 5) {
            if (MESSAGES.equals(name)) {
                this.status = 4;
            } else {
                this.getCurrentErrorObject().getCurrentErrorMessage().setAttributeValue(name, this.getCurrentTagValue());
            }
        } else if (this.status == 4) {
            if (ERRORELEMENT.equals(name)) {
                this.status = 1;
            } else if (TARGET.equals(name)) {
                this.getCurrentErrorObject().close();
            } else {
                this.getCurrentErrorObject().setAttributeValue(name, this.getCurrentTagValue());
            }
        }
        if (StringUtil.hasContent((String)this.tempVal)) {
            this.rawMessageBuffer.append(CMUtilities.LINE_SEPARATOR);
            this.appendSpaces();
        }
        this.rawMessageBuffer.append("</" + name + ">");
        if (!SCAFFOLD_TAGS.contains(name)) {
            --this.depth;
        }
    }

    protected String getCurrentTagValue() {
        try {
            return CMUtilities.decodeFromEBCDICValue(this.tempVal).trim();
        }
        catch (UnsupportedEncodingException e) {
            this.setException("Error decoding " + this.tempVal, e);
            return "";
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = start;
        while (i < start + length) {
            this.buffer.append(ch[i]);
            ++i;
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        this.status = 2;
    }

    public String getReturnResponse() {
        if (this.returnCode == 8 && this.reasonCode.substring(4).equals(limitExceededCode)) {
            return Messages.getString("RetrievalLimitExceeded.message");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getReadableReturnCode());
        buffer.append(" : ");
        buffer.append(this.getReadableReasonCode());
        return buffer.toString();
    }

    protected ErrorObject getCurrentErrorObject() {
        return this.fErrorObjects.get(this.fErrorObjects.size() - 1);
    }

    public static String getReadableReasonCode(String fullReasonCode) {
        return Messages.getString("ReasonCode_" + fullReasonCode.substring(4) + ".message");
    }

    public String getReadableReasonCode() {
        return MessageResponse.getReadableReasonCode(this.reasonCode);
    }

    public static String getReadableReturnCode(int returnCode) {
        return Messages.getString("ReturnCode_" + returnCode + ".message");
    }

    public String getReadableReturnCode() {
        return MessageResponse.getReadableReturnCode(this.returnCode);
    }

    public String toString() {
        return this.rawMessageBuffer.toString();
    }

    public class ErrorMessage
    extends ResponseNode {
        @Override
        protected void setAttributeValue(String name, String currentTagValue) {
            super.setAttributeValue(name, currentTagValue);
        }

        public String getMessage() {
            return (String)this.fAttributeValues.get(MessageResponse.MSGELEMENT);
        }
    }

    public class ErrorObject
    extends ResponseNode {
        private List<ErrorMessage> fErrorMessages;

        public ErrorObject() {
            this.fErrorMessages = new ArrayList<ErrorMessage>();
        }

        @Override
        protected void setAttributeValue(String name, String currentTagValue) {
            super.setAttributeValue(name, currentTagValue);
        }

        public List<ErrorMessage> getErrorMessages() {
            return this.fErrorMessages;
        }

        void addErrorMessage(ErrorMessage errorMessage) {
            this.fErrorMessages.add(errorMessage);
        }

        ErrorMessage getCurrentErrorMessage() {
            return this.fErrorMessages.get(this.fErrorMessages.size() - 1);
        }
    }

    public class ResponseNode {
        boolean isClosed = false;
        protected Map<String, String> fAttributeValues = new HashMap<String, String>();

        protected void setAttributeValue(String name, String currentTagValue) {
            if (!this.isClosed) {
                this.fAttributeValues.put(name, currentTagValue);
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + ":" + this.fAttributeValues.toString();
        }

        void close() {
            this.isClosed = true;
        }
    }
}

