/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model.runtime;

import com.ibm.cics.cm.model.runtime.Element;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RestrictionElementList
extends Node
implements Cloneable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private List<IRestrictionCriteria> restrictionCriteriaList = new ArrayList<IRestrictionCriteria>();

    @Override
    public String getName() {
        return "RESTRICTIONELEMENT";
    }

    public void addUnique(IRestrictionCriteria restrictionCriteria) {
        IRestrictionCriteria elementNamed = this.getElementNamed(restrictionCriteria.getFieldName());
        if (elementNamed != null) {
            this.restrictionCriteriaList.remove(elementNamed);
        }
        this.add(restrictionCriteria);
    }

    public void add(IRestrictionCriteria restrictionCriteria) {
        if (restrictionCriteria.getValue().equals("*")) {
            this.restrictionCriteriaList.add(0, restrictionCriteria);
        } else {
            this.restrictionCriteriaList.add(restrictionCriteria);
        }
    }

    @Override
    public Element createElement(Element parentElement) {
        if (this.restrictionCriteriaList.isEmpty()) {
            return null;
        }
        Element restrictionElement = parentElement.createChild("RESTRICTIONELEMENT");
        restrictionElement.createChild("LISTCOUNT", Integer.toString(this.restrictionCriteriaList.size()));
        for (IRestrictionCriteria restrictionCriteria : this.restrictionCriteriaList) {
            Element listElement = restrictionElement.createChild("LISTELEMENT");
            listElement.createChild("RESTRICTIONFIELD", restrictionCriteria.getFieldName());
            listElement.createChild("RESTRICTIONOPERATOR", restrictionCriteria.getOperatorName());
            listElement.createChild("RESTRICTIONVALUE", restrictionCriteria.getValue());
        }
        return restrictionElement;
    }

    public boolean includesElementNamed(String attributeName) {
        for (IRestrictionCriteria aRestrictionCriteria : this.restrictionCriteriaList) {
            if (!aRestrictionCriteria.getFieldName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public IRestrictionCriteria getElementNamed(String attributeName) {
        for (IRestrictionCriteria aRestrictionCriteria : this.restrictionCriteriaList) {
            if (!aRestrictionCriteria.getFieldName().equals(attributeName)) continue;
            return aRestrictionCriteria;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RestrictionCriteriaList{");
        buffer.append(this.restrictionCriteriaList.toString());
        buffer.append("}");
        return buffer.toString();
    }

    public List<IRestrictionCriteria> getRestrictionCriteria() {
        return this.restrictionCriteriaList;
    }

    public boolean isEmpty() {
        return this.restrictionCriteriaList.isEmpty();
    }

    protected Object clone() throws CloneNotSupportedException {
        RestrictionElementList restrictionElementList = new RestrictionElementList();
        List<IRestrictionCriteria> restrictionCriteriaListsToCopyFrom = this.getRestrictionCriteria();
        for (IRestrictionCriteria restrictionCriteria : restrictionCriteriaListsToCopyFrom) {
            IRestrictionCriteria copeOfIRestrictionCriteria = (IRestrictionCriteria)restrictionCriteria.clone();
            restrictionElementList.addUnique(copeOfIRestrictionCriteria);
        }
        return restrictionElementList;
    }

    public void removeCriteriaForFieldName(String name) {
        IRestrictionCriteria criteriaToRemove = null;
        Iterator<IRestrictionCriteria> iterator = this.restrictionCriteriaList.iterator();
        if (iterator.hasNext()) {
            IRestrictionCriteria criteria = iterator.next();
            if (criteria.getFieldName().equals(name)) {
                // empty if block
            }
            criteriaToRemove = criteria;
        }
        if (criteriaToRemove != null) {
            this.restrictionCriteriaList.remove(criteriaToRemove);
        }
    }
}

