/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.LabelUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Utilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2010, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final char SINGLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final char UNDERSCORE = '_';
    public static final int MAXIMUM_DATASET_NAME_LENGTH = 44;
    public static final int MAXIMUM_QUALIFIER_LENGTH = 8;
    public static final int MINIMUM_NUMBER_OF_QUALIFIERS = 2;
    public static final String QUALIFIER_VALID_INITIAL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ#@$";
    public static final String QUALIFIER_VALID_SUBSEQUENT_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ#@$0123456789-";
    public static final String UNIT_OR_VOLUME_VALID_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final Debug DEBUG = new Debug(Utilities.class);

    public static InputStream getEmptyInputStream() {
        InputStream result = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        return result;
    }

    public static String asValidHFSFileName(String aString) {
        StringReader reader = new StringReader(aString);
        StringBuffer buffer = new StringBuffer(aString.length());
        int position = 1;
        boolean substitionUsed = false;
        try {
            int character = reader.read();
            while (character != -1) {
                if (character >= 65 & character <= 90 || character >= 97 & character <= 122 || character >= 48 && character <= 57 || character == 47 || character == 46 || character == 95 || character == 35 || character == 64 || character == 45) {
                    buffer.append((char)character);
                    substitionUsed = false;
                } else if (position < aString.length() && !substitionUsed) {
                    buffer.append('_');
                    substitionUsed = true;
                }
                character = reader.read();
                ++position;
            }
        }
        catch (IOException e) {
            DEBUG.error("validateHFSFileName", e);
        }
        return buffer.toString();
    }

    public static String ensureNotEnclosedBySingleQuotes(String aString) {
        return Utilities.ensureNotEnclosedBy(aString, '\'');
    }

    public static String ensureNotEnclosedBy(String aString, char aChar) {
        if (aString == null || aString.isEmpty()) {
            return aString;
        }
        char firstChar = aString.charAt(0);
        char lastChar = Utilities.lastCharacter(aString);
        if (firstChar != aChar && lastChar != aChar) {
            return aString;
        }
        int start = firstChar == aChar ? 1 : 0;
        int end = lastChar == aChar ? aString.length() - 1 : aString.length();
        return aString.substring(start, end);
    }

    public static char lastCharacter(String aString) {
        return aString.charAt(aString.length() - 1);
    }

    public static String ensureNotEnclosedByDoubleQuotes(String aString) {
        return Utilities.ensureNotEnclosedBy(aString, '\"');
    }

    public static String validateHFSFile(String aDirectoryName) {
        StringReader reader = new StringReader(aDirectoryName);
        try {
            int character = reader.read();
            while (character != -1) {
                if (character >= 65 & character <= 90 || character >= 97 & character <= 122 || character >= 48 && character <= 57 || character == 47 || character == 46 || character == 95 || character == 37 || character == 35 || character == 64 || character == 36 || character == 45 || character == 32 || character == 33 || character == 61 || character == 44) {
                    if (character == 47) {
                        throw new IllegalArgumentException(LabelUtil.getString("HFS_Name_error_separator"));
                    }
                } else {
                    String errorMessage = MessageFormat.format(LabelUtil.getString("HFS_Name_error_invalid_character"), Character.valueOf((char)character));
                    throw new IllegalArgumentException(errorMessage);
                }
                character = reader.read();
            }
        }
        catch (IOException e) {
            DEBUG.error("validateHFSFileName", e);
        }
        return null;
    }

    public static String validateHFSDirectory(String aDirectoryName) {
        StringReader reader = new StringReader(aDirectoryName);
        try {
            int character = reader.read();
            boolean isPathSeparator = character == 47;
            while (character != -1) {
                if (character >= 65 & character <= 90 || character >= 97 & character <= 122 || character >= 48 && character <= 57 || character == 47 || character == 46 || character == 95 || character == 35 || character == 64 || character == 45 || character == 32) {
                    if (isPathSeparator && character == 47) {
                        String errorMessage = MessageFormat.format(LabelUtil.getString("HFS_Directory_error_multiple_separator"), aDirectoryName);
                        throw new IllegalArgumentException(errorMessage);
                    }
                } else {
                    String errorMessage = MessageFormat.format(LabelUtil.getString("HFS_Name_error_invalid_character"), Character.valueOf((char)character));
                    throw new IllegalArgumentException(errorMessage);
                }
                character = reader.read();
                boolean bl = isPathSeparator = character == 47;
            }
        }
        catch (IOException e) {
            DEBUG.error("validateHFSDirectory", e);
        }
        return null;
    }

    public static void validateDatasetName(String aDatasetName) {
        if (aDatasetName.length() > 44) {
            String errorMessage = MessageFormat.format(LabelUtil.getString("ValidationRules_MaxLength"), 44);
            throw new IllegalArgumentException(errorMessage);
        }
        String[] qualifiers = aDatasetName.split("\\.");
        if (qualifiers.length < 2) {
            String errorMessage = LabelUtil.getString("Dataset_Name_Must_Have_At_Least_Two_Qualifiers");
            throw new IllegalArgumentException(errorMessage);
        }
        String[] stringArray = qualifiers;
        int n = qualifiers.length;
        int n2 = 0;
        while (n2 < n) {
            String qualifier = stringArray[n2];
            int length = qualifier.length();
            if (length > 8) {
                String errorMessage = LabelUtil.getString("Dataset_Qualifiers_MaxLength");
                throw new IllegalArgumentException(errorMessage);
            }
            if (length < 1) {
                String errorMessage = LabelUtil.getString("Dataset_Qualifiers_MinLength");
                throw new IllegalArgumentException(errorMessage);
            }
            if (!QUALIFIER_VALID_INITIAL_CHARS.contains(qualifier.subSequence(0, 1))) {
                String errorMessage = MessageFormat.format(LabelUtil.getString("Dataset_Qualifiers_First_Invalid"), QUALIFIER_VALID_INITIAL_CHARS);
                throw new IllegalArgumentException(errorMessage);
            }
            int index = 1;
            while (index < length) {
                if (!QUALIFIER_VALID_SUBSEQUENT_CHARS.contains(qualifier.subSequence(index, index + 1))) {
                    String errorMessage = MessageFormat.format(LabelUtil.getString("Dataset_Qualifiers_Subsequent_Invalid"), QUALIFIER_VALID_SUBSEQUENT_CHARS);
                    throw new IllegalArgumentException(errorMessage);
                }
                ++index;
            }
            ++n2;
        }
        if (aDatasetName.contains("..") || aDatasetName.charAt(aDatasetName.length() - 1) == '.') {
            String errorMessage = LabelUtil.getString("Dataset_Qualifiers_MinLength");
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void validateUnitOrVolumeChars(String name, String UnitOrVolume) {
        int index = 0;
        while (index < name.length()) {
            if (!UNIT_OR_VOLUME_VALID_CHARS.contains(name.subSequence(index, index + 1))) {
                String errorMessage = MessageFormat.format(LabelUtil.getString("Unit_Or_Volume_Invalid"), UnitOrVolume, UNIT_OR_VOLUME_VALID_CHARS);
                throw new IllegalArgumentException(errorMessage);
            }
            ++index;
        }
    }

    public static <T> List<T> safeListCaster(Class<? extends T> clazz, Collection<?> collectionToCast) {
        ArrayList<T> result = new ArrayList<T>(collectionToCast.size());
        for (Object object : collectionToCast) {
            result.add(clazz.cast(object));
        }
        return result;
    }
}

