/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.cpsm.comm;

import com.ibm.cics.cm.comm.CMConnectionRecord;
import com.ibm.cics.cm.comm.CMResponse;
import com.ibm.cics.cm.cpsm.comm.CMFilterConnectionException;
import com.ibm.cics.cm.cpsm.comm.CMInvalidDefinitionForCSDConnectionException;
import com.ibm.cics.cm.cpsm.comm.CMUtils;
import com.ibm.cics.cm.cpsm.comm.ICMSMConnection;
import com.ibm.cics.cm.cpsm.comm.Messages;
import com.ibm.cics.cm.cpsm.comm.MissingSMConnectionException;
import com.ibm.cics.cm.model.CMContext;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.CPSMContext;
import com.ibm.cics.cm.model.CSDConfiguration;
import com.ibm.cics.cm.model.CSDContext;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.ConfigurationConnectionManager;
import com.ibm.cics.cm.model.ConfigurationContext;
import com.ibm.cics.cm.model.ConfigurationOverrides;
import com.ibm.cics.cm.model.Constants;
import com.ibm.cics.cm.model.FilterExpression;
import com.ibm.cics.cm.model.HistoryContext;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.ModelPreferenceInitializer;
import com.ibm.cics.cm.model.OrphanedResourceContext;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.ResourceDefinitionGroupContext;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.definitions.CICSRegionDefinition;
import com.ibm.cics.cm.model.definitions.CPSMNoGroupDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.model.definitions.WorkloadSpecificationDefinition;
import com.ibm.cics.cm.model.runtime.CMConnection;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ContainerData;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.MessageResponse;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList;
import com.ibm.cics.cm.model.runtime.ObjectData;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.cm.model.runtime.ResourceListObjectData;
import com.ibm.cics.cm.model.runtime.RestrictionCriteria;
import com.ibm.cics.cm.model.runtime.RestrictionCriteriaList;
import com.ibm.cics.cm.model.runtime.TargetLocationCriteria;
import com.ibm.cics.common.CICSRelease;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.ICompositeConnection;
import com.ibm.cics.core.comm.IConnection;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.CICSTypes;
import com.ibm.cics.core.model.CPSM;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.GroupContext;
import com.ibm.cics.core.model.IModelVersionChecker;
import com.ibm.cics.core.model.PlatformDefinitionType;
import com.ibm.cics.core.model.context.CPSMDefinitionPrimaryKey;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICSDGroupDefinition;
import com.ibm.cics.model.ICSDListDefinition;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.model.IResourceDescriptionDefinition;
import com.ibm.cics.model.IResourceGroupDefinition;
import com.ibm.cics.sm.comm.AbstractFilteredContext;
import com.ibm.cics.sm.comm.AbstractSystemManagerConnection;
import com.ibm.cics.sm.comm.CreateException;
import com.ibm.cics.sm.comm.ErrorCodes;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSGetAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IComplexFilteredContext;
import com.ibm.cics.sm.comm.ICompoundFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.IResourceErrors;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.ISMUpdateException;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.InstallException;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SMUpdateConflictException;
import com.ibm.cics.sm.comm.SMUpdateException;
import com.ibm.cics.sm.comm.SystemManagerActions;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.actions.InstallAction;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.cics.sm.comm.context.IGroupContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public class CMSMConnection
extends AbstractSystemManagerConnection
implements ICMSMConnection,
ISystemManagerConnection,
Constants,
IModelVersionChecker,
ICompositeConnection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(CMSMConnection.class);
    private static final String BLANK = "";
    private static final String COMMA = ",";
    private boolean connected = false;
    private ISystemManagerConnection smConnection;
    public static String ID = "com.ibm.cics.cm.comm.connection";
    public static final String CONNECTION_ID = "ID";
    public static final String CONNECTION_NAME = "NAME";
    public static final String SM_CONFIGURATION_ID = "SM_CONFIGURATION_ID";
    public static final String ONLY_CM = Messages.getString("CMSMConnection.0");
    public CMConnection cmConnection;
    private final String[] SSLSERVER = new String[]{"534", "Unexpected end of file from server", " refused: connect", "Unrecognized SSL message, plaintext connection?"};
    private static final Logger logger = Logger.getLogger("com.ibm.cics.sm.comm.cpsm");
    public static final String CSDGROUP = "CSDGROUP";
    public static final String CSDLIST = "CSDLIST";
    private static final Map<Integer, String> versions = new HashMap<Integer, String>();
    private Map<String, SMConnectionResponse> stubs = new HashMap<String, SMConnectionResponse>();
    private ConnectionConfiguration smConfiguration;
    private ConnectionException smException;
    private static Map<String, String> regionNameToApplid;
    private static CMSMConnection current;

    static {
        versions.put(530, CICSRelease.e700.getCICSTSLevel());
        versions.put(520, CICSRelease.e690.getCICSTSLevel());
        versions.put(510, CICSRelease.e680.getCICSTSLevel());
        versions.put(420, CICSRelease.e670.getCICSTSLevel());
        versions.put(410, CICSRelease.e660.getCICSTSLevel());
        versions.put(320, CICSRelease.e650.getCICSTSLevel());
        versions.put(310, CICSRelease.e640.getCICSTSLevel());
        regionNameToApplid = new HashMap<String, String>();
    }

    private SMConnectionResponse getFromCMConnection(String resourceType, IContext context) throws ConnectionException {
        Object response = null;
        LocationCriteria locationCriteria = null;
        ObjectCriteria objectCriteria = null;
        RestrictionCriteriaList restrictionCriteriaList = null;
        Configuration configuration = null;
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext(context, resourceType);
        if (resourceGroupContext != null) {
            configuration = resourceGroupContext.getConfiguration();
            resourceGroupContext.setResourceType(resourceType);
            locationCriteria = resourceGroupContext.getLocationCriteria();
            objectCriteria = resourceGroupContext.getObjectCriteria(resourceType);
        } else if (context instanceof IFilteredContext) {
            configuration = CMSMConnection.getConfiguration(context);
            locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
            objectCriteria = ObjectCriteria.newObjectCriteria(resourceType);
        }
        restrictionCriteriaList = context instanceof IFilteredContext ? CMUtilities.includeAllAttributes(restrictionCriteriaList, resourceType, configuration, objectCriteria, (IFilteredContext)context) : CMUtilities.includeAllAttributes(restrictionCriteriaList, resourceType, configuration);
        if (restrictionCriteriaList != null) {
            try {
                restrictionCriteriaList = restrictionCriteriaList.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new ConnectionException((Exception)e);
            }
        }
        if (objectCriteria == null) {
            return response;
        }
        try {
            if (restrictionCriteriaList != null && restrictionCriteriaList.getFirstElementList().isEmpty()) {
                restrictionCriteriaList = null;
            }
            ArrayList<CMConnectionRecord> records = new ArrayList<CMConnectionRecord>();
            int displayLimit = Platform.getPreferencesService().getInt("com.ibm.cics.cm.model", "PAGE_SIZE", ModelPreferenceInitializer.defaultPageSize.intValue(), null);
            ListMessageResponse listMessageResponse = this.getCMConnection().listWithRestrictionCriteriaAndProcessParms(locationCriteria, objectCriteria, restrictionCriteriaList, ProcessParms.getDisplayLimit(Integer.toString(displayLimit)));
            ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
            for (Map<String, String> attributes : listMessageResponse) {
                records.add(new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context));
            }
            CMConnectionRecord[] recordsAsArray = new CMConnectionRecord[records.size()];
            response = new CMResponse(resourceType, records.toArray(recordsAsArray));
        }
        catch (CMServerException e) {
            if (e.isSpecifiedObjectNotFound()) {
                response = CMResponse.emptyResponse((String)resourceType);
            }
            if (e.isInvalidResourceType()) {
                response = new CMResponse(resourceType, 0){

                    public String getStatus() {
                        return "BADOBJECT";
                    }
                };
            }
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
        if (response != null) {
            this.stubs.put(response.getStub(), (SMConnectionResponse)response);
        }
        return response;
    }

    private String getPlexForContext(IContext aContext) {
        IContext parentContext;
        if (aContext instanceof IGroupContext && (parentContext = ((IGroupContext)aContext).getParentContext()) instanceof ConfigurationContext) {
            Configuration configuration = ((ConfigurationContext)parentContext).getConfiguration();
            return ((CPSMConfiguration)configuration).getPlexName();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SMConnectionResponse get(String resourceType, IContext context) throws ConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"get", (Object)this, (Object)resourceType, (Object)context);
        CMResponse response = null;
        if (resourceType.equals("RESGROUP") || resourceType.equals(CSDGROUP)) {
            response = this.getGroupDefinitions(context, resourceType);
        } else if (resourceType.equals("RESDESC") || resourceType.equals(CSDLIST)) {
            response = this.getGroupDefinitions(context, resourceType);
        } else if (resourceType.equals("RESINGRP") || resourceType.equals("CSDINGRP")) {
            response = this.getGroupMembers(context, resourceType);
        } else {
            Configuration configuration = CMSMConnection.getConfiguration(context);
            if (context instanceof IGroupContext) {
                if (this.smConnection != null && this.smConnection.isConnected() && configuration instanceof CPSMConfiguration) {
                    String plexName = this.getPlexForContext(context);
                    if (plexName != null) {
                        String resourceGroup = ((IGroupContext)context).getResourceGroup();
                        context = new GroupContext((IContext)new Context(plexName), resourceGroup);
                    }
                    response = this.getFromSMConnection(resourceType, context);
                } else {
                    response = this.getFromCMConnection(resourceType, (IContext)new FilteredContext(context));
                }
            } else if (ResourceDefinitionFactory.isCMResourceType(resourceType) && configuration != null && configuration instanceof CSDConfiguration) {
                ICICSType cicsType = CICSTypes.findForResourceTableName((String)resourceType);
                if (cicsType instanceof ApplicationDefinitionType || cicsType instanceof PlatformDefinitionType) {
                    throw new CMInvalidDefinitionForCSDConnectionException();
                }
                if (context instanceof IFilteredContext) {
                    response = this.getFromCMConnection(resourceType, context);
                } else {
                    if (!(context instanceof CSDContext) && !(context instanceof CPSMContext)) throw new CMFilterConnectionException();
                    response = this.getFromCMConnection(resourceType, (IContext)new FilteredContext(context));
                }
            } else if (this.smConnection != null && this.smConnection.isConnected()) {
                response = this.getFromSMConnection(resourceType, this.toSMContext(context));
            } else if (ResourceDefinitionFactory.isCMResourceType(resourceType)) {
                if (!(context instanceof IFilteredContext)) throw new CMFilterConnectionException();
                response = this.getFromCMConnection(resourceType, context);
            }
        }
        if (response == null) {
            response = CMResponse.emptyResponse((String)resourceType);
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"get", (Object)response);
        return response;
    }

    private SMConnectionResponse getGroupMembers(IContext context, String resourceType) {
        Configuration configuration = CMSMConnection.getConfiguration(context);
        if (configuration == null) {
            return null;
        }
        if (context instanceof IFilteredContext) {
            String groupName;
            IFilteredContext ifc = (IFilteredContext)context;
            String string = groupName = resourceType.equals("CSDINGRP") ? ifc.getAttributeValue(CSDGROUP) : ifc.getAttributeValue("RESGROUP");
            if (StringUtil.hasContent((String)groupName)) {
                LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(groupName);
                ListMessageResponse cmResponse = null;
                try {
                    cmResponse = this.getCMConnection().listResources(locationCriteria, objectCriteria, null);
                }
                catch (CMServerException e) {
                    e.printStackTrace();
                }
                if (cmResponse != null) {
                    ArrayList<CMConnectionRecord> records = new ArrayList<CMConnectionRecord>();
                    for (Map<String, String> attributes : cmResponse) {
                        attributes.put("CICSSYS", "FORCE_ATTRIBUTE_UNSUPPORTED");
                        attributes.put("DEFNAME", attributes.get(CONNECTION_NAME));
                        String defType = resourceType.equals("CSDINGRP") ? CMUtilities.resolveDeftypeValueFromCMType(attributes.get("TYPE")).name() : attributes.get("TYPE");
                        attributes.put("DEFTYPE", defType);
                        attributes.put("CPSMTYPE", attributes.get("TYPE"));
                        ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, attributes.get("TYPE"));
                        CMConnectionRecord record = new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context);
                        records.add(record);
                    }
                    CMConnectionRecord[] recordsAsArray = records.toArray(new CMConnectionRecord[records.size()]);
                    CMResponse result = new CMResponse(resourceType, recordsAsArray);
                    this.stubs.put(result.getStub(), (SMConnectionResponse)result);
                    return result;
                }
            }
        }
        return null;
    }

    IContext toSMContext(IContext aContext) {
        if (aContext instanceof IFilteredContext && ((IFilteredContext)aContext).getParentContext() instanceof IGroupContext) {
            final IFilteredContext filteredContext = (IFilteredContext)aContext;
            IGroupContext groupContext = (IGroupContext)((IFilteredContext)aContext).getParentContext();
            String contextName = groupContext.getParentContext().getContext();
            Configuration configuration = ConfigurationManager.getCurrent().getCachedConfiguration(contextName);
            if (configuration instanceof CPSMConfiguration) {
                String plexName = ((CPSMConfiguration)configuration).getPlexName();
                Context topLevelPlexContext = new Context(plexName);
                GroupContext newGroupContext = new GroupContext((IContext)topLevelPlexContext, groupContext.getResourceGroup());
                AbstractFilteredContext newFilteredContext = new AbstractFilteredContext((IContext)newGroupContext){

                    public Set<String> getAttributeNames() {
                        return filteredContext.getAttributeNames();
                    }

                    public String getAttributeValue(String attributeName) {
                        return filteredContext.getAttributeValue(attributeName);
                    }
                };
                return newFilteredContext;
            }
        }
        return aContext;
    }

    public static IContext getTopLevelContext(IContext aContext) {
        if (aContext instanceof IFilteredContext) {
            return CMSMConnection.getTopLevelContext(((IFilteredContext)aContext).getParentContext());
        }
        if (aContext instanceof IGroupContext) {
            return ((IGroupContext)aContext).getParentContext();
        }
        return aContext;
    }

    public static Configuration getConfiguration(IContext aContext) {
        if ((aContext = CMSMConnection.getTopLevelContext(aContext)) instanceof ConfigurationContext) {
            return ((ConfigurationContext)aContext).getConfiguration();
        }
        if (aContext instanceof IScopedContext) {
            IScopedContext scopedContext = (IScopedContext)aContext;
            Configuration cachedConfiguration = ConfigurationManager.getCurrent().getCachedConfiguration(scopedContext.getScope());
            if (cachedConfiguration != null) {
                return cachedConfiguration;
            }
            return CMSMConnection.getConfigurationForRegion(scopedContext.getScope());
        }
        String configurationOrPlexName = aContext.getContext();
        Configuration configuration = ConfigurationManager.getCurrent().getCachedConfiguration(configurationOrPlexName);
        if (configuration != null) {
            return configuration;
        }
        return CMSMConnection.getConfigurationForPlex(configurationOrPlexName);
    }

    private static Configuration getConfigurationForRegion(String regionName) {
        String applid = CMSMConnection.getApplidForRegion(regionName);
        if (applid == null) {
            return null;
        }
        ConfigurationConnection configurationConnectionForApplid = ConfigurationConnectionManager.getCurrent().getConfigurationConnectionForApplid(applid);
        if (configurationConnectionForApplid == null) {
            return null;
        }
        CSDConfiguration csdConfiguration = ConfigurationManager.getCurrent().getConfigurationForConnection(configurationConnectionForApplid);
        return csdConfiguration;
    }

    private CMResponse getGroupDefinitions(IContext aContext, String type) throws ConnectionException {
        IAssociationContext asocContext;
        Configuration configuration = CMSMConnection.getConfiguration(aContext);
        if (configuration == null) {
            return null;
        }
        IContext parentContext = CMSMConnection.getTopLevelContext(aContext);
        Set<String> groupNamesInList = null;
        if (parentContext instanceof IAssociationContext && (type.equals("RESGROUP") || type.equals(CSDGROUP)) && ((asocContext = (IAssociationContext)parentContext).getResourceType().equals("RESDESC") || asocContext.getResourceType().equals(CSDLIST))) {
            try {
                groupNamesInList = this.getGroupsInList(configuration, asocContext);
            }
            catch (CMServerException e) {
                if (e.isSpecifiedObjectNotFound()) {
                    return null;
                }
                throw new ConnectionException((Exception)e);
            }
            if (groupNamesInList.isEmpty()) {
                return null;
            }
        }
        ObjectCriteria objectCriteria = new ObjectCriteria();
        String cmType = type;
        if (type.equals(CSDGROUP)) {
            cmType = "RESGROUP";
        } else if (type.equals(CSDLIST)) {
            cmType = "RESDESC";
        }
        objectCriteria.setObjectType(cmType);
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
        RestrictionCriteriaList restrictionCriteriaList = null;
        if (aContext instanceof IFilteredContext) {
            IFilteredContext filteredContext = (IFilteredContext)aContext;
            String nameValue = null;
            nameValue = type.equals(CSDGROUP) || type.equals(CSDLIST) ? filteredContext.getAttributeValue(CONNECTION_NAME) : filteredContext.getAttributeValue(type);
            if (StringUtil.hasContent((String)nameValue)) {
                objectCriteria.setObjectName(nameValue);
            }
            restrictionCriteriaList = CMUtilities.asRestrictionCriteriaListForResourceGroup(filteredContext, type);
        }
        try {
            ListMessageResponse response = this.getCMConnection().listResources(locationCriteria, objectCriteria, restrictionCriteriaList);
            ArrayList<CMConnectionRecord> records = new ArrayList<CMConnectionRecord>();
            ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, type);
            for (Map<String, String> attributes : response) {
                if (type.equals(CSDGROUP)) {
                    attributes.put("TYPE", CSDGROUP);
                    attributes.put(CONNECTION_NAME, attributes.get("RESGROUP"));
                    attributes.put("CICSSYS", ICICSAttributeConstants.UNSUPPORTED_STRING);
                } else if (type.equals(CSDLIST)) {
                    attributes.put("TYPE", CSDLIST);
                    attributes.put(CONNECTION_NAME, attributes.get("RESDESC"));
                    attributes.put("CICSSYS", ICICSAttributeConstants.UNSUPPORTED_STRING);
                }
                CMConnectionRecord record = new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, aContext);
                if (CMUtilities.hasContent(groupNamesInList)) {
                    String groupName = attributes.get("RESGROUP");
                    if (!groupNamesInList.contains(groupName)) continue;
                    records.add(record);
                    continue;
                }
                records.add(record);
            }
            CMConnectionRecord[] recordsAsArray = records.toArray(new CMConnectionRecord[records.size()]);
            CMResponse result = new CMResponse(type, recordsAsArray);
            this.stubs.put(result.getStub(), (SMConnectionResponse)result);
            return result;
        }
        catch (CMServerException e) {
            if (e.isSpecifiedObjectNotFound()) {
                return null;
            }
            throw new ConnectionException((Exception)e);
        }
    }

    private Set<String> getGroupsInList(Configuration aConfiguration, IAssociationContext aContext) throws CMServerException {
        HashSet<String> groupsInList = new HashSet<String>();
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(aConfiguration.getName());
        ObjectCriteria objectCriteria = ObjectCriteria.newGroupCriteriaForList(aContext.getResourceName());
        ListMessageResponse listResources = this.getCMConnection().listResources(locationCriteria, objectCriteria, null);
        for (Map<String, String> attributes : listResources) {
            String resourceGroupName = attributes.get("RESGROUP");
            groupsInList.add(resourceGroupName);
        }
        return groupsInList;
    }

    private SMConnectionResponse getFromSMConnection(String resourceType, IContext context) throws ConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"getFromSMConnection", (Object)this, (Object)resourceType, (Object)context);
        SMConnectionResponse response = null;
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext((IContext)context, resourceType);
        if (resourceGroupContext != null) {
            Configuration configuration = resourceGroupContext.getConfiguration();
            if (configuration instanceof CPSMConfiguration) {
                final CPSMConfiguration cpsmConfiguration = (CPSMConfiguration)configuration;
                if (context.getContext().equals(cpsmConfiguration.getCPSMContext())) {
                    if (this.smException != null) {
                        throw this.smException;
                    }
                    response = this.smConnection.get(resourceType, context);
                } else {
                    if (context instanceof IFilteredContext) {
                        final IFilteredContext filteredContext = (IFilteredContext)context;
                        final IContext parentContext = new IContext(){

                            public String getContext() {
                                return cpsmConfiguration.getCPSMContext();
                            }
                        };
                        context = new IFilteredContext(){

                            public Set<String> getAttributeNames() {
                                return filteredContext.getAttributeNames();
                            }

                            public String getAttributeValue(String attributeName) {
                                return filteredContext.getAttributeValue(attributeName);
                            }

                            public IContext getParentContext() {
                                return parentContext;
                            }

                            public String getScope() {
                                return filteredContext.getScope();
                            }

                            public String getContext() {
                                return this.getParentContext().getContext();
                            }
                        };
                    } else {
                        context = new IContext(){

                            public String getContext() {
                                return cpsmConfiguration.getCPSMContext();
                            }
                        };
                    }
                    if (this.smException != null) {
                        throw this.smException;
                    }
                    response = this.smConnection.get(resourceType, context);
                }
            }
        } else {
            String contextName = context.getContext();
            Configuration configurationForPlex = CMSMConnection.getConfigurationForPlex(contextName);
            final String plexForConfiguration = this.getPlexForConfiguration(contextName);
            if (plexForConfiguration != null) {
                if (contextName.equals(plexForConfiguration)) {
                    if (this.smException != null) {
                        throw this.smException;
                    }
                    response = this.smConnection.get(resourceType, context);
                } else if (context instanceof IFilteredContext) {
                    final IFilteredContext filteredContext = (IFilteredContext)context;
                    final IContext parentContext = new IContext(){

                        public String getContext() {
                            return plexForConfiguration;
                        }
                    };
                    context = new IFilteredContext(){

                        public Set<String> getAttributeNames() {
                            return filteredContext.getAttributeNames();
                        }

                        public String getAttributeValue(String attributeName) {
                            return filteredContext.getAttributeValue(attributeName);
                        }

                        public IContext getParentContext() {
                            return parentContext;
                        }

                        public String getScope() {
                            return filteredContext.getScope();
                        }

                        public String getContext() {
                            return this.getParentContext().getContext();
                        }
                    };
                } else {
                    context = new IContext(){

                        public String getContext() {
                            return plexForConfiguration;
                        }
                    };
                }
                if (this.smException != null) {
                    throw this.smException;
                }
                response = this.smConnection.get(resourceType, context);
            } else if (configurationForPlex != null) {
                if (this.smException != null) {
                    throw this.smException;
                }
                response = this.smConnection.get(resourceType, context);
            } else {
                if (this.smException != null) {
                    throw this.smException;
                }
                response = this.smConnection.get(resourceType, context);
            }
        }
        if (CICSTypes.ManagedRegion.getResourceTableName().equals(resourceType)) {
            this.getRegions((IContext)context);
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"getFromSMConnection", response);
        return response;
    }

    private void getRegions(IContext context) {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"getRegions", (Object)context);
        try {
            SMConnectionResponse smConnectionResponse = this.getResources(CICSTypes.Region.getResourceTableName(), context);
            for (SMConnectionRecord smConnectionRecord : smConnectionResponse) {
                String regionName = smConnectionRecord.get("EYU_CICSNAME");
                String applid = smConnectionRecord.get("APPLID");
                regionNameToApplid.put(regionName, applid);
            }
        }
        catch (ConnectionException e) {
            Debug.event((Logger)logger, (String)CMSMConnection.class.getName(), (String)"getRegions", (Object)context, (Object)((Object)e));
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"getRegions", (Object)context);
    }

    @Override
    public ResourceDefinitionGroupContext getResourceGroupContext(IContext context, String resourceType) {
        if (context instanceof IPrimaryKey) {
            IPrimaryKey key = (IPrimaryKey)context;
            String resourceGroupName = CSDGROUP.equals(resourceType) ? key.getAttributeValue(CONNECTION_NAME) : ("RESGROUP".equals(resourceType) ? key.getAttributeValue("RESGROUP") : key.getAttributeValue(CSDGROUP));
            Configuration configuration = CMSMConnection.getConfiguration(key.getParentContext());
            if (configuration != null && key.getParentContext() instanceof IGroupContext) {
                return new ResourceDefinitionGroupContext(configuration, ((IGroupContext)key.getParentContext()).getResourceGroup());
            }
            if (resourceGroupName != null && !resourceGroupName.equals(BLANK) && configuration != null) {
                return new ResourceDefinitionGroupContext(configuration, resourceGroupName);
            }
            if (context instanceof CPSMDefinitionPrimaryKey) {
                CPSMDefinitionPrimaryKey cpsmDefinitionPrimaryKey = (CPSMDefinitionPrimaryKey)context;
                String name = cpsmDefinitionPrimaryKey.getAttributeValue("RESGROUP");
                if (configuration == null) {
                    String configName = key.getContext();
                    configuration = CMSMConnection.getConfigurationForPlex(configName);
                }
                if (configuration != null && name != null) {
                    return new ResourceDefinitionGroupContext(configuration, name);
                }
            }
        }
        if (context instanceof IFilteredContext) {
            context = ((IFilteredContext)context).getParentContext();
            return this.getResourceGroupContext(context, resourceType);
        }
        if (context instanceof CPSM.CompoundFilteredContext) {
            Iterator it = ((CPSM.CompoundFilteredContext)(context = (CPSM.CompoundFilteredContext)context)).iterator();
            if (it.hasNext()) {
                return this.getResourceGroupContext((IContext)((IFilteredContext)it.next()), resourceType);
            }
            return this.getResourceGroupContext(((IFilteredContext)context).getParentContext(), resourceType);
        }
        if (context instanceof ResourceDefinitionGroupContext) {
            return (ResourceDefinitionGroupContext)context;
        }
        if (context instanceof IDefinitionContext) {
            IDefinitionContext definitionContext = (IDefinitionContext)context;
            String topLevelContext = definitionContext.getContext();
            String resourceGroupName = definitionContext.getResourceGroup();
            Configuration configuration = definitionContext instanceof IGroupContext && ((IGroupContext)definitionContext).getParentContext() instanceof IScopedContext ? CMSMConnection.getConfiguration(((IGroupContext)definitionContext).getParentContext()) : CMSMConnection.getConfigurationForPlex(topLevelContext);
            if (resourceGroupName != null) {
                if (configuration != null) {
                    return new ResourceDefinitionGroupContext(configuration, resourceGroupName);
                }
                Configuration config = ConfigurationManager.getCurrent().getCachedConfiguration(topLevelContext);
                if (config != null) {
                    return new ResourceDefinitionGroupContext(config, resourceGroupName);
                }
            }
        }
        return null;
    }

    @Override
    public CMConnection getCMConnection() {
        if (this.cmConnection == null) {
            this.cmConnection = new CMConnection();
            this.cmConnection.setConfiguration(this.getConfiguration());
        }
        return this.cmConnection;
    }

    public ISystemManagerConnection getSMConnection() {
        return this.smConnection;
    }

    public CMSMConnection() {
        current = this;
    }

    public void setSystemManagerConnection(ISystemManagerConnection systemManagerConnection) {
        this.smConnection = systemManagerConnection;
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration, Map<String, IConnection> componentConnections) {
        IConnection connection;
        super.setConfiguration(connectionConfiguration);
        this.cmConnection = null;
        String smConnectionId = connectionConfiguration.getExtendedAttribute(SM_CONFIGURATION_ID);
        if (smConnectionId != null) {
            this.smConnection = (ISystemManagerConnection)componentConnections.get(smConnectionId);
            if (this.smConnection != null) {
                Debug.event((Logger)logger, (String)CMSMConnection.class.getName(), (String)"setConfiguration");
            }
        } else if (!componentConnections.isEmpty() && (connection = componentConnections.values().iterator().next()) != null && connection instanceof ISystemManagerConnection) {
            this.smConnection = (ISystemManagerConnection)connection;
            Debug.event((Logger)logger, (String)CMSMConnection.class.getName(), (String)"setConfiguration");
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"setConfiguration");
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"setConfiguration", (Object)this, (Object)connectionConfiguration);
        Map<String, IConnection> emptyConnections = Collections.emptyMap();
        this.setConfiguration(connectionConfiguration, emptyConnections);
    }

    public void connect() throws ConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"connect", (Object)this);
        this.smException = null;
        this.getCMConnection().connect();
        ConfigurationOverrides.setConnectionReleaseNumber(this.getCMConnection().getRelease(), this.getCMConnection().getCMRelease());
        this.connected = true;
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"connect", (Object)this.connected);
    }

    public void setSMConnection(ISystemManagerConnection aSMConnection) {
        this.smConnection = aSMConnection;
    }

    public void disconnect() throws ConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"disconnect", (Object)this);
        this.connected = false;
        if (this.smConnection != null && this.smConnection.isConnected()) {
            this.smConnection.disconnect();
        }
        this.smConnection = null;
        ConfigurationManager.getCurrent().dispose();
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"disconnect", (Object)this.connected);
    }

    public boolean isConnected() {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"isConnected", (Object)this.connected);
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"isConnected", (Object)this.connected);
        return this.connected;
    }

    public void discard(String stub) throws ConnectionException {
        if (this.stubs.get(stub) != null) {
            this.stubs.remove(stub);
        } else if (this.smConnection != null) {
            this.smConnection.discard(stub);
        }
    }

    public SMConnectionResponse fetch(String stub, int position, int count) throws ConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"fetch", (Object)this, (Object)stub, (Object)String.valueOf(position), (Object)String.valueOf(count));
        SMConnectionResponse response = this.stubs.get(stub);
        if (response == null && this.smConnection != null) {
            response = this.smConnection.fetch(stub, position, count);
        } else {
            CMConnectionRecord[] records = new CMConnectionRecord[count];
            int j = 0;
            int i = position - 1;
            while (i < count + position - 1) {
                records[j] = (CMConnectionRecord)response.getRecord(i);
                ++j;
                ++i;
            }
            CMResponse cmResponse = new CMResponse(response.getResourceType(), records, response.getRecordTotal());
            cmResponse.setStub(response.getStub());
            response = cmResponse;
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"fetch", (Object)response);
        return response;
    }

    public static Configuration getConfigurationForPlex(String aPlexName) {
        return ConfigurationManager.getCurrent().getConfigurationForPlex(aPlexName);
    }

    public SMConnectionResponse getResources(String resourceType, IContext context) throws ConnectionException {
        Object adapter;
        SMConnectionResponse resources;
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getResources", (Object)resourceType, (Object)context);
        if (context instanceof IPrimaryKey && ResourceDefinitionFactory.isCMResourceType(resourceType)) {
            ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext(context, resourceType);
            LocationCriteria locationCriteria = null;
            ObjectCriteria objectCriteria = null;
            Configuration configuration = null;
            if (resourceGroupContext != null) {
                locationCriteria = resourceGroupContext.getLocationCriteria();
                objectCriteria = resourceGroupContext.getObjectCriteria(resourceType, this.getPrimaryKeyName((IPrimaryKey)context));
                configuration = resourceGroupContext.getConfiguration();
            } else if (context instanceof IFilteredContext) {
                IContext parentContext = ((IFilteredContext)context).getParentContext();
                if (parentContext instanceof OrphanedResourceContext) {
                    OrphanedResourceContext orphanedResourceContext = (OrphanedResourceContext)parentContext;
                    locationCriteria = orphanedResourceContext.getLocationCriteria();
                    objectCriteria = orphanedResourceContext.getObjectCriteria();
                    configuration = orphanedResourceContext.getConfiguration();
                } else {
                    if (parentContext instanceof HistoryContext) {
                        Map<String, String> definitionAttributes = ((HistoryContext)parentContext).getDefinitionAttributes();
                        configuration = ((HistoryContext)parentContext).getConfiguration();
                        ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
                        CMResponse response = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(definitionAttributes, (CMConnectionRecord.Overrides)overrides, parentContext)});
                        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getResources", (Object)response);
                        return response;
                    }
                    if ("RESGROUP".equals(resourceType)) {
                        configuration = CMSMConnection.getConfiguration(context);
                        locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                        objectCriteria = this.getResourceGroupObjectCriteria((IPrimaryKey)context);
                    } else if ("APPLDEF".equals(resourceType)) {
                        ICMDefinition appldef = CMUtils.getCMApplDefByListingWithKeyValues((IPrimaryKey)context);
                        if (appldef != null) {
                            configuration = appldef.getConfiguration();
                            locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                            objectCriteria = ObjectCriteria.newObjectCriteria(resourceType, appldef.getAttributes().get("ALIAS"));
                        }
                    } else if ("CSYSGRP".equals(resourceType)) {
                        ICMDefinition cmDefinition = CMSMConnection.getConfiguration(context).getDefinition("CSYSGRP", ((IPrimaryKey)context).getAttributeValue("GROUP"));
                        if (cmDefinition != null) {
                            configuration = cmDefinition.getConfiguration();
                            locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                            objectCriteria = ObjectCriteria.newObjectCriteriaForCSysGrp(cmDefinition.getAttributes().get("GROUP"));
                        }
                    } else {
                        ICMDefinition definition = this.getCMDefinitionByFindingFirstResourceGroup(resourceType, (IPrimaryKey)context);
                        if (definition != null) {
                            configuration = definition.getConfiguration();
                            locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                            objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(definition.getResourceGroupName(), resourceType, definition.getName());
                        }
                    }
                }
            }
            if (locationCriteria != null && objectCriteria != null) {
                ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
                try {
                    InquireMessageResponse messageResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                    Map<String, String> attributes = messageResponse.getObject();
                    CMResponse cmResponse = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context)});
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getResources", (Object)cmResponse);
                    return cmResponse;
                }
                catch (CMServerException e) {
                    CMServerListException wrappedCMException = new CMServerListException(e.getMessageResponse(), locationCriteria, objectCriteria);
                    throw new ConnectionException((Exception)wrappedCMException);
                }
            }
        } else {
            if (CICSTypes.CICSplexDefinition.getResourceTableName().equals(resourceType) && context instanceof IPrimaryKey) {
                try {
                    String plexName = ((IPrimaryKey)context).getAttributeValue(CONNECTION_NAME);
                    ObjectCriteria objectCriteria = ObjectCriteria.newConfigurationCriteria("*");
                    RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
                    restrictionCriteriaList.add(new RestrictionCriteria("CONTEXT", FilterExpression.Operator.EQ, plexName));
                    ListMessageResponse messageResponse = this.getCMConnection().listResources(LocationCriteria.newRepositoryLocationCriteria(), objectCriteria, restrictionCriteriaList);
                    Map<String, String> attributes = messageResponse.getObjects().next();
                    CMResponse cmResponse = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, null, context)});
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getResources", (Object)cmResponse);
                    return cmResponse;
                }
                catch (CMServerException e) {
                    throw new ConnectionException((Exception)e);
                }
            }
            if ("RESGROUP".equals(resourceType)) {
                String plexName;
                if (context instanceof CPSMDefinitionPrimaryKey) {
                    ResourceDefinitionGroupContext resourceGroupContext;
                    final CPSMDefinitionPrimaryKey cpsmDefinitionPrimaryKey = (CPSMDefinitionPrimaryKey)context;
                    final String attributeValue = cpsmDefinitionPrimaryKey.getAttributeValue("RESGROUP");
                    if (attributeValue != null) {
                        IDefinitionContext definitionContext = new IDefinitionContext(){

                            public String getResourceGroup() {
                                return attributeValue;
                            }

                            public String getContext() {
                                return cpsmDefinitionPrimaryKey.getParentContext().getContext();
                            }
                        };
                        resourceGroupContext = this.getResourceGroupContext((IContext)definitionContext, resourceType);
                    } else {
                        IContext parentContext = cpsmDefinitionPrimaryKey.getParentContext();
                        resourceGroupContext = this.getResourceGroupContext(parentContext, resourceType);
                    }
                    ResourceDefinitionGroup resourceDefinitionGroup = resourceGroupContext.getResourceDefinitionGroup();
                    ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(resourceGroupContext.getConfiguration(), resourceType);
                    CMResponse response = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(resourceDefinitionGroup.getAttributes(), (CMConnectionRecord.Overrides)overrides, context)});
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getResources", (Object)response);
                    return response;
                }
                Configuration configurationForGroups = CMSMConnection.getConfigurationForPlex(context.getContext());
                if (configurationForGroups == null && (plexName = this.getPlexForConfiguration(context.getContext())) != null) {
                    context = new IContext(){

                        public String getContext() {
                            return plexName;
                        }
                    };
                }
                if (this.smConnection != null) {
                    resources = this.smConnection.getResources(resourceType, context);
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getResources", (Object)resources);
                    return resources;
                }
            } else if (context instanceof IPrimaryKey) {
                if (this.smConnection != null) {
                    return this.smConnection.getResources(resourceType, context);
                }
            } else if (("CICSPLEX".equals(resourceType) || "MAS".equals(resourceType)) && this.smConnection != null) {
                if (CICSTypes.ManagedRegion.getResourceTableName().equals(resourceType)) {
                    this.getRegions(context);
                }
                SMConnectionResponse resources2 = this.smConnection.getResources(resourceType, context);
                Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getResources", (Object)resources2);
                return resources2;
            }
        }
        if (resourceType.equals("PLATFORM") && context instanceof CMContext) {
            if (this.smConnection == null) {
                throw new MissingSMConnectionException();
            }
            if (this.smException != null) {
                throw this.smException;
            }
            adapter = Platform.getAdapterManager().getAdapter((Object)context, IContext.class);
            if (adapter != null) {
                context = (IContext)adapter;
            }
            resources = null;
            try {
                resources = this.smConnection.getResources(resourceType, context);
            }
            catch (ConnectionException ce) {
                throw new ConnectionException((Exception)((Object)ce));
            }
            return resources;
        }
        if (this.smConnection == null) {
            return new CMResponse(resourceType, 0);
        }
        if (this.smException != null) {
            throw this.smException;
        }
        if (context instanceof CMContext && (adapter = Platform.getAdapterManager().getAdapter((Object)context, IContext.class)) != null) {
            context = (IContext)adapter;
        }
        return this.smConnection.getResources(resourceType, context);
    }

    private String getPrimaryKeyName(IPrimaryKey key) {
        if (key instanceof CPSMDefinitionPrimaryKey) {
            return key.getAttributeValue("RESGROUP");
        }
        return key.getAttributeValue(CONNECTION_NAME);
    }

    private ObjectCriteria getResourceGroupObjectCriteria(IPrimaryKey aContext) {
        ObjectCriteria objectCriteria = new ObjectCriteria();
        objectCriteria = new ObjectCriteria();
        objectCriteria.setObjectType("RESGROUP");
        objectCriteria.setObjectName(aContext.getAttributeValue("RESGROUP"));
        return objectCriteria;
    }

    @Override
    public ICMDefinition getCMDefinitionByFindingFirstResourceGroup(String resourceType, IPrimaryKey context) {
        Configuration configuration;
        String resourceName = context.getAttributeValue(CONNECTION_NAME);
        IContext parentContext = context.getParentContext();
        if (parentContext instanceof IFilteredContext) {
            parentContext = ((IFilteredContext)parentContext).getParentContext();
        }
        Configuration configuration2 = configuration = parentContext instanceof ConfigurationContext ? ((ConfigurationContext)parentContext).getConfiguration() : CMSMConnection.getConfigurationForPlex(parentContext.getContext());
        if (configuration == null) {
            return null;
        }
        return configuration.getDefinition(resourceType, resourceName);
    }

    @Override
    public ICMDefinition getCMDefinitionByFindingFirstResourceGroup(ICICSDefinition definition) {
        String resourceName = definition.getName();
        IContext context = CMUtilities.getContext(definition);
        Configuration configuration = null;
        if (context instanceof ConfigurationContext) {
            configuration = ((ConfigurationContext)context).getConfiguration();
        } else {
            configuration = CMSMConnection.getConfigurationForPlex(context.getContext());
            if (configuration == null) {
                configuration = ConfigurationManager.getCurrent().getCachedConfiguration(context.getContext());
            }
        }
        if (configuration != null) {
            return configuration.getDefinition(definition.getCICSType().getResourceTableName(), resourceName);
        }
        return null;
    }

    private String getPlexForConfiguration(String context) {
        Configuration config = ConfigurationManager.getCurrent().getCachedConfiguration(context);
        if (config == null) {
            config = ConfigurationManager.getCurrent().getConfiguration(context);
        }
        if (config != null && config instanceof CPSMConfiguration) {
            return ((CPSMConfiguration)config).getPlexName();
        }
        return null;
    }

    public String getServerApplID() {
        return this.smConnection == null || !this.smConnection.isConnected() ? Messages.getString("CMSMConnection.17") : this.smConnection.getServerApplID();
    }

    public String getVersion() {
        if (this.cmConnection != null) {
            return this.asVersion(this.cmConnection.getRelease());
        }
        return this.smConnection.getVersion();
    }

    private String asVersion(int release) {
        String version = versions.get(release);
        return version;
    }

    private boolean isCSDResourceGroup(String resourceType, IContext aContext) {
        if (!resourceType.equals(CSDGROUP)) {
            return false;
        }
        Configuration configuration = CMSMConnection.getConfiguration(aContext);
        return configuration instanceof CSDConfiguration;
    }

    private boolean isCICSPlexResourceGroup(String resourceType, IContext aContext) {
        if (!resourceType.equals("RESGROUP")) {
            return false;
        }
        Configuration configuration = CMSMConnection.getConfiguration(aContext);
        if (configuration instanceof CPSMConfiguration) {
            return true;
        }
        aContext = CMSMConnection.getTopLevelContext(aContext);
        Configuration configurationForPlex = CMSMConnection.getConfigurationForPlex(aContext.getContext());
        return configurationForPlex instanceof CPSMConfiguration;
    }

    public String getActions(String resourceType, IContext context) {
        String actions;
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"getActions", (Object)this, (Object)resourceType, (Object)context);
        if (ResourceDefinitionFactory.isCMResourceType(resourceType) || this.isCICSPlexResourceGroup(resourceType, context) || this.isCSDResourceGroup(resourceType, context)) {
            if (!ConfigurationOverrides.isValidResourceTypeForRelease(CICSTypes.findForResourceTableName((String)resourceType))) {
                actions = BLANK;
            } else if (this.isHistoryContext(context) || this.isOrphanedResourceContext(context)) {
                actions = "read,delete";
            } else {
                actions = "read,create,update,delete";
                if (this.smConnection != null) {
                    actions = String.valueOf(actions) + ",perform";
                    if (CMSMConnection.getConfiguration(context) instanceof CPSMConfiguration) {
                        actions = String.valueOf(actions) + ",remove";
                    }
                }
            }
        } else if (this.smConnection != null) {
            ConnectionException smConnectException = null;
            if (!this.smConnection.isConnected()) {
                try {
                    this.smConnection.connect();
                }
                catch (ConnectionException e) {
                    smConnectException = e;
                }
            }
            actions = smConnectException == null ? this.smConnection.getActions(resourceType, context) : BLANK;
        } else {
            actions = BLANK;
        }
        if (actions == BLANK && context == IContext.ANY_CONTEXT && this.isKnownListOrGroupType(resourceType)) {
            actions = "read";
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"getActions", (Object)actions);
        return actions;
    }

    private boolean isKnownListOrGroupType(String resourceType) {
        return resourceType.equals(CSDLIST) || resourceType.equals(CSDGROUP) || resourceType.equals("RESDESC") || resourceType.equals("RESGROUP");
    }

    private boolean isOrphanedResourceContext(IContext context) {
        if (context instanceof OrphanedResourceContext) {
            return true;
        }
        if (context instanceof IFilteredContext) {
            return this.isOrphanedResourceContext(((IFilteredContext)context).getParentContext());
        }
        return false;
    }

    private boolean isHistoryContext(IContext context) {
        if (context instanceof HistoryContext) {
            return true;
        }
        if (context instanceof IPrimaryKey) {
            IPrimaryKey primaryKeyContext = (IPrimaryKey)context;
            context = primaryKeyContext.getParentContext();
            return this.isHistoryContext(context);
        }
        return false;
    }

    public SMConnectionResponse perform(String resourceType, IContext context, ICICSAction action) throws SystemManagerConnectionException, ConnectionException {
        if (action instanceof SystemManagerActions.CSDCopyAction) {
            return this.copy(resourceType, context, (SystemManagerActions.CSDCopyAction)action);
        }
        if (action instanceof SystemManagerActions.CSDAddAction) {
            return this.add(resourceType, context, (SystemManagerActions.CSDAddAction)action);
        }
        if (action instanceof SystemManagerActions.AddToResourceDescriptionAction) {
            return this.add(resourceType, context, (SystemManagerActions.AddToResourceDescriptionAction)action);
        }
        if (action instanceof SystemManagerActions.AddWorkloadDefinitionToWorkloadGroupAction) {
            Iterator it;
            IContext iContext = context;
            if (context instanceof CPSM.CompoundFilteredContext && (it = ((CPSM.CompoundFilteredContext)context).iterator()).hasNext()) {
                iContext = (IContext)it.next();
            }
            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
            additionalAttributes.put("DEF", ((IFilteredContext)iContext).getAttributeValue(CONNECTION_NAME));
            additionalAttributes.put("GROUP", action.getParameterValue("RESGROUP"));
            return this.create("WLMINGRP", iContext, CMUtilities.getRecordForCreate(resourceType, null, iContext, additionalAttributes));
        }
        if (action instanceof SystemManagerActions.AddWorkloadGroupToWorkloadSpecificationAction) {
            Iterator it;
            IContext iContext = context;
            if (context instanceof CPSM.CompoundFilteredContext && (it = ((CPSM.CompoundFilteredContext)context).iterator()).hasNext()) {
                iContext = (IContext)it.next();
            }
            HashMap<String, String> additionalAttributes = new HashMap<String, String>();
            additionalAttributes.put("GROUP", ((IFilteredContext)iContext).getAttributeValue(CONNECTION_NAME));
            additionalAttributes.put(CONNECTION_NAME, action.getParameterValue("SPEC"));
            return this.create("WLMINSPC", iContext, CMUtilities.getRecordForCreate(resourceType, null, iContext, additionalAttributes));
        }
        if (this.smConnection != null) {
            return this.smConnection.perform(resourceType, context, action);
        }
        return super.perform(resourceType, context, action);
    }

    private SMConnectionResponse copy(String resourceType, IContext context, SystemManagerActions.CSDCopyAction action) throws SystemManagerConnectionException {
        ResourceDefinitionGroupContext resourceGroupContext;
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"copy", (Object)this, (Object)resourceType, (Object)context, (Object)action);
        SMConnectionResponse response = null;
        List<IPrimaryKey> iPrimaryKeys = this.getPrimaryKeys(context);
        if (iPrimaryKeys.size() > 0 && (resourceGroupContext = this.getResourceGroupContext((IContext)iPrimaryKeys.get(0), resourceType)) != null) {
            ObjectCriteriaList objectCriteriaList = new ObjectCriteriaList();
            for (IPrimaryKey iPrimaryKey : iPrimaryKeys) {
                objectCriteriaList.addListElement(resourceGroupContext.getResourceGroup(), resourceType, iPrimaryKey.getAttributeValue(CONNECTION_NAME));
            }
            if (iPrimaryKeys.size() > 0) {
                String groupName;
                LocationCriteria locationCriteria;
                Configuration configuration;
                block7: {
                    configuration = resourceGroupContext.getConfiguration();
                    String configurationName = configuration.getName();
                    locationCriteria = resourceGroupContext.getLocationCriteria();
                    ProcessParms processParms = ProcessParms.getReplace(true);
                    groupName = action.getParameterValue("TO_CSDGROUP");
                    TargetLocationCriteria targetLocationCriteria = TargetLocationCriteria.newCriteriaForGroup(configurationName, groupName);
                    try {
                        this.getCMConnection().copy(locationCriteria, objectCriteriaList, processParms, targetLocationCriteria);
                    }
                    catch (CMServerException e) {
                        if (e.isWarningCopyReplaced()) break block7;
                        Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"copy", (Object)e);
                        throw new SystemManagerConnectionException((Exception)e);
                    }
                }
                ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(groupName, resourceType, iPrimaryKeys.get(0).getAttributeValue(CONNECTION_NAME));
                try {
                    InquireMessageResponse inquireMessageResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                    Map<String, String> attributes = inquireMessageResponse.getObject();
                    ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
                    return new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context)});
                }
                catch (CMServerException e) {
                    Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"copy", (Object)e);
                    throw new SystemManagerConnectionException((Exception)e);
                }
            }
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"copy", response);
        return response;
    }

    private List<IPrimaryKey> getPrimaryKeys(IContext context) {
        ArrayList<IPrimaryKey> iPrimaryKeys = new ArrayList<IPrimaryKey>();
        if (context instanceof ICompoundFilteredContext) {
            ICompoundFilteredContext compoundContext = (ICompoundFilteredContext)context;
            for (Object next : compoundContext) {
                if (!(next instanceof IContext)) continue;
                IContext aContext = (IContext)next;
                iPrimaryKeys.addAll(this.getPrimaryKeys(aContext));
            }
        }
        if (context instanceof IPrimaryKey) {
            iPrimaryKeys.add((IPrimaryKey)context);
        }
        if (context instanceof IFilteredContext) {
            iPrimaryKeys.addAll(this.getPrimaryKeys(((IFilteredContext)context).getParentContext()));
        }
        return iPrimaryKeys;
    }

    public SMConnectionResponse create(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext(context, resourceType);
        if (resourceGroupContext == null && resourceType.equals(CICSTypes.ResourceGroupDefinition.getResourceTableName())) {
            String name = record.get("RESGROUP");
            Configuration configuration = CMSMConnection.getConfiguration(context);
            if (configuration == null) {
                configuration = CMSMConnection.getConfigurationForPlex(context.getContext());
            }
            if (configuration != null && name != null) {
                resourceGroupContext = new ResourceDefinitionGroupContext(configuration, name);
            }
        }
        if (resourceGroupContext != null) {
            try {
                LocationCriteria locationCriteria = resourceGroupContext.getLocationCriteria();
                ObjectCriteria objectCriteria = null;
                if ("RESGROUP".equals(resourceType)) {
                    objectCriteria = new ObjectCriteria();
                    objectCriteria.setObjectName(record.get("RESGROUP"));
                    objectCriteria.setObjectType("RESGROUP");
                } else {
                    objectCriteria = resourceGroupContext.getObjectCriteria(resourceType, record.get(CONNECTION_NAME));
                }
                record = CMUtilities.getRecordForCreate(resourceType, record, context);
                ObjectData objectData = ObjectData.newFrom(record);
                InquireMessageResponse messageResponse = null;
                try {
                    messageResponse = this.getCMConnection().create(locationCriteria, objectCriteria, objectData);
                }
                catch (CMServerException e) {
                    if (e.isObjectAlreadyExists()) {
                        throw new SMUpdateException(e.getMessage(), (Throwable)e);
                    }
                    if (!e.isDFHEDAPWarning()) {
                        throw this.createSMUpdateException(context, e, resourceType);
                    }
                    debug.error("create", (Throwable)e);
                }
                messageResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                Map<String, String> attributes = messageResponse.getObject();
                ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(resourceGroupContext.getConfiguration(), resourceType);
                return new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context)});
            }
            catch (CMServerException e) {
                throw this.createSMUpdateException(context, e, resourceType);
            }
        }
        if (CPSMNoGroupDefinition.isCPSMNoGroupDefinitionType(resourceType)) {
            try {
                LinkedHashMap<String, String> reqs;
                Configuration configuration = CMSMConnection.getConfiguration(context);
                if (configuration == null) {
                    configuration = CMSMConnection.getConfigurationForPlex(context.getContext());
                }
                LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                ObjectCriteria objectCriteria = new ObjectCriteria();
                objectCriteria.setObjectType(resourceType);
                if (resourceType.equals("PLATDEF") || resourceType.equals("CSYSDEF") || resourceType.equals("WLMSPEC") || resourceType.equals("WLMGROUP") || resourceType.equals("WLMDEF") || resourceType.equals("TRANGRP")) {
                    objectCriteria.setObjectName(record.get(CONNECTION_NAME));
                } else if (resourceType.equals("CSYSGRP")) {
                    objectCriteria.setObjectName(record.get("GROUP"));
                } else {
                    objectCriteria.setObjectName(BLANK);
                }
                ObjectData objectData = ObjectData.newFrom(record);
                if (record.get("BINDDIR") == null && record.get("APPLDIR") != null) {
                    objectData.setAttribute("BINDDIR", record.get("APPLDIR"));
                }
                if (resourceType.equals("CSYSDEF")) {
                    reqs = CICSRegionDefinition.getDefaultAttributes();
                    for (String req : reqs.keySet()) {
                        objectData.setAttribute(req, reqs.get(req));
                    }
                } else if (resourceType.equals("WLMSPEC")) {
                    reqs = WorkloadSpecificationDefinition.getDefaultAttributes();
                    for (String req : reqs.keySet()) {
                        objectData.setAttribute(req, reqs.get(req));
                    }
                }
                InquireMessageResponse messageResponse = null;
                try {
                    messageResponse = "APPLDEF".equals(resourceType) || "CSGLCGCS".equals(resourceType) || "LNKSWSCS".equals(resourceType) || "LNKSWSCG".equals(resourceType) || "WLMINSPC".equals(resourceType) || "WLMINGRP".equals(resourceType) || "DTRINGRP".equals(resourceType) || "CSGLCGCG".equals(resourceType) ? this.getCMConnection().createAppldef(locationCriteria, objectCriteria, objectData) : this.getCMConnection().create(locationCriteria, objectCriteria, objectData);
                }
                catch (CMServerException e) {
                    if (e.isObjectAlreadyExists()) {
                        throw new SMUpdateException(e.getMessage(), (Throwable)e);
                    }
                    if (!e.isDFHEDAPWarning()) {
                        throw this.createSMUpdateException(context, e, resourceType);
                    }
                    if (e.isInvalidResourceGroup()) {
                        SMUpdateException exception = new SMUpdateException(e.getMessage(), (Throwable)e);
                        SMUpdateException.Error error = exception.createError();
                        error.addAttributeName("RESGROUP", resourceType);
                        throw exception;
                    }
                    debug.error("create", (Throwable)e);
                }
                messageResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                Map<String, String> attributes = messageResponse.getObject();
                ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
                return new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context)});
            }
            catch (CMServerException e) {
                throw this.createSMUpdateException(context, e, resourceType);
            }
        }
        if (this.smConnection != null && this.smConnection.isConnected()) {
            return this.smConnection.create(resourceType, context, record);
        }
        ArrayList<String> attributeNames = new ArrayList<String>(1);
        attributeNames.add("RESGROUP");
        CreateException result = new CreateException(resourceType, 0, 0, 0, attributeNames);
        List errors = result.getErrors();
        ((ISMUpdateException.IError)errors.get(0)).setServerResponse(Messages.getString("CMSMConnection.32"));
        throw result;
    }

    public SMConnectionResponse delete(String resourceType, IContext context) throws SystemManagerConnectionException {
        if (IResourceTables.Helper.isCICSDefinition((String)resourceType) || resourceType.equals(CICSTypes.ResourceGroupDefinition.getResourceTableName()) || resourceType.equals(CSDGROUP) || CPSMNoGroupDefinition.isCPSMNoGroupDefinitionType(resourceType)) {
            ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext(context, resourceType);
            if (!CPSMNoGroupDefinition.isCPSMNoGroupDefinitionType(resourceType)) {
                if (resourceGroupContext == null && context instanceof IPrimaryKey) {
                    resourceGroupContext = this.getResourceGroupContextFromKey((IPrimaryKey)context, resourceType);
                }
                if (resourceGroupContext != null) {
                    ObjectCriteria objectCriteria;
                    LocationCriteria locationCriteria = resourceGroupContext.getLocationCriteria();
                    String name = ((IPrimaryKey)context).getAttributeValue(CONNECTION_NAME);
                    if (name == null && "RESGROUP".equals(resourceType)) {
                        name = ((IPrimaryKey)context).getAttributeValue("RESGROUP");
                        objectCriteria = ObjectCriteria.newObjectCriteria("RESGROUP", name);
                    } else {
                        objectCriteria = CSDGROUP.equals(resourceType) ? ObjectCriteria.newObjectCriteriaForGroup(name) : resourceGroupContext.getObjectCriteria(resourceType, name);
                    }
                    try {
                        this.getCMConnection().delete(locationCriteria, objectCriteria);
                    }
                    catch (CMServerException e) {
                        throw this.createSMUpdateException(context, e, resourceType);
                    }
                }
            } else {
                LocationCriteria locationCriteria = null;
                ObjectCriteria objectCriteria = null;
                if ("APPLDEF".equals(resourceType)) {
                    ICMDefinition appldef = CMUtils.getCMApplDefByListingWithKeyValues((IPrimaryKey)context);
                    if (appldef != null) {
                        Configuration configuration = appldef.getConfiguration();
                        locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                        objectCriteria = ObjectCriteria.newObjectCriteria(resourceType, appldef.getAttributes().get("ALIAS"));
                    }
                } else {
                    Configuration configuration = CMSMConnection.getConfiguration(context);
                    if (configuration == null) {
                        configuration = CMSMConnection.getConfigurationForPlex(context.getContext());
                    }
                    locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                    if (resourceType.equals("CSYSGRP")) {
                        objectCriteria = ObjectCriteria.newObjectCriteriaForCSysGrp(((IPrimaryKey)context).getAttributeValue("GROUP"));
                    } else {
                        String name;
                        if (resourceType.equals("CSGLCGCS") || resourceType.equals("LNKSWSCS") || resourceType.equals("LNKSWSCG") || resourceType.equals("WLMINGRP") || resourceType.equals("WLMINSPC") || resourceType.equals("DTRINGRP")) {
                            ObjectCriteria allObjectCriteria = ObjectCriteria.newObjectCriteria(resourceType);
                            IPrimaryKey key = (IPrimaryKey)context;
                            RestrictionCriteriaList restrictionCriteriaList = new RestrictionCriteriaList();
                            if (resourceType.equals("CSGLCGCS")) {
                                restrictionCriteriaList.add(new RestrictionCriteria("CICSNAME", FilterExpression.Operator.EQ, key.getAttributeValue("CICSNAME")));
                                restrictionCriteriaList.add(new RestrictionCriteria("GROUP", FilterExpression.Operator.EQ, key.getAttributeValue("GROUP")));
                            } else if (resourceType.equals("LNKSWSCS")) {
                                restrictionCriteriaList.add(new RestrictionCriteria("SYSTEM", FilterExpression.Operator.EQ, key.getAttributeValue("SYSTEM")));
                                restrictionCriteriaList.add(new RestrictionCriteria("SPEC", FilterExpression.Operator.EQ, key.getAttributeValue("SPEC")));
                            } else if (resourceType.equals("LNKSWSCG")) {
                                restrictionCriteriaList.add(new RestrictionCriteria("SPEC", FilterExpression.Operator.EQ, key.getAttributeValue("SPEC")));
                                restrictionCriteriaList.add(new RestrictionCriteria("GROUP", FilterExpression.Operator.EQ, key.getAttributeValue("GROUP")));
                            } else if (resourceType.equals("WLMINGRP")) {
                                restrictionCriteriaList.add(new RestrictionCriteria("DEF", FilterExpression.Operator.EQ, key.getAttributeValue("DEF")));
                                restrictionCriteriaList.add(new RestrictionCriteria("GROUP", FilterExpression.Operator.EQ, key.getAttributeValue("GROUP")));
                            } else if (resourceType.equals("WLMINSPC")) {
                                restrictionCriteriaList.add(new RestrictionCriteria(CONNECTION_NAME, FilterExpression.Operator.EQ, key.getAttributeValue(CONNECTION_NAME)));
                                restrictionCriteriaList.add(new RestrictionCriteria("GROUP", FilterExpression.Operator.EQ, key.getAttributeValue("GROUP")));
                            } else if (resourceType.equals("DTRINGRP")) {
                                restrictionCriteriaList.add(new RestrictionCriteria("TRANGRP", FilterExpression.Operator.EQ, key.getAttributeValue("TRANGRP")));
                                restrictionCriteriaList.add(new RestrictionCriteria("TRANID", FilterExpression.Operator.EQ, key.getAttributeValue("TRANID")));
                            }
                            try {
                                ListMessageResponse response = this.getCMConnection().listResources(locationCriteria, allObjectCriteria, restrictionCriteriaList);
                                Map<String, String> attributes = response.getObjects().next();
                                name = attributes.get(CONNECTION_NAME);
                            }
                            catch (CMServerException e) {
                                throw this.createSMUpdateException(context, e, resourceType);
                            }
                        } else {
                            name = ((IPrimaryKey)context).getAttributeValue(CONNECTION_NAME);
                        }
                        objectCriteria = ObjectCriteria.newObjectCriteria(resourceType, name);
                    }
                }
                try {
                    this.getCMConnection().delete(locationCriteria, objectCriteria);
                }
                catch (CMServerException e) {
                    throw this.createSMUpdateException(context, e, resourceType);
                }
            }
            return new CMResponse(resourceType, 0);
        }
        return this.smConnection.delete(resourceType, context);
    }

    public SMConnectionResponse update(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        CMResponse response;
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"update", (Object)this, (Object)resourceType, (Object)context, (Object)record);
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext(context, resourceType);
        LocationCriteria locationCriteria = null;
        ObjectCriteria objectCriteria = null;
        Configuration configuration = null;
        if (resourceGroupContext != null) {
            objectCriteria = "RESGROUP".equals(resourceType) ? resourceGroupContext.getObjectCriteria(resourceType, resourceGroupContext.getResourceGroup()) : resourceGroupContext.getObjectCriteria(resourceType, this.getDefinitionName(record, (IFilteredContext)context));
            locationCriteria = resourceGroupContext.getLocationCriteria();
            configuration = resourceGroupContext.getConfiguration();
        } else if (context instanceof IPrimaryKey) {
            ICMDefinition cmDefinition;
            if ("RESGROUP".equals(resourceType)) {
                locationCriteria = LocationCriteria.newConfigurationLocationCriteria(CMSMConnection.getConfiguration(context).getName());
                objectCriteria = this.getResourceGroupObjectCriteria((IPrimaryKey)context);
            } else if ("APPLDEF".equals(resourceType)) {
                cmDefinition = CMUtils.getCMApplDefByListingWithKeyValues((IPrimaryKey)context);
                if (cmDefinition != null) {
                    configuration = cmDefinition.getConfiguration();
                    locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                    objectCriteria = ObjectCriteria.newObjectCriteria(resourceType, cmDefinition.getAttributes().get("ALIAS"));
                }
            } else if ("CSYSGRP".equals(resourceType)) {
                cmDefinition = CMSMConnection.getConfiguration(context).getDefinition("CSYSGRP", ((IPrimaryKey)context).getAttributeValue("GROUP"));
                if (cmDefinition != null) {
                    configuration = cmDefinition.getConfiguration();
                    locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
                    objectCriteria = ObjectCriteria.newObjectCriteriaForCSysGrp(cmDefinition.getAttributes().get("GROUP"));
                }
            } else {
                cmDefinition = this.getCMDefinitionByFindingFirstResourceGroup(resourceType, (IPrimaryKey)context);
                if (cmDefinition != null) {
                    locationCriteria = LocationCriteria.newConfigurationLocationCriteria(cmDefinition.getConfiguration().getName());
                    objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(cmDefinition.getResourceGroupName(), resourceType, cmDefinition.getName());
                    configuration = cmDefinition.getConfiguration();
                } else {
                    throw new SystemManagerConnectionException(Messages.getString("CMSMConnection.update.exception.noGroup"));
                }
            }
        }
        if (locationCriteria != null && objectCriteria != null) {
            try {
                Debug.event((Logger)logger, (String)CMSMConnection.class.getName(), (String)"update ", (Object)locationCriteria, (Object)objectCriteria);
                ObjectData objectData = ObjectData.newFrom(record);
                this.getCMConnection().alter(locationCriteria, objectCriteria, objectData);
                InquireMessageResponse messageResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                Map<String, String> attributes = messageResponse.getObject();
                ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
                response = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context)});
            }
            catch (CMServerException e) {
                if (e.isIntegrityTokenMismatch()) {
                    throw new SMUpdateConflictException();
                }
                throw this.createSMUpdateException(context, e, resourceType);
            }
        } else {
            response = null;
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"update", response);
        return response;
    }

    private SMUpdateException createSMUpdateException(IContext context, CMServerException e, String resourceType) {
        ICICSType cicsType = CICSTypes.findForResourceTableName((String)resourceType);
        ResourceDefinitionGroupContext cmContext = this.getResourceGroupContext(context, resourceType);
        Configuration configuration = null;
        if (cmContext != null) {
            configuration = cmContext.getConfiguration();
        } else if (context instanceof CSDContext) {
            configuration = ((CSDContext)context).getConfiguration();
        } else if (context instanceof ConfigurationContext) {
            configuration = ((ConfigurationContext)context).getConfiguration();
        } else {
            String configurationOrPlexName = context.getContext();
            configuration = ConfigurationManager.getCurrent().getCachedConfiguration(configurationOrPlexName);
            if (configuration == null) {
                configuration = CMSMConnection.getConfigurationForPlex(configurationOrPlexName);
            }
        }
        if (configuration instanceof CPSMConfiguration) {
            return this.createSMUpdateExceptionForCPSM(e, cicsType);
        }
        if (configuration instanceof CSDConfiguration) {
            return this.createSMUpdateExceptionForCSD(e, cicsType);
        }
        return this.createSMUpdateException(e, cicsType);
    }

    private String getDefinitionName(SMConnectionRecord record, IFilteredContext filteredContext) {
        return filteredContext.getAttributeValue(CONNECTION_NAME);
    }

    private SMUpdateException createSMUpdateExceptionForCPSM(CMServerException e, ICICSType cicsType) {
        SMUpdateException exception = new SMUpdateException((Exception)e);
        for (MessageResponse.ErrorObject errorObject : e.getMessageResponse().getErrorObjects()) {
            SMUpdateException.Error error = exception.createError();
            block1: for (MessageResponse.ErrorMessage errorMessage : errorObject.getErrorMessages()) {
                String message = errorMessage.getMessage();
                int attributeNumber = 1;
                String remainingString = message;
                while (true) {
                    String attributeName;
                    ICICSAttribute cicsAttribute;
                    String attributeToken;
                    int attributeIndex;
                    if ((attributeIndex = remainingString.indexOf(attributeToken = "ATT" + attributeNumber + "=")) == -1) {
                        if (attributeNumber == 1) {
                            int errorCodeInt = -1;
                            String errorCodeToken = "ErrorCode=";
                            int errorCodeIndex = (remainingString = remainingString.trim()).indexOf(errorCodeToken);
                            if (errorCodeIndex != -1) {
                                String errorCodeString = remainingString.substring(errorCodeIndex + errorCodeToken.length());
                                errorCodeInt = new Integer(errorCodeString);
                            }
                            if (errorCodeInt != -1) {
                                IResourceErrors resourceErrors = ErrorCodes.findResourceErrors((String)cicsType.getResourceTableName());
                                IResourceErrorCode errorMneumonic = resourceErrors.findErrorCodeByNumber(errorCodeInt);
                                error.setServerResponse(errorMneumonic.getLabel());
                                continue block1;
                            }
                            error.setServerResponse(remainingString.trim());
                            continue block1;
                        }
                        String attributeName2 = remainingString.trim();
                        cicsAttribute = cicsType.findAttributeByCicsName(attributeName2);
                        if (cicsAttribute == null) continue block1;
                        error.addAttributeName(attributeName2, cicsType.getResourceTableName());
                        continue block1;
                    }
                    if (attributeNumber > 1 && (cicsAttribute = cicsType.findAttributeByCicsName(attributeName = remainingString.substring(0, attributeIndex).trim())) != null) {
                        error.addAttributeName(attributeName, cicsType.getResourceTableName());
                    }
                    remainingString = remainingString.substring(attributeIndex + attributeToken.length());
                    remainingString.toString();
                    ++attributeNumber;
                }
            }
        }
        return exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SMConnectionResponse install(String resourceType, IFilteredContext definition, ConfigurationConnection[] targets, boolean quiesce, boolean discard) throws CMServerException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"install", (Object)this, (Object)resourceType, (Object)definition, (Object)targets);
        SMConnectionResponse response = null;
        ResourceDefinitionGroupContext resourceGroupContext = this.resolveResourceGroupContext(resourceType, definition);
        String name = this.resolveNameOrGroupName(resourceType, definition);
        if (resourceGroupContext != null) {
            Map<String, String> attributes;
            ObjectCriteria objectCriteria;
            ObjectCriteriaList objectCriteriaList = new ObjectCriteriaList();
            LocationCriteria locationCriteria = resourceGroupContext.getLocationCriteria();
            if (CSDGROUP.equals(resourceType)) {
                objectCriteriaList.addListElement(BLANK, "RESGROUP", name);
                objectCriteria = new ObjectCriteria();
                objectCriteria.setObjectType("RESGROUP");
                objectCriteria.setObjectGroup(name);
            } else {
                objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(resourceGroupContext.getResourceGroup(), resourceType, name);
                objectCriteriaList.addListElement(resourceGroupContext.getResourceGroup(), resourceType, name);
            }
            ProcessParms processParms = resourceGroupContext.getInstallProcessParms(targets, quiesce, discard);
            this.getCMConnection().install(locationCriteria, objectCriteriaList, processParms);
            if (CSDGROUP.equals(resourceType)) {
                ListMessageResponse listMessageResponse = this.getCMConnection().listResources(locationCriteria, objectCriteria, null);
                Iterator<Map<String, String>> iterator = listMessageResponse.getObjects();
                if (!iterator.hasNext()) throw new CMServerException(listMessageResponse);
                attributes = iterator.next();
            } else {
                InquireMessageResponse inquireMessageResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                attributes = inquireMessageResponse.getObject();
            }
            ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(resourceGroupContext.getConfiguration(), resourceType);
            return new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, (IContext)definition)});
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"install", response);
        return response;
    }

    private String resolveNameOrGroupName(String resourceType, IFilteredContext definition) {
        String name = definition.getAttributeValue(CONNECTION_NAME);
        if (name == null && "RESGROUP".equals(resourceType)) {
            name = definition.getAttributeValue("RESGROUP");
        }
        return name;
    }

    private ResourceDefinitionGroupContext resolveResourceGroupContext(String resourceType, IFilteredContext definition) {
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext((IContext)definition, resourceType);
        if (resourceGroupContext == null && definition instanceof IPrimaryKey) {
            resourceGroupContext = this.getResourceGroupContextFromKey((IPrimaryKey)definition, resourceType);
        }
        return resourceGroupContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SMConnectionResponse install(String resourceType, IFilteredContext definition, IScopedContext target) throws ConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"install", (Object)this, (Object)resourceType, (Object)definition, (Object)target);
        SMConnectionResponse response = null;
        ResourceDefinitionGroupContext resourceGroupContext = this.resolveResourceGroupContext(resourceType, definition);
        String name = this.resolveNameOrGroupName(resourceType, definition);
        if (resourceGroupContext != null) {
            try {
                Map<String, String> attributes;
                ObjectCriteria objectCriteria;
                ObjectCriteriaList objectCriteriaList = new ObjectCriteriaList();
                LocationCriteria locationCriteria = resourceGroupContext.getLocationCriteria();
                if (CSDGROUP.equals(resourceType)) {
                    objectCriteriaList.addListElement(resourceGroupContext.getResourceGroup(), "RESGROUP", name);
                    objectCriteria = new ObjectCriteria();
                    objectCriteria.setObjectType("RESGROUP");
                    objectCriteria.setObjectGroup(name);
                } else {
                    objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(resourceGroupContext.getResourceGroup(), resourceType, name);
                    objectCriteriaList.addListElement(resourceGroupContext.getResourceGroup(), resourceType, name);
                }
                Configuration configuration = resourceGroupContext.getConfiguration();
                if (configuration instanceof CSDConfiguration) {
                    target = this.getTargetForCSDConfiguration(target);
                }
                ProcessParms processParms = resourceGroupContext.getInstallProcessParms(target);
                this.getCMConnection().install(locationCriteria, objectCriteriaList, processParms);
                if (CSDGROUP.equals(resourceType)) {
                    ListMessageResponse listMessageResponse = this.getCMConnection().listResources(locationCriteria, objectCriteria, null);
                    Iterator<Map<String, String>> iterator = listMessageResponse.getObjects();
                    if (!iterator.hasNext()) throw new CMServerException(listMessageResponse);
                    attributes = iterator.next();
                } else {
                    InquireMessageResponse inquireMessageResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                    attributes = inquireMessageResponse.getObject();
                }
                ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
                return new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, (IContext)target)});
            }
            catch (CMServerException e) {
                if (!e.hasAdditionalInfo()) throw new ConnectionException((Exception)e);
                String attribute = e.getAdditionalAttribute();
                int feedbackErrorCode = e.getFeedbackErrorCode();
                int reason = e.getAdditionalReasonCode();
                int responseCode = e.getAdditionalResponseCode();
                throw new InstallException(e.getMessage(), responseCode, reason, feedbackErrorCode, attribute);
            }
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"install", response);
        return response;
    }

    private IScopedContext getTargetForCSDConfiguration(final IScopedContext target) {
        final String applid = CMSMConnection.getApplidForRegion(target.getScope());
        IScopedContext newtarget = new IScopedContext(){

            public String getContext() {
                return target.getContext();
            }

            public String getScope() {
                return applid;
            }
        };
        return newtarget;
    }

    private SMUpdateException createSMUpdateExceptionForCSD(CMServerException e, ICICSType cicsType) {
        SMUpdateException exception = new SMUpdateException((Exception)e);
        return exception;
    }

    private SMUpdateException createSMUpdateException(CMServerException e, ICICSType cicsType) {
        SMUpdateException exception = new SMUpdateException((Exception)e);
        for (MessageResponse.ErrorObject errorObject : e.getMessageResponse().getErrorObjects()) {
            SMUpdateException.Error error = exception.createError();
            for (MessageResponse.ErrorMessage errorMessage : errorObject.getErrorMessages()) {
                String message = errorMessage.getMessage();
                error.setServerResponse(message);
            }
        }
        return exception;
    }

    private void extractAttribute(SMConnectionRecord aRecord, Map<String, String> aMap, String attributeKey) {
        String attributeValue = aRecord.get(attributeKey);
        if (attributeValue != null) {
            aMap.put(attributeKey, attributeValue);
        }
    }

    public boolean isSecure() {
        return this.getConfiguration().getSecureHint();
    }

    public SMConnectionResponse add(String resourceType, IContext context, SystemManagerActions.CSDAddAction action) throws ConnectionException {
        return this.add(resourceType, context, action.getTargetCSDList(), action.getParameterValue("TO_CSDLIST"));
    }

    public SMConnectionResponse add(String resourceType, IContext context, SystemManagerActions.AddToResourceDescriptionAction action) throws ConnectionException {
        CMResponse response = null;
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext(context, resourceType);
        LocationCriteria locationCriteria = resourceGroupContext.getLocationCriteria();
        try {
            this.getCMConnection().add(locationCriteria, ObjectCriteria.newObjectCriteria("RESGROUP", resourceGroupContext.getResourceGroup()), ContainerData.newContainerDataForResourceList(action.getTargetResourceDescription()));
        }
        catch (CMServerException e) {
            e.printStackTrace();
        }
        try {
            InquireMessageResponse inquireResponse = this.getCMConnection().inquire(locationCriteria, ObjectCriteria.newObjectCriteria("RESDESC", action.getTargetResourceDescription()));
            Map<String, String> attributes = inquireResponse.getObject();
            ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(resourceGroupContext.getConfiguration(), resourceType);
            response = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context)});
        }
        catch (CMServerException e) {
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"add", (Object)e);
            throw new SystemManagerConnectionException(e.getMessage());
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    private SMConnectionResponse add(String resourceType, IContext context, String targetList, String csdTargetList) throws ConnectionException {
        Debug.enter((Logger)CMSMConnection.logger, (String)CMSMConnection.class.getName(), (String)"add", (Object)this);
        response = null;
        resourceGroupContext = this.getResourceGroupContext(context, resourceType);
        if (resourceGroupContext != null) {
            block15: {
                toCSDListTarget = csdTargetList;
                listTarget = null;
                lists = (ArrayList)resourceGroupContext.getConfiguration().getResourceLists().getResults();
                for (ResourceList rl : lists) {
                    if (!rl.getName().equals(toCSDListTarget)) continue;
                    listTarget = rl;
                    break;
                }
                locationCriteria = resourceGroupContext.getLocationCriteria();
                objectCriteria = ObjectCriteria.newObjectCriteria("RESDESC", targetList);
                objData = new ResourceListObjectData();
                objData.setAttribute("NAME", targetList);
                if (listTarget != null) {
                    groups = listTarget.getResourceGroups();
                    for (ResourceDefinitionGroup group : groups.getResults()) {
                        objData.addGroup(group.getName());
                    }
                }
                if (!objData.getGroups().contains(resourceGroupContext.getResourceGroup())) {
                    objData.addGroup(resourceGroupContext.getResourceGroup());
                }
                if (listTarget != null) {
                    try {
                        this.getCMConnection().inquire(locationCriteria, objectCriteria);
                    }
                    catch (CMServerException e) {
                        throw new SystemManagerConnectionException(e.getMessage());
                    }
                    try {
                        this.getCMConnection().alter(locationCriteria, objectCriteria, objData);
                    }
                    catch (CMServerException e) {
                        if (e.isDFHEDAPWarning()) ** GOTO lbl44
                        throw new SystemManagerConnectionException(e.getMessage());
                    }
                } else {
                    try {
                        this.getCMConnection().create(locationCriteria, objectCriteria, objData);
                    }
                    catch (CMServerException e) {
                        if (e.isDFHEDAPWarning()) break block15;
                        throw new SystemManagerConnectionException(e.getMessage());
                    }
                }
            }
            try {
                inquireResponse = this.getCMConnection().inquire(locationCriteria, objectCriteria);
                attributes = inquireResponse.getObject();
                overrides = ConfigurationOverrides.getOverrides(resourceGroupContext.getConfiguration(), resourceType);
                response = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, context)});
            }
            catch (CMServerException e) {
                Debug.event((Logger)CMSMConnection.logger, (String)this.getClass().getName(), (String)"add", (Object)e);
                throw new SystemManagerConnectionException(e.getMessage());
            }
        }
        Debug.exit((Logger)CMSMConnection.logger, (String)CMSMConnection.class.getName(), (String)"add");
        return response;
    }

    public SMConnectionResponse add(String resourceType, IFilteredContext definition, IFilteredContext group) throws SystemManagerConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"add", (Object)this, (Object)resourceType, (Object)definition, (Object)group);
        CMResponse response = null;
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext((IContext)definition, resourceType);
        if (resourceGroupContext == null && definition instanceof IPrimaryKey) {
            resourceGroupContext = this.getResourceGroupContextFromKey((IPrimaryKey)definition, resourceType);
        }
        if (resourceGroupContext != null) {
            try {
                Configuration configuration = resourceGroupContext.getConfiguration();
                ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(resourceGroupContext.getResourceGroup(), resourceType, definition.getAttributeValue(CONNECTION_NAME));
                LocationCriteria locationCriteria = resourceGroupContext.getLocationCriteria();
                ContainerData containerData = ContainerData.newContainerDataForResourceGroup(group.getAttributeValue("RESGROUP"));
                this.getCMConnection().add(locationCriteria, objectCriteria, containerData);
                InquireMessageResponse inquireMessageResponse = this.getCMConnection().inquire(locationCriteria, ObjectCriteria.newObjectCriteriaForGroup(group.getAttributeValue("RESGROUP"), resourceType, definition.getAttributeValue(CONNECTION_NAME)));
                Map<String, String> attributes = inquireMessageResponse.getObject();
                ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
                response = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, (IContext)resourceGroupContext)});
            }
            catch (CMServerException e) {
                if (e.isObjectAlreadyExists()) {
                    SystemManagerConnectionException exception = new SystemManagerConnectionException(1038, 1361, 4, CONNECTION_NAME);
                    throw exception;
                }
                throw new SystemManagerConnectionException((Exception)e);
            }
        }
        try {
            Configuration configuration = CMSMConnection.getConfiguration((IContext)definition);
            ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteria(resourceType, definition.getAttributeValue(CONNECTION_NAME));
            objectCriteria.setObjectVersion(definition.getAttributeValue("DEFVER"));
            objectCriteria.setObjectGroup(BLANK);
            LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(configuration.getName());
            ContainerData containerData = ContainerData.newContainerDataForResourceGroup(group.getAttributeValue("RESGROUP"));
            this.getCMConnection().add(locationCriteria, objectCriteria, containerData);
            InquireMessageResponse inquireMessageResponse = this.getCMConnection().inquire(locationCriteria, ObjectCriteria.newObjectCriteriaForGroup(group.getAttributeValue("RESGROUP"), resourceType, definition.getAttributeValue(CONNECTION_NAME)));
            Map<String, String> attributes = inquireMessageResponse.getObject();
            resourceGroupContext = this.getResourceGroupContextFromKey((IPrimaryKey)definition, resourceType);
            ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(configuration, resourceType);
            response = new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, (IContext)resourceGroupContext)});
        }
        catch (CMServerException e) {
            if (e.isObjectAlreadyExists()) {
                SystemManagerConnectionException exception = new SystemManagerConnectionException(1038, 1361, 4, CONNECTION_NAME);
                throw exception;
            }
            throw new SystemManagerConnectionException((Exception)e);
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"add");
        return response;
    }

    private ResourceDefinitionGroupContext getResourceGroupContextFromKey(IPrimaryKey definition, String resourceType) {
        ICMDefinition cmDefinition = this.getCMDefinitionByFindingFirstResourceGroup(resourceType, definition);
        if (cmDefinition != null) {
            return (ResourceDefinitionGroupContext)cmDefinition.getResourceGroup().getIContext();
        }
        return null;
    }

    public SMConnectionResponse remove(String resourceType, IFilteredContext definition, IFilteredContext group) throws SystemManagerConnectionException {
        Debug.enter((Logger)logger, (String)CMSMConnection.class.getName(), (String)"remove", (Object)this, (Object)resourceType, (Object)definition, (Object)group);
        SMConnectionResponse response = null;
        ResourceDefinitionGroupContext resourceGroupContext = this.getResourceGroupContext((IContext)definition, resourceType);
        if (resourceGroupContext == null) {
            resourceGroupContext = this.getResourceGroupContextFromKey((IPrimaryKey)definition, resourceType);
        }
        if (resourceGroupContext != null) {
            try {
                ContainerData containerData;
                ObjectCriteria objectCriteria;
                LocationCriteria locationCriteria = resourceGroupContext.getLocationCriteria();
                if (resourceType.equals("RESGROUP")) {
                    objectCriteria = ObjectCriteria.newObjectCriteria(resourceType, definition.getAttributeValue("RESGROUP"));
                    containerData = ContainerData.newContainerDataForResourceList(group.getAttributeValue("RESDESC"));
                    this.getCMConnection().remove(locationCriteria, objectCriteria, containerData);
                } else {
                    objectCriteria = ObjectCriteria.newObjectCriteria(resourceType, definition.getAttributeValue(CONNECTION_NAME));
                    containerData = ContainerData.newContainerDataForResourceGroup(group.getAttributeValue("RESGROUP"));
                    this.getCMConnection().remove(locationCriteria, objectCriteria, containerData);
                }
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("OBJNAME", definition.getAttributeValue(CONNECTION_NAME));
                attributes.put("OBJTYPE", resourceType);
                ConfigurationOverrides overrides = ConfigurationOverrides.getOverrides(resourceGroupContext.getConfiguration(), resourceType);
                return new CMResponse(resourceType, new CMConnectionRecord[]{new CMConnectionRecord(attributes, (CMConnectionRecord.Overrides)overrides, (IContext)group)});
            }
            catch (CMServerException e) {
                throw new SystemManagerConnectionException((Exception)e);
            }
        }
        Debug.exit((Logger)logger, (String)CMSMConnection.class.getName(), (String)"remove");
        return response;
    }

    private boolean isCMSupportedResource(String resourceType) {
        return IResourceTables.Helper.isCICSDefinition((String)resourceType) || IResourceTables.Helper.isCPSMDefinition((String)resourceType) || IResourceTables.Helper.isCPSMConfigurationDefinition((String)resourceType) || IResourceTables.Helper.isCSDDefinition((String)resourceType);
    }

    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        Configuration configuration;
        String attributeName;
        if (context instanceof IComplexFilteredContext) {
            if (this.isCMSupportedResource(resourceType)) {
                return false;
            }
            return this.smConnection != null && this.smConnection.checkOperation(resourceType, context, operation);
        }
        if (context instanceof CSDContext && operation instanceof ICICSGetAction && "DEFVER".equals(attributeName = ((ICICSGetAction)operation).getAttributeName())) {
            return false;
        }
        if (operation instanceof ICICSAction && ((ICICSAction)operation).getActionName() == "INSTALL" && (configuration = CMSMConnection.getConfiguration(context)) != null && configuration instanceof CSDConfiguration) {
            String scope;
            InstallAction action;
            IScopedContext target;
            CSDConfiguration csdConfiguration = (CSDConfiguration)configuration;
            List<ConfigurationConnection> connections = csdConfiguration.getConnections();
            String applid = BLANK;
            boolean targetAquired = false;
            if (operation instanceof InstallAction && (target = (action = (InstallAction)operation).getTarget()) != null && StringUtil.hasContent((String)(applid = CMSMConnection.getApplidForRegion(scope = target.getScope())))) {
                targetAquired = true;
            }
            if (targetAquired) {
                return this.isActiveConnectionToRegion(connections, applid);
            }
            return this.isAtLeastOneActiveConnection(connections);
        }
        if (resourceType.equals(CSDGROUP) && operation instanceof ICICSAction && (((ICICSAction)operation).getActionName().matches("REMOVE") || ((ICICSAction)operation).getActionName().matches("INSTALL") || ((ICICSAction)operation).getActionName().matches("CSDLOCK") || ((ICICSAction)operation).getActionName().matches("CSDUNLOCK"))) {
            return false;
        }
        if (resourceType.equals("RESDESC") && operation instanceof ICICSOperation && (ICICSOperation.OperationType.DELETE.equals((Object)operation.getOperationType()) || ICICSOperation.OperationType.CREATE.equals((Object)operation.getOperationType()))) {
            return false;
        }
        return super.checkOperation(resourceType, context, operation);
    }

    private boolean isConfigurationForRegion(CSDConfiguration csdConfiguration, String applid) {
        return this.isActiveConnectionToRegion(csdConfiguration.getConnections(), applid);
    }

    private boolean isActiveConnectionToRegion(List<ConfigurationConnection> connections, String applid) {
        if (applid == null) {
            return false;
        }
        for (ConfigurationConnection configurationConnection : connections) {
            if (!applid.equals(configurationConnection.getApplid()) || !configurationConnection.isAcquired()) continue;
            return true;
        }
        return false;
    }

    private boolean isAtLeastOneActiveConnection(List<ConfigurationConnection> connections) {
        boolean result = false;
        for (ConfigurationConnection configurationConnection : connections) {
            if (!configurationConnection.isAcquired()) continue;
            result = true;
            break;
        }
        return result;
    }

    private static String getApplidForRegion(String scope) {
        return regionNameToApplid.get(scope);
    }

    public boolean checkOperationForModelVersion(ICICSOperation operation, ICICSType type) {
        if (operation instanceof ICICSGetAction && type.isDefinition()) {
            ICICSGetAction action = (ICICSGetAction)operation;
            action.getAttributeName();
            return type.getInterfaceType().equals(ICSDListDefinition.class) || type.getInterfaceType().equals(ICSDGroupDefinition.class) || type.getInterfaceType().equals(IResourceDescriptionDefinition.class) || type.getInterfaceType().equals(IResourceGroupDefinition.class);
        }
        return true;
    }

    @Override
    public List<IRepository> getRepositories() {
        IFilteredCollection<Configuration> configurations = ConfigurationManager.getCurrent().getConfigurations();
        ArrayList<IRepository> repositories = new ArrayList<IRepository>();
        for (Configuration configuration : configurations) {
            if (!(configuration instanceof CPSMConfiguration) && !(configuration instanceof CSDConfiguration)) continue;
            repositories.add(configuration.getRepository());
        }
        return repositories;
    }
}

