/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.DateRange;
import com.ibm.cics.cm.model.HistoryEntry;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class History
extends CMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String userid;
    private Date displayCreationTime;
    private Date displayChangeTime;
    private String objectInstance;
    private String command;
    private Map<String, String> fullAttributes;
    public Map<String, String> beforeAttributes;
    private HistoryEntry historyEntry;
    private IHistoryProvider historyProvider;
    private String resourceGroup;
    private String type;
    private Date changeTime;
    private Date creationTime;
    private String scheme;
    private String changePackageID;
    private String configuration;

    public History(IHistoryProvider historyProvider, Map<String, String> attributes) {
        super(attributes);
        this.historyProvider = historyProvider;
        this.setName(attributes.get("OBJNAME"));
        this.type = attributes.get("OBJTYPE");
        this.resourceGroup = attributes.get("OBJGROUP");
        this.objectInstance = attributes.get("OBJECTINSTANCE");
        this.userid = attributes.get("USERID");
        this.command = attributes.get("API_COMMAND");
        this.displayCreationTime = CMUtilities.asDatayyyyMMdd(attributes.get("CREATETIME"));
        this.displayChangeTime = CMUtilities.asDatayyyyMMdd(attributes.get("A_CHANGETIME") == null ? attributes.get("CREATETIME") : attributes.get("A_CHANGETIME"));
        this.scheme = attributes.get("SCHEME");
        this.changePackageID = attributes.get("CPID");
        this.configuration = attributes.get("CCONFIG");
        this.creationTime = CMUtilities.asDatayyyyMMddHHmmssSS(attributes.get("CREATETIME"));
        this.changeTime = CMUtilities.asDatayyyyMMddHHmmssSS(attributes.get("A_CHANGETIME") == null ? attributes.get("CREATETIME") : attributes.get("A_CHANGETIME"));
    }

    public String getCommand() {
        return this.command;
    }

    public Date getDisplayChangeTime() {
        return this.displayChangeTime == null ? this.getHistoryEntry().getDisplayChangeTime() : this.displayChangeTime;
    }

    public Date getChangeTime() {
        return this.changeTime == null ? this.getHistoryEntry().getChangeTime() : this.changeTime;
    }

    public Date getCreationTime() {
        return this.displayCreationTime;
    }

    public Date getFullCreationTime() {
        return this.creationTime;
    }

    public String getChangedBy() {
        return this.userid;
    }

    public HistoryEntry getHistoryEntry() {
        if (this.historyEntry == null) {
            this.historyEntry = ConfigurationManager.getCurrent().inquireHistory(LocationCriteria.newJournalLocationCriteria(), ObjectCriteria.newJournalInstance(this.objectInstance));
        }
        return this.historyEntry;
    }

    public static SortedSet<History> asDescendingChangeDate(List<History> aList) {
        SortedSet<History> objects = History.getDescendingSortedHistorySet();
        objects.addAll(aList);
        return objects;
    }

    public static List<History> asAscending(List<History> aList, final String attribute) {
        SortedSet<History> asDescendingChangeDate = History.asDescendingChangeDate(aList);
        ArrayList<History> newList = new ArrayList<History>();
        newList.addAll(asDescendingChangeDate);
        Collections.sort(newList, new Comparator<History>(){

            @Override
            public int compare(History firstHistory, History secondHistory) {
                int compare = firstHistory.getAttributes().get(attribute).compareTo(secondHistory.getAttributes().get(attribute));
                if (compare == 0 && "TYPE".equals(attribute)) {
                    compare = firstHistory.getAttributes().get("OBJTYPE").compareTo(secondHistory.getAttributes().get("OBJTYPE"));
                }
                return compare;
            }
        });
        return newList;
    }

    public static List<History> asDescending(List<History> aList, final String attribute) {
        SortedSet<History> asDescendingChangeDate = History.asDescendingChangeDate(aList);
        ArrayList<History> newList = new ArrayList<History>();
        newList.addAll(asDescendingChangeDate);
        Collections.sort(newList, new Comparator<History>(){

            @Override
            public int compare(History firstHistory, History secondHistory) {
                int compare = secondHistory.getAttributes().get(attribute).compareTo(firstHistory.getAttributes().get(attribute));
                if (compare == 0 && "TYPE".equals(attribute)) {
                    compare = secondHistory.getAttributes().get("OBJTYPE").compareTo(firstHistory.getAttributes().get("OBJTYPE"));
                }
                return compare;
            }
        });
        return newList;
    }

    public static SortedSet<History> asAscendingChangeDate(List<History> aList) {
        SortedSet<History> objects = History.getAscendingSortedHistorySet();
        objects.addAll(aList);
        return objects;
    }

    public static SortedSet<History> getAscendingSortedHistorySet() {
        return new TreeSet<History>(new Comparator<History>(){

            @Override
            public int compare(History firstHistory, History secondHistory) {
                return firstHistory.getFullCreationTime().compareTo(secondHistory.getFullCreationTime());
            }
        });
    }

    public static SortedSet<History> getDescendingSortedHistorySet() {
        return new TreeSet<History>(new Comparator<History>(){

            @Override
            public int compare(History firstHistory, History secondHistory) {
                return secondHistory.getFullCreationTime().compareTo(firstHistory.getFullCreationTime());
            }
        });
    }

    public static Map<DateRange, Collection<History>> groupByDate(Collection<History> currentSortedHistory) {
        TreeMap<DateRange, Collection<History>> result = new TreeMap<DateRange, Collection<History>>();
        for (History history : currentSortedHistory) {
            DateRange dateRange = DateRange.newFrom(history.getCreationTime());
            Collection<History> historyCollection = result.get((Object)dateRange);
            if (historyCollection == null) {
                historyCollection = new ArrayList<History>();
                result.put(dateRange, historyCollection);
            }
            historyCollection.add(history);
        }
        return result;
    }

    public Map<String, String> getAttributesBeforeChange() {
        if (this.getCommand().equals("CREATE") || this.getCommand().equals("MIGRATE") || this.getCommand().equals("COPY") || this.getHistoryEntry().getBeforeAttributes() == null && this.getCommand().equals("RENAME")) {
            return this.getHistoryEntry().getAfterAttributes();
        }
        return this.getHistoryEntry().getBeforeAttributes();
    }

    public IHistoryProvider getProvider() {
        return this.historyProvider;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String getType() {
        return this.type;
    }

    public String getPackage() {
        return this.changePackageID;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getConfiguration() {
        return this.configuration;
    }
}

