/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.FilterAttribute;
import com.ibm.cics.cm.model.IllegalAttributeException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HistoryFilterAttribute
extends FilterAttribute {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String displayName;
    private final String descriptiveName;
    private final String apiName;
    private String[] values;
    private Class type;
    private Map<String, String> valueToDisplayMapping;
    private Map<String, String> displayToValueMap;
    private String[] displayValues;

    public HistoryFilterAttribute(String apiName, String descriptiveName, String displayName, Class type) {
        this.apiName = apiName;
        this.descriptiveName = descriptiveName;
        this.displayName = displayName;
        this.type = type;
    }

    @Override
    public String getAPIName() {
        return this.apiName;
    }

    @Override
    public String getDescriptiveName() {
        return this.descriptiveName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDisplayName(Object value) {
        String display = null;
        if (this.valueToDisplayMapping != null) {
            display = this.valueToDisplayMapping.get(value);
        }
        if (display != null) {
            return display;
        }
        return value == null ? null : value.toString();
    }

    @Override
    public String getErrorMessage(String textValue) {
        return null;
    }

    @Override
    public int getMaximum() {
        return 0;
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public String[] getValues() {
        return this.values;
    }

    @Override
    public void validate(String textValue) throws IllegalAttributeException {
    }

    public void setValueMapping(Map<String, String> displayToValueMap) {
        if (displayToValueMap == null) {
            return;
        }
        this.displayToValueMap = displayToValueMap;
        this.valueToDisplayMapping = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : displayToValueMap.entrySet()) {
            this.valueToDisplayMapping.put(entry.getValue(), entry.getKey());
        }
        this.values = displayToValueMap.values().toArray(new String[displayToValueMap.values().size()]);
        this.displayValues = displayToValueMap.keySet().toArray(new String[displayToValueMap.keySet().size()]);
        Arrays.sort(this.displayValues);
    }

    public String toString() {
        return this.apiName;
    }

    public String getValue(String selectedValue) {
        if (this.displayToValueMap != null) {
            return this.displayToValueMap.get(selectedValue);
        }
        return selectedValue;
    }

    public String[] getDisplayValues() {
        return this.displayValues;
    }
}

