/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.CMUtilities;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.History;
import com.ibm.cics.cm.model.HistoryProviderDelegate;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.IHistoryCompatible;
import com.ibm.cics.cm.model.IHistoryProvider;
import com.ibm.cics.cm.model.ResourceDefinitionGroupContext;
import com.ibm.cics.cm.model.ResourceList;
import com.ibm.cics.cm.model.definitions.ResourceDefinition;
import com.ibm.cics.cm.model.definitions.ResourceDefinitionFactory;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.IRestrictionCriteria;
import com.ibm.cics.cm.model.runtime.JournalCriteria;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.sm.comm.IContext;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ResourceDefinitionGroup
extends CMObject
implements IContextProvider,
IHistoryCompatible {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Configuration configuration;
    private ResourceList resourceList;
    private HistoryProviderDelegate historyProviderDelegate;
    private Date changeTime;
    private ResourceDefinitionGroupContext resourceDefinitionGroupContext;
    private String checksum;
    boolean exists = false;

    public ResourceDefinitionGroup(Configuration aConfiguration, String name) {
        super(ResourceDefinitionGroup.getDefaultMap(name));
        this.setName(name);
        this.configuration = aConfiguration;
    }

    static Map<String, String> getDefaultMap(String name) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("NAME", name);
        return result;
    }

    public boolean exists() {
        return this.exists;
    }

    public ResourceDefinitionGroup(Configuration aConfiguration, Map<String, String> anAttributesMap) {
        super(anAttributesMap);
        this.exists = true;
        this.setName(anAttributesMap.get("RESGROUP"));
        this.configuration = aConfiguration;
        this.checksum = anAttributesMap.get("HASHINGVALUE");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        Date fromDate = calendar.getTime();
        try {
            if (anAttributesMap.get("CHANGETIME") != null) {
                this.changeTime = CMUtilities.getyyyyMMddDateFormat().parse(anAttributesMap.get("CHANGETIME"));
            }
        }
        catch (ParseException parseException) {
        }
        catch (Exception exception) {}
        this.historyProviderDelegate = new HistoryProviderDelegate(this){

            @Override
            protected JournalCriteria getJournalCriteria() {
                return JournalCriteria.newJournalCriteriaForResourceGroup(ResourceDefinitionGroup.this.configuration.getName(), this.getName());
            }

            @Override
            protected JournalCriteria getJournalEventCriteria() {
                return JournalCriteria.newJournalEventCriteriaForResourceGroup(ResourceDefinitionGroup.this.configuration.getName(), this.getName());
            }
        };
        this.historyProviderDelegate.setFromDate(fromDate);
    }

    public ResourceDefinitionGroup(ResourceList aResourceList, Map<String, String> anAttributesMap) {
        this(aResourceList.getConfiguration(), anAttributesMap);
        this.resourceList = aResourceList;
    }

    public IFilteredCollection<ICMDefinition> getDefinitions() {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(this.getName());
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ResourceDefinitionGroup.this.logger, (String)this.getClass().getName(), (String)"getDefinitions", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(ResourceDefinitionFactory.getObject(ResourceDefinitionGroup.this.configuration, attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    public IFilteredCollection<ICMDefinition> getDefinitionsWithChecksum(String checksumType) {
        if (!ResourceDefinition.getSupportedChecksums().contains(checksumType)) {
            checksumType = "NONE";
        }
        final String validatedChecksumType = checksumType;
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(this.getName());
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getListWithChecksum(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList, validatedChecksumType);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ResourceDefinitionGroup.this.logger, (String)this.getClass().getName(), (String)"getDefinitionsWithChecksum", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(ResourceDefinitionFactory.getObject(ResourceDefinitionGroup.this.configuration, attributes, false));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    public IFilteredCollection<ResourceList> getAssociatedLists() {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(this.getName(), "RESINDSC");
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ResourceDefinitionGroup.this.logger, (String)this.getClass().getName(), (String)"getAssociatedLists", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(new ResourceList(ResourceDefinitionGroup.this.configuration, attributes));
                    }
                    return objects;
                }
                return null;
            }
        });
        return definitions;
    }

    public IContext getIContext() {
        if (this.resourceDefinitionGroupContext == null) {
            this.resourceDefinitionGroupContext = new ResourceDefinitionGroupContext(this);
        }
        return this.resourceDefinitionGroupContext;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ICMDefinition getDefinition(String type, String name) {
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup(this.getName(), type, name);
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
        ICMObject cmObject = ConfigurationManager.getCurrent().inquire(locationCriteria, objectCriteria, new ConfigurationManager.CMObjectFactory(){

            @Override
            public ICMDefinition createObject(Map<String, String> attributes) {
                return (ICMDefinition)ResourceDefinitionFactory.getObject(ResourceDefinitionGroup.this.getConfiguration(), attributes, false);
            }
        });
        return (ICMDefinition)cmObject;
    }

    public boolean equals(Object o) {
        return o instanceof ResourceDefinitionGroup && ((ResourceDefinitionGroup)o).getName().equals(this.getName());
    }

    @Override
    public Date getChangeTime() {
        return this.changeTime;
    }

    public IFilteredCollection<History> getHistory(List<IRestrictionCriteria> filters) {
        return this.historyProviderDelegate.getHistory(filters);
    }

    public Date getHistoryFromDate() {
        return this.historyProviderDelegate.getHistoryFromDate();
    }

    public Date getHistoryToDate() {
        return this.historyProviderDelegate.getHistoryToDate();
    }

    public void setToDate(Date toDate) {
        this.historyProviderDelegate.setToDate(toDate);
    }

    public void setFromDate(Date fromDate) {
        this.historyProviderDelegate.setFromDate(fromDate);
    }

    public String getHistoryFromDateAsDisplay() {
        return this.historyProviderDelegate.getHistoryFromDateAsDisplay();
    }

    public String getHistoryToDateAsDisplay() {
        return this.historyProviderDelegate.getHistoryToDateAsDisplay();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public static ArrayList<String> getSupportedChecksums() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("NONE");
        results.add("PARTIAL");
        results.add("FULL");
        results.add("CRITICAL");
        results.add("NAME");
        return results;
    }

    public HistoryProviderDelegate getHistoryProviderDelegate() {
        return this.historyProviderDelegate;
    }

    @Override
    public IHistoryProvider getIHistoryProvider() {
        return this.historyProviderDelegate;
    }

    public String getChecksum(String checksumType) {
        if (this.checksum == null) {
            ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForGroup("*", "RESGROUP", this.getName());
            LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
            ListMessageResponse response = null;
            try {
                response = ConfigurationManager.getCurrent().getListWithChecksum(locationCriteria, objectCriteria, checksumType);
            }
            catch (CMServerListException e) {
                Debug.warning((Logger)this.logger, (String)this.getClass().getName(), (String)"getChecksum", (String)"CM Server List Exception", (Throwable)e);
            }
            if (response != null) {
                new ArrayList();
                Iterator<Map<String, String>> iterator = response.getObjects();
                while (iterator.hasNext()) {
                    Map<String, String> attributes = iterator.next();
                    this.checksum = attributes.get("HASHINGVALUE");
                }
            }
        }
        return this.checksum;
    }
}

