/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMContext;
import com.ibm.cics.cm.model.CPSMConfiguration;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.ConfigurationConnection;
import com.ibm.cics.cm.model.ConfigurationContext;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ProcessParms;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.context.IGroupContext;

public class ResourceDefinitionGroupContext
extends CMContext
implements IGroupContext {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ResourceDefinitionGroup resourceGroup;
    private ObjectCriteria objectCriteria;
    private String resourceGroupName;
    private String plexName;
    private IContext parentContext;

    public ResourceDefinitionGroupContext(Configuration aConfiguration, String aResourceGroupName) {
        this.resourceGroupName = aResourceGroupName;
        this.setConfiguration(aConfiguration);
        if (aConfiguration instanceof CPSMConfiguration) {
            this.plexName = ((CPSMConfiguration)aConfiguration).getCPSMContext();
        }
        this.parentContext = ConfigurationContext.newFrom(aConfiguration);
    }

    public ResourceDefinitionGroupContext(ResourceDefinitionGroup aResourceGroup) {
        this.resourceGroup = aResourceGroup;
        this.resourceGroupName = aResourceGroup.getName();
        Configuration configuration = aResourceGroup.getConfiguration();
        this.setConfiguration(configuration);
        if (configuration instanceof CPSMConfiguration) {
            this.plexName = ((CPSMConfiguration)configuration).getCPSMContext();
        }
        this.parentContext = ConfigurationContext.newFrom(configuration);
    }

    public ResourceDefinitionGroup getResourceDefinitionGroup() {
        if (this.resourceGroup == null) {
            this.resourceGroup = new ResourceDefinitionGroup(this.getConfiguration(), this.resourceGroupName);
        }
        return this.resourceGroup;
    }

    private String getName() {
        return this.resourceGroup == null ? this.resourceGroupName : this.resourceGroup.getName();
    }

    public ObjectCriteria getObjectCriteria(String resourceType) {
        return ObjectCriteria.newObjectCriteriaForGroup(this.getName(), resourceType);
    }

    public ObjectCriteria getObjectCriteria(String resourceType, String resourceName) {
        if (!"RESGROUP".equals(resourceType)) {
            return ObjectCriteria.newObjectCriteriaForGroup(this.getName(), resourceType, resourceName);
        }
        return ObjectCriteria.newObjectCriteria(resourceType, this.getName());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ResourceGroupContext(");
        buffer.append(this.getConfigurationName());
        buffer.append(" - ");
        buffer.append(this.getName());
        buffer.append(")");
        return buffer.toString();
    }

    public String getResourceGroup() {
        return this.resourceGroupName;
    }

    public ProcessParms getInstallProcessParms(IScopedContext target) {
        return this.getInstallProcessParms(target, true, true);
    }

    public ProcessParms getInstallProcessParms(IScopedContext target, boolean quiesce, boolean discard) {
        return this.getConfiguration().getInstallProcessParms(target, quiesce, discard);
    }

    public ProcessParms getInstallProcessParms(ConfigurationConnection[] targets, boolean quiesce, boolean discard) {
        return this.getConfiguration().getInstallProcessParms(targets, quiesce, discard);
    }

    public String getPlexName() {
        return this.plexName;
    }

    public IContext getParentContext() {
        return this.parentContext;
    }
}

