/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.cm.model;

import com.ibm.cics.cm.model.CMObject;
import com.ibm.cics.cm.model.Configuration;
import com.ibm.cics.cm.model.FilteredCollection;
import com.ibm.cics.cm.model.ICMDefinition;
import com.ibm.cics.cm.model.ICMObject;
import com.ibm.cics.cm.model.IFilteredCollection;
import com.ibm.cics.cm.model.MutableResourceList;
import com.ibm.cics.cm.model.ResourceDefinitionGroup;
import com.ibm.cics.cm.model.runtime.CMListFactory;
import com.ibm.cics.cm.model.runtime.CMServerException;
import com.ibm.cics.cm.model.runtime.CMServerListException;
import com.ibm.cics.cm.model.runtime.ConfigurationManager;
import com.ibm.cics.cm.model.runtime.ContainerData;
import com.ibm.cics.cm.model.runtime.InquireMessageResponse;
import com.ibm.cics.cm.model.runtime.ListMessageResponse;
import com.ibm.cics.cm.model.runtime.LocationCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteria;
import com.ibm.cics.cm.model.runtime.ObjectCriteriaList;
import com.ibm.cics.cm.model.runtime.ResourceListObjectData;
import com.ibm.cics.common.util.Debug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ResourceList
extends CMObject {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5697-CIC (c) Copyright IBM Corp. 2011, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Configuration configuration;
    private String lastIntegrityToken;

    public String getLastIntegrityToken() {
        return this.lastIntegrityToken;
    }

    private void setLastIntegrityToken(String lastIntegrityToken) {
        this.lastIntegrityToken = lastIntegrityToken;
    }

    public ResourceList(Configuration aConfiguration, Map<String, String> anAttributesMap) {
        super(anAttributesMap);
        this.setName(anAttributesMap.get("RESDESC"));
        if (anAttributesMap.containsKey("INTEGRITYTOKEN")) {
            this.setLastIntegrityToken(anAttributesMap.get("INTEGRITYTOKEN"));
        }
        this.configuration = aConfiguration;
    }

    public void addResourceGroups(List<String> resourceGroupNames) throws CMServerException {
        ConfigurationManager configurationManager = ConfigurationManager.getCurrent();
        if (resourceGroupNames.isEmpty()) {
            return;
        }
        if (this.configuration.getAttributes().get("FILETYPE").equals("CSD")) {
            throw new UnsupportedOperationException("This operation is only supported on CPSM configurations.");
        }
        if (resourceGroupNames.size() == 1) {
            configurationManager.add(LocationCriteria.newConfigurationLocationCriteria(this.configuration.getName()), ObjectCriteria.newObjectCriteria("RESGROUP", resourceGroupNames.get(0)), ContainerData.newContainerDataForResourceList(this.getName()));
        } else {
            ObjectCriteriaList criteriaList = ObjectCriteriaList.newObjectCriteriaList();
            for (String groupName : resourceGroupNames) {
                criteriaList.addListElement(null, "RESGROUP", groupName);
            }
            configurationManager.add(LocationCriteria.newConfigurationLocationCriteria(this.configuration.getName()), criteriaList, ContainerData.newContainerDataForResourceList(this.getName()), null);
        }
    }

    public MutableResourceList getMutableList() throws CMServerException {
        if (!this.configuration.getAttributes().get("FILETYPE").equals("CSD")) {
            throw new UnsupportedOperationException("This operation is only supported on CSD configurations.");
        }
        InquireMessageResponse response = ConfigurationManager.getCurrent().getConnection().inquire(LocationCriteria.newConfigurationLocationCriteria(this.configuration.getName()), ObjectCriteria.newObjectCriteria("RESDESC", this.getName()));
        if (response != null) {
            return new MutableResourceList(ConfigurationManager.getCurrent(), new ResourceList(this.configuration, response.getObject()), response.getRGroupObjects());
        }
        return null;
    }

    public void removeResourceGroups(List<String> resourceGroupNames) throws CMServerException {
        ConfigurationManager configurationManager = ConfigurationManager.getCurrent();
        if (this.configuration.getAttributes().get("FILETYPE").equals("CSD")) {
            ResourceListObjectData delObjData = new ResourceListObjectData();
            delObjData.setAttribute("NAME", this.getName());
            for (ResourceDefinitionGroup group : this.getResourceGroups().getResults()) {
                if (resourceGroupNames.contains(group.getName())) continue;
                delObjData.addGroup(group.getName());
            }
            configurationManager.update(LocationCriteria.newConfigurationLocationCriteria(this.configuration.getName()), ObjectCriteria.newObjectCriteria("RESDESC", this.getName()), delObjData, null);
        } else {
            ObjectCriteriaList objList = new ObjectCriteriaList();
            for (String name : resourceGroupNames) {
                objList.addListElement(null, "RESGROUP", name);
            }
            configurationManager.remove(LocationCriteria.newConfigurationLocationCriteria(this.configuration.getName()), objList, ContainerData.newContainerDataForResourceList(this.getName()));
        }
    }

    public IFilteredCollection<ResourceDefinitionGroup> getResourceGroups() {
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
        ObjectCriteria objectCriteria = ObjectCriteria.newGroupCriteriaForList(this.getName());
        return new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getList(this.locationCriteria, this.objectCriteria, this.restrictionCriteriaList);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ResourceList.this.logger, (String)this.getClass().getName(), (String)"getResourceGroups", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(new ResourceDefinitionGroup(ResourceList.this, attributes));
                    }
                    if (response.integrityToken != null) {
                        ResourceList.this.setLastIntegrityToken(response.integrityToken);
                    }
                    return objects;
                }
                return CMObject.EMPTY_LIST;
            }
        });
    }

    public IFilteredCollection<ResourceDefinitionGroup> getResourceGroupsWithChecksum(String checksumType) {
        if (!ResourceDefinitionGroup.getSupportedChecksums().contains(checksumType)) {
            checksumType = "NONE";
        }
        final String validatedChecksumType = checksumType;
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
        ObjectCriteria objectCriteria = ObjectCriteria.newGroupCriteriaForList(this.getName());
        return new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ListMessageResponse response = null;
                try {
                    response = ConfigurationManager.getCurrent().getListWithChecksum(this.locationCriteria, this.objectCriteria, validatedChecksumType);
                }
                catch (CMServerListException e) {
                    Debug.warning((Logger)ResourceList.this.logger, (String)this.getClass().getName(), (String)"getResourceGroupsWithChecksum", (String)"CM Server List Exception", (Throwable)e);
                }
                if (response != null) {
                    ArrayList<ICMObject> objects = new ArrayList<ICMObject>();
                    Iterator<Map<String, String>> iterator = response.getObjects();
                    while (iterator.hasNext()) {
                        Map<String, String> attributes = iterator.next();
                        objects.add(new ResourceDefinitionGroup(ResourceList.this, attributes));
                    }
                    ResourceList.this.setLastIntegrityToken(response.integrityToken);
                    return objects;
                }
                return CMObject.EMPTY_LIST;
            }
        });
    }

    public ResourceDefinitionGroup getResourceGroup(String aGroupName) {
        IFilteredCollection<ResourceDefinitionGroup> resourceGroups = this.getResourceGroups();
        resourceGroups.setObjectName(aGroupName);
        return resourceGroups.get(0);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public IFilteredCollection<ICMDefinition> getDefinitions() {
        LocationCriteria locationCriteria = LocationCriteria.newConfigurationLocationCriteria(this.getConfiguration().getName());
        ObjectCriteria objectCriteria = ObjectCriteria.newObjectCriteriaForList();
        FilteredCollection definitions = new FilteredCollection(new CMListFactory(locationCriteria, objectCriteria){

            @Override
            public List<ICMObject> getResults() {
                ArrayList<ICMObject> results = new ArrayList<ICMObject>();
                IFilteredCollection<ResourceDefinitionGroup> resourceGroups = ResourceList.this.getResourceGroups();
                for (ResourceDefinitionGroup aResourceGroup : resourceGroups) {
                    IFilteredCollection<ICMDefinition> resourceGroupDefinitions = aResourceGroup.getDefinitions();
                    resourceGroupDefinitions.setRestrictionCriteriaList(this.restrictionCriteriaList);
                    resourceGroupDefinitions.setObjectName(this.objectCriteria.getObjectName());
                    resourceGroupDefinitions.setObjectType(this.objectCriteria.getObjectType());
                    List<ICMDefinition> resourceGroupDefinitionList = resourceGroupDefinitions.getResults();
                    if (resourceGroupDefinitionList == null) continue;
                    results.addAll(resourceGroupDefinitionList);
                }
                if (results.size() > 0) {
                    return results;
                }
                return null;
            }
        });
        return definitions;
    }

    public static ArrayList<String> getSupportedChecksums() {
        ArrayList<String> results = new ArrayList<String>();
        results.add("NONE");
        results.add("PARTIAL");
        results.add("FULL");
        results.add("NAME");
        return results;
    }
}

